/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xsl.java;

import com.caucho.java.JavaWriter;
import com.caucho.util.CharBuffer;
import com.caucho.xml.QName;
import com.caucho.xsl.XslParseException;
import com.caucho.xsl.java.XslNode;
import com.caucho.xsl.java.XslTopNode;

public class XslVariable
extends XslNode
implements XslTopNode {
    private String _name;
    private String _select;
    private boolean _isGlobal;

    public String getTagName() {
        return "xsl:variable";
    }

    public void setGlobal(boolean isGlobal) {
        this._isGlobal = true;
    }

    public void addAttribute(QName name, String value) throws XslParseException {
        if (name.getName().equals("name")) {
            this._name = value;
        } else if (name.getName().equals("select")) {
            this._select = value;
        } else {
            super.addAttribute(name, value);
        }
    }

    public void endAttributes() throws XslParseException {
        if (this._name == null) {
            throw this.error(L.l("'name' is a required attribute of <xsl:variable>"));
        }
    }

    public void endElement() {
        this.addVariableCount();
    }

    public void generate(JavaWriter out) throws Exception {
        if (this._select != null) {
            int index = this.addExpr(this._select);
            if (this._isGlobal) {
                out.print(new CharBuffer().append("env.setGlobal(\"").append(this._name).append("\", ").toString());
                out.print(new CharBuffer().append("_exprs[").append(index).append("].evalObject(node, env));").toString());
            } else {
                out.print(new CharBuffer().append("_exprs[").append(index).append("]").toString());
                out.println(new CharBuffer().append(".addVar(env, \"").append(this._name).append("\", node, env);").toString());
            }
        } else {
            String id = new CharBuffer().append("frag").append(this._gen.generateId()).toString();
            out.println(new CharBuffer().append("XMLWriter ").append(id).append(" = out.pushFragment();").toString());
            this.generateChildren(out);
            if (this._isGlobal) {
                out.print("env.setGlobal(\"");
            } else {
                out.print("env.addVar(\"");
            }
            out.printJavaString(this._name);
            out.println(new CharBuffer().append("\", out.popFragment(").append(id).append("));").toString());
        }
    }

    protected void printPopScope(JavaWriter out) throws Exception {
    }
}

