/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xsl.java;

import com.caucho.java.JavaWriter;
import com.caucho.util.CharBuffer;
import com.caucho.xml.QName;
import com.caucho.xsl.XslParseException;
import com.caucho.xsl.java.XslNode;
import com.caucho.xsl.java.XslStylesheet;
import com.caucho.xsl.java.XslTopNode;

public class XslParam
extends XslNode
implements XslTopNode {
    private String _name;
    private String _select;
    private String _as;
    private String _require;
    private boolean _isGlobal;

    public String getTagName() {
        return "xsl:param";
    }

    public String getName() {
        return this._name;
    }

    public void setParent(XslNode parent) {
        super.setParent(parent);
        if (parent instanceof XslStylesheet) {
            this._isGlobal = true;
        }
    }

    public void setGlobal(boolean isGlobal) {
        this._isGlobal = true;
    }

    public void addAttribute(QName name, String value) throws XslParseException {
        if (name.getName().equals("name")) {
            this._name = value;
        } else if (name.getName().equals("select")) {
            this._select = value;
        } else if (name.getName().equals("as")) {
            this._as = value;
        } else if (name.getName().equals("require")) {
            this._require = value;
        } else {
            super.addAttribute(name, value);
        }
    }

    public void endAttributes() throws XslParseException {
        if (this._name == null) {
            throw this.error(L.l("xsl:param needs a 'name' attribute."));
        }
        if (this._isGlobal) {
            this._gen.addGlobalParameter(this._name);
        }
    }

    public void generate(JavaWriter out) throws Exception {
        if (this._isGlobal) {
            out.println(new CharBuffer().append("if (out.getParameter(\"").append(this._name).append("\") != null)").toString());
            out.println(new CharBuffer().append("  env.setGlobal(\"").append(this._name).append("\", out.getParameter(\"").append(this._name).append("\"));").toString());
            out.println("else {");
            out.pushDepth();
        }
        if (this._select != null) {
            if (this._isGlobal) {
                out.print(new CharBuffer().append("env.setGlobal(\"").append(this._name).append("\", ").toString());
                out.println(new CharBuffer().append("_exprs[").append(this.addExpr(this._select)).append("].evalObject(node, env));").toString());
            } else {
                out.print(new CharBuffer().append("_exprs[").append(this.addExpr(this._select)).append("]").toString());
                out.println(new CharBuffer().append(".addParam(env, \"").append(this._name).append("\", ").append("node, env);").toString());
            }
        } else if (this.hasChildren()) {
            out.println(new CharBuffer().append("if (env.getVar(\"").append(this._name).append("\") == null) {").toString());
            out.pushDepth();
            String id = new CharBuffer().append("frag").append(this._gen.generateId()).toString();
            out.println(new CharBuffer().append("XMLWriter ").append(id).append(" = out.pushFragment();").toString());
            this.generateChildren(out);
            if (this._isGlobal) {
                out.print("env.setGlobal(\"");
            } else {
                out.print("env.addVar(\"");
            }
            out.printJavaString(this._name);
            out.println(new CharBuffer().append("\", out.popFragment(").append(id).append("));").toString());
            out.popDepth();
            out.println("}");
        }
        if (this._isGlobal) {
            out.popDepth();
            out.println("}");
        }
    }
}

