/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xsl.java;

import com.caucho.java.JavaWriter;
import com.caucho.util.CharBuffer;
import com.caucho.xml.QName;
import com.caucho.xpath.pattern.AbstractPattern;
import com.caucho.xsl.Sort;
import com.caucho.xsl.XslParseException;
import com.caucho.xsl.java.XslNode;
import com.caucho.xsl.java.XslSort;
import java.util.ArrayList;

public class XslApplyTemplates
extends XslNode {
    private String _select;
    private String _mode;
    private ArrayList<XslSort> _sorts = new ArrayList();

    public String getTagName() {
        return "xsl:apply-templates";
    }

    public void addAttribute(QName name, String value) throws XslParseException {
        if (name.getName().equals("select")) {
            this._select = value;
        } else if (name.getName().equals("mode")) {
            this._mode = value;
        } else {
            super.addAttribute(name, value);
        }
    }

    public void endAttributes() throws XslParseException {
    }

    public void addChild(XslNode node) throws XslParseException {
        if (node instanceof XslSort) {
            this._sorts.add((XslSort)node);
        } else {
            super.addChild(node);
        }
    }

    public void generate(JavaWriter out) throws Exception {
        AbstractPattern selectPattern = null;
        if (this._select != null) {
            selectPattern = this.parseSelect(this._select);
        }
        Sort[] sort = null;
        if (this._sorts.size() > 0) {
            sort = new Sort[this._sorts.size()];
            for (int i = 0; i < this._sorts.size(); ++i) {
                sort[i] = this._sorts.get(i).generateSort();
            }
        }
        if (sort != null && selectPattern == null) {
            selectPattern = this.parseSelect("*");
        }
        this.pushCall(out);
        this.generateChildren(out);
        this.printApplyTemplates(out, selectPattern, this._mode, sort);
        this.popCall(out);
    }

    private void printApplyTemplates(JavaWriter out, AbstractPattern select, String mode, Sort[] sort) throws Exception {
        int min = 0;
        int max = Integer.MAX_VALUE;
        String applyName = new CharBuffer().append("applyNode").append(this._gen.getModeName(mode)).toString();
        String env = new CharBuffer().append("_xsl_arg").append(this._gen.getCallDepth()).toString();
        if (select == null && sort == null) {
            out.println("for (Node _xsl_node = node.getFirstChild();");
            out.println("     _xsl_node != null;");
            out.println("     _xsl_node = _xsl_node.getNextSibling()) {");
            out.println(new CharBuffer().append("  ").append(env).append(".setSelect(node, null);").toString());
            out.println(new CharBuffer().append("  ").append(env).append(".setCurrentNode(_xsl_node);").toString());
            out.println(new CharBuffer().append("  ").append(applyName).append("(out, _xsl_node, ").append(env).append(", ").append(min).append(", ").append(max).append(");").toString());
            out.println("}");
        } else if (sort == null) {
            int oldSelectDepth = this._gen.getSelectDepth();
            String name = this.printSelectBegin(out, select, false, null);
            out.println(new CharBuffer().append(env).append(".setSelect(node, _select_patterns[").append(this._gen.addSelect(select)).append("]);").toString());
            out.println(new CharBuffer().append(env).append(".setCurrentNode(").append(name).append(");").toString());
            out.println(new CharBuffer().append(applyName).append("(out, ").append(name).append(", ").append(env).append(", ").append(min).append(", ").append(max).append(");").toString());
            while (this._gen.getSelectDepth() > oldSelectDepth) {
                out.popDepth();
                out.println("}");
                this._gen.popSelectDepth();
            }
        } else {
            int sortIndex = this._gen.addSort(sort);
            out.println("{");
            out.pushDepth();
            out.println(new CharBuffer().append("ArrayList _xsl_list = xslSort(node, env, _select_patterns[").append(this._gen.addSelect(select)).append("]").append(", _xsl_sorts[").append(sortIndex).append("]);").toString());
            out.println(new CharBuffer().append(env).append(".setContextSize(_xsl_list.size());").toString());
            out.println("for (int _xsl_i = 0; _xsl_i < _xsl_list.size(); _xsl_i++) {");
            out.println(new CharBuffer().append("  ").append(env).append(".setContextPosition(_xsl_i + 1);").toString());
            out.println(new CharBuffer().append("  ").append(applyName).append("(out, (Node) _xsl_list.get(_xsl_i)").append(", ").append(env).append(", ").append(min).append(", ").append(max).append(");").toString());
            out.println("}");
            out.popDepth();
            out.println("}");
        }
    }

    protected void popScope(JavaWriter out) throws Exception {
    }
}

