/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xsl;

import com.caucho.Version;
import com.caucho.java.JavaCompiler;
import com.caucho.java.JavaWriter;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.log.Log;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.util.IntArray;
import com.caucho.util.IntMap;
import com.caucho.vfs.Depend;
import com.caucho.vfs.Path;
import com.caucho.vfs.WriteStream;
import com.caucho.xml.QAbstractNode;
import com.caucho.xml.QAttr;
import com.caucho.xml.QElement;
import com.caucho.xml.QName;
import com.caucho.xml.XmlChar;
import com.caucho.xpath.Expr;
import com.caucho.xpath.NamespaceContext;
import com.caucho.xpath.expr.NumericExpr;
import com.caucho.xpath.pattern.AbstractPattern;
import com.caucho.xpath.pattern.FilterPattern;
import com.caucho.xpath.pattern.FromChildren;
import com.caucho.xpath.pattern.FromContext;
import com.caucho.xpath.pattern.FromNextSibling;
import com.caucho.xpath.pattern.FromRoot;
import com.caucho.xpath.pattern.NodePattern;
import com.caucho.xpath.pattern.NodeTypePattern;
import com.caucho.xsl.AbstractStylesheetFactory;
import com.caucho.xsl.Generator;
import com.caucho.xsl.Sort;
import com.caucho.xsl.StylesheetImpl;
import com.caucho.xsl.Template;
import com.caucho.xsl.XslNumberFormat;
import com.caucho.xsl.XslParseException;
import com.caucho.xsl.fun.KeyFun;
import com.caucho.xsl.java.TextNode;
import com.caucho.xsl.java.XslAttribute;
import com.caucho.xsl.java.XslAttributeSet;
import com.caucho.xsl.java.XslElementNode;
import com.caucho.xsl.java.XslNode;
import java.io.IOException;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.logging.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaGenerator
extends Generator {
    private static final Logger log = Log.open(JavaGenerator._resin_compat_class_0());
    private static HashMap<QName, Class> _tagMap = new HashMap();
    private static HashMap<QName, Class> _topTagMap;
    private static int _count;
    Path _path;
    WriteStream _s;
    JavaWriter _out;
    ArrayList<AbstractPattern> _matchPatterns = new ArrayList();
    IntMap _matchMap = new IntMap();
    ArrayList<AbstractPattern> _selectPatterns = new ArrayList();
    IntMap _selectMap = new IntMap();
    ArrayList<Expr> _exprs = new ArrayList();
    IntMap _exprMap = new IntMap();
    ArrayList<Sort[]> _sorts = new ArrayList();
    ArrayList<NamespaceContext> _namespaces = new ArrayList();
    ArrayList<XslNumberFormat> _formats = new ArrayList();
    ArrayList<String> _functions = new ArrayList();
    ArrayList<Template> _templateList = new ArrayList();
    ArrayList<String> _stylesheets = new ArrayList();
    int _templateCount = 0;
    int _unique;
    HashMap<String, String> _macros = new HashMap();
    ArrayList<Object> _fragments = new ArrayList();
    ArrayList<String> _strings = new ArrayList();
    IntMap _stringMap = new IntMap();
    IntArray _envDepth = new IntArray();
    ArrayList<String> _modes = new ArrayList();
    private XslNode _xslNode;
    private boolean _isLineBegin;
    private int _depth;
    private int _callDepth;
    private int _selectDepth;
    private int _selectLoopDepth;
    private int _flagCount;
    private String _className;
    private String _pkg;
    private String _currentPos;
    private ClassLoader _parentLoader;
    private JavaCompiler _compiler;
    private boolean _disableEscaping;
    private boolean _printLocation = true;
    private String _oldFilename = null;
    private int _oldLine = -1;
    private boolean _hasHeader;
    private static Class _resin_compat_class_0;
    private static Class _resin_compat_class_1;
    private static Class _resin_compat_class_2;
    private static Class _resin_compat_class_3;
    private static Class _resin_compat_class_4;
    private static Class _resin_compat_class_5;
    private static Class _resin_compat_class_6;
    private static Class _resin_compat_class_7;
    private static Class _resin_compat_class_8;
    private static Class _resin_compat_class_9;
    private static Class _resin_compat_class_10;
    private static Class _resin_compat_class_11;
    private static Class _resin_compat_class_12;
    private static Class _resin_compat_class_13;
    private static Class _resin_compat_class_14;
    private static Class _resin_compat_class_15;
    private static Class _resin_compat_class_16;
    private static Class _resin_compat_class_17;
    private static Class _resin_compat_class_18;
    private static Class _resin_compat_class_19;
    private static Class _resin_compat_class_20;
    private static Class _resin_compat_class_21;
    private static Class _resin_compat_class_22;
    private static Class _resin_compat_class_23;
    private static Class _resin_compat_class_24;
    private static Class _resin_compat_class_25;
    private static Class _resin_compat_class_26;
    private static Class _resin_compat_class_27;
    private static Class _resin_compat_class_28;
    private static Class _resin_compat_class_29;
    private static Class _resin_compat_class_30;
    private static Class _resin_compat_class_31;
    private static Class _resin_compat_class_32;
    private static Class _resin_compat_class_33;
    private static Class _resin_compat_class_34;
    private static Class _resin_compat_class_35;
    private static Class _resin_compat_class_36;
    private static Class _resin_compat_class_37;
    private static Class _resin_compat_class_38;
    private static Class _resin_compat_class_39;
    private static Class _resin_compat_class_40;

    JavaGenerator(AbstractStylesheetFactory xslGenerator, String className, String encoding) throws IOException {
        super(xslGenerator);
        int p;
        this._parentLoader = xslGenerator.getClassLoader();
        ArrayList pathDepends = new ArrayList();
        this._compiler = JavaCompiler.create(this._parentLoader);
        this._compiler.setClassDir(this._workPath);
        if (encoding != null) {
            if (encoding.equalsIgnoreCase("UTF-16")) {
                encoding = "UTF-8";
                this._compiler.setEncoding(encoding);
            } else {
                this._compiler.setEncoding(encoding);
            }
        }
        if ((p = className.lastIndexOf(46)) >= 0) {
            this._pkg = className.substring(0, p);
            className = className.substring(p + 1);
        } else {
            this._pkg = "_xsl";
        }
        this._className = className;
        this.init(new CharBuffer().append(new CharBuffer().append(this._pkg).append(".").append(className).toString().replace('.', '/')).append(".java").toString());
        String fileName = new CharBuffer().append(new CharBuffer().append(this._pkg).append(".").append(className).toString().replace('.', '/')).append(".java").toString();
        this._path = this._workPath.lookup(fileName);
        this._path.getParent().mkdirs();
        this._s = this._path.openWrite();
        if (encoding != null) {
            this._s.setEncoding(encoding);
        }
        if (this._s.getEncoding() == null || this._s.getEncoding().equals("ISO-8859-1")) {
            this._s.setEncoding("JAVA");
        }
        this._out = new JavaWriter(this._s);
        this._out.setLineMap(this._lineMap);
        this._matchPatterns = new ArrayList();
        this._selectPatterns = new ArrayList();
        this._modes = new ArrayList();
        this._modes.add("");
    }

    @Override
    protected JavaWriter getOut() {
        return this._out;
    }

    public int getSelectDepth() {
        return this._selectDepth;
    }

    public void setSelectDepth(int depth) {
        this._selectDepth = depth;
    }

    public int pushSelectDepth() {
        return ++this._selectDepth;
    }

    public int popSelectDepth() {
        return this._selectDepth--;
    }

    public int getSelectLoopDepth() {
        return this._selectLoopDepth;
    }

    public int pushSelectLoopDepth() {
        return ++this._selectLoopDepth;
    }

    public int popSelectLoopDepth() {
        return this._selectLoopDepth--;
    }

    public void setSelectLoopDepth(int depth) {
        this._selectLoopDepth = depth;
    }

    public int generateId() {
        return this._unique++;
    }

    public void clearUnique() {
        this._unique = 0;
    }

    @Override
    protected void printHeader() throws IOException {
        if (this._hasHeader) {
            return;
        }
        this._hasHeader = true;
        this.println("/*");
        this.println(new CharBuffer().append(" * Generated by ").append(Version.FULL_VERSION).toString());
        this.println(" */");
        this.println();
        this.println(new CharBuffer().append("package ").append(this._pkg).append(";").toString());
        this.println();
        this.println("import java.io.*;");
        this.println("import java.util.*;");
        this.println("import org.w3c.dom.*;");
        this.println("import org.xml.sax.*;");
        this.println("import com.caucho.util.*;");
        this.println("import com.caucho.xml.*;");
        this.println("import com.caucho.xpath.*;");
        this.println("import com.caucho.xpath.expr.*;");
        this.println("import com.caucho.xpath.pattern.*;");
        this.println("import com.caucho.xsl.*;");
        try {
            Class.forName("javax.servlet.Servlet");
            this.println("import javax.servlet.*;");
            this.println("import javax.servlet.jsp.*;");
            this.println("import javax.servlet.http.*;");
        }
        catch (Throwable e) {
            // empty catch block
        }
        for (int i = 0; i < this._imports.size(); ++i) {
            this.println(new CharBuffer().append("import ").append((String)this._imports.get(i)).append(";").toString());
        }
        this.println();
        this.println(new CharBuffer().append("public class ").append(this._className).append(" extends JavaStylesheet {").toString());
        this.pushDepth();
        this.println("private StylesheetEnv stylesheets[];");
    }

    @Override
    protected void generateChild(Node child) throws Exception {
        XslNode node = this.createChild(child);
        if (node != null) {
            node.generate(this._out);
        }
    }

    @Override
    protected XslNode createChild(XslNode parent, Node childNode) throws Exception {
        XslNode xslNode = this._xslNode;
        this._xslNode = parent;
        XslNode child = this.createChild(childNode);
        this._xslNode = xslNode;
        return child;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected XslNode createChild(Node child) throws Exception {
        XslNode xslNode = null;
        if (child instanceof QElement) {
            QElement elt = (QElement)child;
            Class cl = _tagMap.get(elt.getQName());
            if (cl != null) {
                xslNode = (XslNode)cl.newInstance();
                xslNode.setGenerator(this);
                xslNode.setParent(this._xslNode);
                xslNode.setStartLocation(((QAbstractNode)child).getBaseURI(), ((QAbstractNode)child).getFilename(), ((QAbstractNode)child).getLine());
                for (QAttr attr = (QAttr)elt.getFirstAttribute(); attr != null; attr = (QAttr)attr.getNextSibling()) {
                    xslNode.addAttribute(attr.getQName(), attr.getNodeValue());
                }
                xslNode.endAttributes();
                XslNode oldNode = this._xslNode;
                this._xslNode = xslNode;
                for (Node node = elt.getFirstChild(); node != null; node = node.getNextSibling()) {
                    XslNode xslChild = this.createChild(node);
                    if (xslChild == null) continue;
                    xslNode.addChild(xslChild);
                }
                xslNode.endElement();
                this._xslNode = oldNode;
            } else {
                if (child.getNodeName().startsWith("xsl:") && !"http://www.w3.org/1999/XSL/Transform".equals(child.getNamespaceURI())) {
                    throw this.error(child, L.l("<{0}> has an xsl: prefix, but is not in the {1} namespace.  XSL requires an xmlns:xsl=\"{1}\" namespace attribute.", (Object)child.getNodeName(), "http://www.w3.org/1999/XSL/Transform"));
                }
                if ("http://www.w3.org/1999/XSL/Transform".equals(child.getNamespaceURI()) || "http://www.caucho.com/XTP/1.0".equals(child.getNamespaceURI())) throw this.error(child, L.l("<{0}> is an unknown XSL tag.", child.getNodeName()));
                xslNode = new XslElementNode(elt.getQName());
                xslNode.setGenerator(this);
                xslNode.setParent(this._xslNode);
                xslNode.setStartLocation(((QAbstractNode)child).getBaseURI(), ((QAbstractNode)child).getFilename(), ((QAbstractNode)child).getLine());
                for (QAttr attr = (QAttr)elt.getFirstAttribute(); attr != null; attr = (QAttr)attr.getNextSibling()) {
                    xslNode.addAttribute(attr.getQName(), attr.getNodeValue());
                }
                xslNode.endAttributes();
                XslNode oldNode = this._xslNode;
                this._xslNode = xslNode;
                for (Node node = elt.getFirstChild(); node != null; node = node.getNextSibling()) {
                    XslNode xslChild = this.createChild(node);
                    xslNode.addChild(xslChild);
                }
                xslNode.endElement();
                this._xslNode = oldNode;
            }
        } else if (child instanceof Text) {
            xslNode = new TextNode(((Text)child).getData());
            xslNode.setGenerator(this);
            xslNode.setParent(this._xslNode);
        } else if (!(child instanceof Comment) && !(child instanceof ProcessingInstruction)) {
            throw new UnsupportedOperationException(String.valueOf(child));
        }
        if (xslNode == null) return xslNode;
        xslNode.setStartLocation(((QAbstractNode)child).getBaseURI(), ((QAbstractNode)child).getFilename(), ((QAbstractNode)child).getLine());
        return xslNode;
    }

    @Override
    protected void printTemplate(Element absNode, String name, String pattern, String mode, double priority) throws Exception {
        throw new RuntimeException();
    }

    public void addMacro(String name, String functionName) {
        this._macros.put(name, functionName);
    }

    public boolean hasMacro(String name) {
        return this._macros.keySet().contains(name);
    }

    public String createTemplatePattern(String name, AbstractPattern match, String mode, double priority) throws Exception {
        String tagName = name != null ? this.getName(name) : this.getName(match.toString());
        String function = new CharBuffer().append("_xsl_template_").append(tagName).toString();
        this._functions.add(function);
        if (match != null) {
            Template template = this.addPattern(match, mode, priority, function, this._functions.size());
            this._templateList.add(template);
        } else {
            this._templateList.add(null);
        }
        return function;
    }

    @Override
    protected void startDisableEscaping() throws IOException {
        if (!this._isRawText) {
            this.println("out.disableEscaping(true);");
        }
    }

    @Override
    protected void endDisableEscaping() throws IOException {
        if (!this._isRawText) {
            this.println("out.disableEscaping(false);");
        }
    }

    @Override
    protected void writeText(String text) throws Exception {
        if (text == null || text.length() == 0) {
            return;
        }
        int index = this._stringMap.get(text);
        if (index < 0) {
            index = this._strings.size();
            this._stringMap.put(text, index);
            this._strings.add(text);
        }
        this.printLocation(this._systemId, this._filename, this._line);
        this.println(new CharBuffer().append("out.write(_xsl_string").append(index).append(", 0, ").append(text.length()).append(");").toString());
    }

    @Override
    protected void printElement(Node node) throws Exception {
        QElement elt = (QElement)node;
        String name = node.getNodeName();
        if (name.equals("jsp:decl") || name.equals("jsp:declaration")) {
            this.println(new CharBuffer().append("if (out.isFlagFirst(").append(this._flagCount++).append(")) {").toString());
            this.pushDepth();
        }
        String prefix = elt.getPrefix();
        String local = elt.getLocalName();
        String namespace = elt.getNamespaceURI();
        String[] postPrefix = (String[])this._namespaceAliases.get(namespace);
        if (postPrefix != null) {
            prefix = postPrefix[0];
            namespace = postPrefix[1];
            name = prefix == null || prefix.equals("") ? local : new CharBuffer().append(prefix).append(":").append(local).toString();
        }
        if (this._excludedNamespaces.get(namespace) != null) {
            namespace = null;
        }
        this.printLocation(this._systemId, this._filename, this._line);
        if (namespace == null || namespace.equals("")) {
            this.print("out.pushElement(");
            this.print(name == null ? "null" : new CharBuffer().append("\"").append(name).append("\"").toString());
            this.println(");");
        } else {
            this.print("out.pushElement(");
            this.print(namespace == null ? "null" : new CharBuffer().append("\"").append(namespace).append("\"").toString());
            this.print(prefix == null ? ", null" : new CharBuffer().append(", \"").append(prefix).append("\"").toString());
            this.print(local == null ? ", null" : new CharBuffer().append(", \"").append(local).append("\"").toString());
            this.print(name == null ? ", null" : new CharBuffer().append(", \"").append(name).append("\"").toString());
            this.println(");");
        }
        this.printUseAttributeSet((QElement)node, false);
        NamedNodeMap list = node.getAttributes();
        for (int i = 0; i < list.getLength(); ++i) {
            QAbstractNode attr = (QAbstractNode)list.item(i);
            this.printAttribute(attr, elt);
        }
        this.generateChildren(node);
        this.println("out.popElement();");
        if (node.getNodeName().equals("jsp:decl") || node.getNodeName().equals("jsp:declaration")) {
            this.popDepth();
            this.println("}");
        }
    }

    @Override
    public void printLocation(String systemId, String filename, int line) throws Exception {
        if (this._printLocation && filename != null && !this._isSpecial) {
            this.print("out.setLocation(");
            if (systemId != null) {
                this.print("\"");
                this.printString(systemId);
                this.print("\"");
            } else {
                this.print("null");
            }
            this.print(", \"");
            this.printString(filename);
            this.println(new CharBuffer().append("\", ").append(line).append(");").toString());
            this._oldFilename = filename;
            this._oldLine = line;
        }
    }

    private void printAttribute(QAbstractNode attr, QElement elt) throws Exception {
        if (!(attr.getNodeName().equals("xsl:use-attribute-sets") || "http://www.w3.org/1999/XSL/Transform".equals(elt.getNamespace(attr.getPrefix())) || "http://www.caucho.com/XTP/1.0".equals(elt.getNamespace(attr.getPrefix())))) {
            QAbstractNode qnode = attr;
            String prefix = qnode.getPrefix();
            String local = qnode.getLocalName();
            String namespace = qnode.getNamespaceURI();
            String value = attr.getNodeValue();
            String[] postSuffix = (String[])this._namespaceAliases.get(namespace);
            if (postSuffix != null) {
                prefix = postSuffix[0];
                namespace = postSuffix[1];
            } else {
                if (value.equals("http://www.w3.org/1999/XSL/Transform") && prefix.equals("xmlns")) {
                    return;
                }
                if (value.equals("http://www.caucho.com/XTP/1.0") && prefix.equals("xmlns")) {
                    return;
                }
            }
            if (this._excludedNamespaces.get(namespace) != null) {
                namespace = null;
            }
            if ("".equals(prefix) && ("".equals(namespace) || namespace == null)) {
                String var = this.generateStringVar(value, elt);
                this.println(new CharBuffer().append("out.setAttribute(\"").append(local).append("\", ").append(var).append(");").toString());
            } else {
                this.print("out.pushAttribute(");
                this.print(prefix == null ? "null" : new CharBuffer().append("\"").append(prefix).append("\"").toString());
                this.print(local == null ? ", null" : new CharBuffer().append(", \"").append(local).append("\"").toString());
                this.print(namespace == null ? ", null" : new CharBuffer().append(", \"").append(namespace).append("\"").toString());
                this.println(");");
                this.generateString(value, 44, elt);
                this.println("out.popAttribute();");
            }
        }
    }

    @Override
    protected void pushCall() throws IOException {
        this.println("{");
        this.pushDepth();
        ++this._callDepth;
        this.println(new CharBuffer().append("Env _xsl_arg").append(this._callDepth).append(" = XPath.createCall(env);").toString());
    }

    public int pushCallDepth() {
        return ++this._callDepth;
    }

    public int popCallDepth() {
        return this._callDepth--;
    }

    public int getCallDepth() {
        return this._callDepth;
    }

    @Override
    protected void popCall() throws IOException {
        --this._callDepth;
        this.popDepth();
        this.println("}");
    }

    @Override
    protected void printApplyTemplates(AbstractPattern select, String mode, Sort[] sort) throws Exception {
        int min = 0;
        int max = Integer.MAX_VALUE;
        String applyName = new CharBuffer().append("applyNode").append(this.getModeName(mode)).toString();
        String env = new CharBuffer().append("_xsl_arg").append(this._callDepth).toString();
        if (select == null && sort == null) {
            this.println("for (Node _xsl_node = node.getFirstChild();");
            this.println("     _xsl_node != null;");
            this.println("     _xsl_node = _xsl_node.getNextSibling()) {");
            this.println(new CharBuffer().append("  ").append(env).append(".setSelect(node, null);").toString());
            this.println(new CharBuffer().append("  ").append(env).append(".setCurrentNode(_xsl_node);").toString());
            this.println(new CharBuffer().append("  ").append(applyName).append("(out, _xsl_node, ").append(env).append(", ").append(min).append(", ").append(max).append(");").toString());
            this.println("}");
        } else if (sort == null) {
            int oldSelectDepth = this._selectDepth;
            this.println(new CharBuffer().append(env).append(".setSelect(node, _select_patterns[").append(this.addSelect(select)).append("]);").toString());
            String name = this.printSelectBegin(select, false, null);
            this.println(new CharBuffer().append(env).append(".setCurrentNode(").append(name).append(");").toString());
            this.println(new CharBuffer().append(applyName).append("(out, ").append(name).append(", ").append(env).append(", ").append(min).append(", ").append(max).append(");").toString());
            while (this._selectDepth > oldSelectDepth) {
                this.popDepth();
                this.println("}");
                --this._selectDepth;
            }
        } else {
            this.println("{");
            this.pushDepth();
            this.println(new CharBuffer().append("ArrayList _xsl_list = xslSort(node, env, _select_patterns[").append(this.addSelect(select)).append("]").append(", _xsl_sorts[").append(this._sorts.size()).append("]);").toString());
            this.println(new CharBuffer().append(env).append(".setContextSize(_xsl_list.size());").toString());
            this.println("for (int _xsl_i = 0; _xsl_i < _xsl_list.size(); _xsl_i++) {");
            this.println(new CharBuffer().append("  ").append(env).append(".setContextPosition(_xsl_i + 1);").toString());
            this.println(new CharBuffer().append("  ").append(applyName).append("(out, (Node) _xsl_list.get(_xsl_i)").append(", ").append(env).append(", ").append(min).append(", ").append(max).append(");").toString());
            this.println("}");
            this.popDepth();
            this.println("}");
            this._sorts.add(sort);
        }
    }

    public int addSort(Sort[] sort) {
        int index = this._sorts.size();
        this._sorts.add(sort);
        return index;
    }

    @Override
    protected void printApplyImports(String mode, int min, int max) throws Exception {
    }

    @Override
    protected void printCallTemplate(String name, String mode) throws Exception {
        this.println(new CharBuffer().append(this.getMacroName(name)).append("(out, node, _xsl_arg").append(this._callDepth).append(");").toString());
    }

    public String getMacroName(String name) {
        return this._macros.get(name);
    }

    @Override
    protected void printParam(String name, String value, Element elt) throws Exception {
        this.print(new CharBuffer().append("_xsl_arg").append(this._callDepth).append(".addVar(\"").append(name).append("\", ").toString());
        this.generateString(value, 43, elt);
        this.println(");");
    }

    @Override
    protected void printParam(String name, Object value) throws Exception {
        if (value instanceof Expr) {
            this.print(new CharBuffer().append("_exprs[").append(this.addExpr((Expr)value)).append("]").toString());
            this.println(new CharBuffer().append(".addVar(_xsl_arg").append(this._callDepth).append(", \"").append(name).append("\", ").append("node, env);").toString());
        } else {
            this.print(new CharBuffer().append("_xsl_arg").append(this._callDepth).append(".addVar(\"").toString());
            this.print(name);
            this.print("\", ");
            this.printVariableValue(value);
            this.println(");");
        }
    }

    @Override
    protected void printParamVariable(String name, Expr value) throws Exception {
        this.print(new CharBuffer().append("_exprs[").append(this.addExpr(value)).append("]").toString());
        this.println(new CharBuffer().append(".addParam(env, \"").append(name).append("\", ").append("node, env);").toString());
    }

    @Override
    protected void printParamVariable(String name, Element value) throws Exception {
        if (value.getFirstChild() != null) {
            this.println(new CharBuffer().append("_xsl_tmp = env.getVar(\"").append(name).append("\");").toString());
            this.println("if (_xsl_tmp == null)");
            this.print("  _xsl_tmp = ");
            this.printVariableValue(value);
            this.println(";");
            this.println(new CharBuffer().append("env.addVar(\"").append(name).append("\", _xsl_tmp);").toString());
        }
    }

    @Override
    protected void printVariable(String name, Object value) throws Exception {
        if (value instanceof Expr) {
            this.print(new CharBuffer().append("_exprs[").append(this.addExpr((Expr)value)).append("]").toString());
            this.println(new CharBuffer().append(".addVar(env, \"").append(name).append("\", node, env);").toString());
        } else {
            this.print("env.addVar(\"");
            this.print(name);
            this.print("\", ");
            this.printVariableValue(value);
            this.println(");");
        }
    }

    @Override
    protected void printAssign(String name, Object value) throws Exception {
        if (value instanceof Expr) {
            this.print(new CharBuffer().append("_exprs[").append(this.addExpr((Expr)value)).append("]").toString());
            this.println(new CharBuffer().append(".setVar(\"").append(name).append("\", node, env, node);").toString());
        } else {
            this.print("env.setVar(\"");
            this.print(name);
            this.print("\", ");
            this.printVariableValue(value);
            this.println(");");
        }
    }

    private void printVariableValue(Object value) throws Exception {
        if (value instanceof Expr) {
            this.print(new CharBuffer().append("_exprs[").append(this.addExpr((Expr)value)).append("].evalObject(node, env)").toString());
        } else if (value instanceof Node) {
            this.print(new CharBuffer().append("_xsl_fragment").append(this._fragments.size()).append("(out, node, env)").toString());
            this._fragments.add(value);
        } else {
            throw new RuntimeException();
        }
    }

    @Override
    protected void printPopScope(int count) throws Exception {
        if (count > 0) {
            this.println(new CharBuffer().append("env.popVars(").append(count).append(");").toString());
        }
    }

    @Override
    protected void printCopyOf(String select, Element elt) throws Exception {
        this.println(new CharBuffer().append("out.copyOf(_exprs[ ").append(this.addExpr(select)).append("].evalObject(node, env));").toString());
    }

    @Override
    protected void printSelectValue(String select, Element elt) throws Exception {
        this.printStringExpr(select, elt);
    }

    @Override
    protected void printForEach(Element element, String select) throws Exception {
        this.println("{");
        this.pushDepth();
        AbstractPattern selectPattern = null;
        try {
            selectPattern = this.parseSelect(select);
        }
        catch (Exception e) {
            // empty catch block
        }
        boolean hasExprEnv = !this.allowJavaSelect(selectPattern);
        int id = this._unique++;
        String sel = new CharBuffer().append("_xsl_sel").append(id).toString();
        String oldCxt = new CharBuffer().append("_xsl_cxt").append(id).toString();
        String oldCur = new CharBuffer().append("_xsl_cur").append(id).toString();
        String oldSel = new CharBuffer().append("_xsl_old_sel").append(id).toString();
        String oldEnv = new CharBuffer().append("_xsl_env").append(id).toString();
        this.println(new CharBuffer().append("com.caucho.xpath.pattern.AbstractPattern ").append(sel).append(";").toString());
        this.print(new CharBuffer().append(sel).append(" = _select_patterns[").toString());
        this.print(this.createNodeSet(select, element));
        this.println("];");
        this.println(new CharBuffer().append("Node ").append(oldCxt).append(" = env.getContextNode();").toString());
        this.println(new CharBuffer().append("Node ").append(oldCur).append(" = env.getCurrentNode();").toString());
        if (!hasExprEnv) {
            this.println(new CharBuffer().append("AbstractPattern ").append(oldSel).append(" = env.setSelect(node, ").append(sel).append(");").toString());
        }
        String iter = new CharBuffer().append("_xsl_iter").append(this._unique++).toString();
        int oldSelectDepth = this._selectDepth++;
        boolean hasEnv = false;
        if (this.allowJavaSelect(selectPattern)) {
            this.println(new CharBuffer().append("ExprEnvironment ").append(oldEnv).append(" = env.setExprEnv(null);").toString());
            String ptr = this.printSelectBegin(selectPattern, true, null);
            this.pushLoop();
            this.println(new CharBuffer().append("Node ").append(this.getElement()).append(" = node;").toString());
            this.println(new CharBuffer().append("node = ").append(ptr).append(";").toString());
        } else {
            this.print(new CharBuffer().append("NodeIterator ").append(iter).append(" = ").append(sel).toString());
            this.println(new CharBuffer().append(".select(node, ").append(this.getEnv()).append(");").toString());
            this.println(new CharBuffer().append("ExprEnvironment ").append(oldEnv).append(" = env.setExprEnv(").append(iter).append(");").toString());
            this.println(new CharBuffer().append("while (").append(iter).append(".hasNext()) {").toString());
            this.pushDepth();
            this.pushLoop();
            this.println(new CharBuffer().append("Node ").append(this.getElement()).append(" = node;").toString());
            this.println(new CharBuffer().append("node = ").append(iter).append(".nextNode();").toString());
        }
        this.println("env.setCurrentNode(node);");
        AbstractPattern oldNodeListContext = this._nodeListContext;
        this._nodeListContext = this.parseMatch(select);
        this.generateChildren(element);
        this._nodeListContext = oldNodeListContext;
        this.println(new CharBuffer().append("node = ").append(this.getElement()).append(";").toString());
        this.println(new CharBuffer().append("env.setCurrentNode(").append(oldCur).append(");").toString());
        while (this._selectDepth > oldSelectDepth) {
            this.popDepth();
            this.println("}");
            --this._selectDepth;
        }
        this.println(new CharBuffer().append("env.setExprEnv(").append(oldEnv).append(");").toString());
        if (!hasExprEnv) {
            this.println(new CharBuffer().append("env.setSelect(").append(oldCxt).append(", ").append(oldSel).append(");").toString());
        }
        this.popDepth();
        this.println("}");
        this.popLoop();
    }

    @Override
    protected void printForEach(Element element, String select, Sort[] sort) throws Exception {
        this.println("{");
        this.pushDepth();
        this.println("env.setCurrentNode(node);");
        String pos = new CharBuffer().append("_xsl_pos").append(this._unique++).toString();
        String list = new CharBuffer().append("_xsl_list").append(this._unique++).toString();
        this.println(new CharBuffer().append("ArrayList ").append(list).append(" = xslSort(node, env").append(", _select_patterns[").append(this.addSelect(select)).append("]").append(", _xsl_sorts[").append(this._sorts.size()).append("]);").toString());
        this.println(new CharBuffer().append("env.setContextSize(").append(list).append(".size());").toString());
        this.println(new CharBuffer().append("for (int ").append(pos).append(" = 1; ").append(pos).append(" <= ").append(list).append(".size(); ").append(pos).append("++) {").toString());
        this.pushLoop();
        this.pushDepth();
        this.println(new CharBuffer().append("Node ").append(this.getElement()).append(" = node;").toString());
        this.println(new CharBuffer().append("node = (Node) ").append(list).append(".get(").append(pos).append(" - 1);").toString());
        String oldPos = this._currentPos;
        this._currentPos = pos;
        this.println(new CharBuffer().append("env.setPosition(").append(this._currentPos).append(");").toString());
        this._sorts.add(sort);
        AbstractPattern oldNodeListContext = this._nodeListContext;
        this._nodeListContext = this.parseMatch(select);
        this.generateChildren(element);
        this._currentPos = oldPos;
        this._nodeListContext = oldNodeListContext;
        this.println(new CharBuffer().append("node = ").append(this.getElement()).append(";").toString());
        this.popDepth();
        this.println("}");
        this.popLoop();
        this.popDepth();
        this.println("}");
    }

    public String getCurrentPosition() {
        return this._currentPos;
    }

    public void setCurrentPosition(String pos) {
        this._currentPos = pos;
    }

    @Override
    public AbstractPattern getNodeListContext() {
        return this._nodeListContext;
    }

    public void setNodeListContext(AbstractPattern context) {
        this._nodeListContext = context;
    }

    @Override
    protected void printIf(Element element, Expr test) throws Exception {
        this.print("if (");
        this.printExprTest(test, "node");
        this.println(") {");
        this.pushDepth();
        this.generateChildren(element);
        this.popDepth();
        this.println("}");
    }

    @Override
    protected void printChoose(Element element, Expr expr, boolean first) throws Exception {
        if (!first) {
            this.print("else if (");
        } else {
            this.print("if (");
        }
        this.printExprTest(expr, "node");
        this.println(") {");
        this.pushDepth();
        this.generateChildren(element);
        this.popDepth();
        this.println("}");
    }

    @Override
    protected void printOtherwise(Element element, boolean first) throws Exception {
        if (!first) {
            this.print("else ");
        }
        this.println("{");
        this.pushDepth();
        this.generateChildren(element);
        this.popDepth();
        this.println("}");
    }

    @Override
    void printNumber(Expr expr, XslNumberFormat format) throws Exception {
        this.print(new CharBuffer().append("exprNumber(out, node, env, _exprs[").append(this.addExpr(expr)).append("]").toString());
        this.print(new CharBuffer().append(", _xsl_formats[").append(this._formats.size()).append("]").toString());
        this.println(");");
        this._formats.add(format);
    }

    @Override
    void printNumber(String level, AbstractPattern countPattern, AbstractPattern fromPattern, XslNumberFormat format) throws Exception {
        if (level.equals("single")) {
            this.print("singleNumber(out, ");
        } else if (level.equals("multiple")) {
            this.print("multiNumber(out, ");
        } else if (level.equals("any")) {
            this.print("anyNumber(out, ");
        } else {
            throw this.error(new CharBuffer().append("xsl:number cannot understand level=`").append(level).append("'").toString());
        }
        this.print("node, env, ");
        this.printPattern(countPattern);
        this.print(", ");
        this.printPattern(fromPattern);
        this.print(new CharBuffer().append(", _xsl_formats[").append(this._formats.size()).append("]").toString());
        this.println(");");
        this._formats.add(format);
    }

    public int addFormat(XslNumberFormat format) {
        int index = this._formats.size();
        this._formats.add(format);
        return index;
    }

    @Override
    protected void printCopy(Element element) throws Exception {
        this.println("out.pushCopy(node);");
        this.printUseAttributeSet(element, true);
        this.generateChildren(element);
        this.println("out.popCopy(node);");
    }

    @Override
    protected void printResultDocument(Element element, String href, String format) throws Exception {
        this.println("XslWriter oldOut = out;");
        this.println("OutputStream os = null;");
        this.println("try {");
        this.pushDepth();
        this.print("os = out.openWrite(env, ");
        this.generateString(href, 43, element);
        this.println(");");
        this.println("out = out.openResultDocument(os);");
        this.generateChildren(element);
        this.println("out.close();");
        this.popDepth();
        this.println("} finally {");
        this.println("  if (os != null)");
        this.println("    os.close();");
        this.println("  out = oldOut;");
        this.println("}");
    }

    @Override
    protected void printElement(Element element, String name) throws Exception {
        this.print("out.pushElement(");
        this.generateString(name, 43, element);
        if (this._namespace != null) {
            this.print(", ");
            this.printNamespace(this._namespace);
        }
        this.println(");");
        this.printUseAttributeSet(element, true);
        this.generateChildren(element);
        this.println("out.popElement();");
    }

    @Override
    protected void printElement(Element element, String name, String namespace) throws Exception {
        this.print("out.pushElementNs(");
        this.generateString(name, 43, element);
        this.print(", ");
        this.generateString(namespace, 43, element);
        this.println(");");
        this.printUseAttributeSet(element, true);
        this.generateChildren(element);
        this.print("out.popElement();");
    }

    private void printUseAttributeSet(Element element, boolean isXSL) throws Exception {
        for (Attr attr = ((QElement)element).getFirstAttribute(); attr != null; attr = (Attr)attr.getNextSibling()) {
            HashMap<String, String> set;
            if ((!isXSL || !attr.getNodeName().equals("use-attribute-sets")) && (isXSL || !attr.getNodeName().equals("xsl:use-attribute-sets")) || (set = this.getAttributeSet(attr.getNodeValue())) == null) continue;
            for (String key : set.keySet()) {
                String value = set.get(key);
                this.printAttributeValue(key, value, element);
            }
        }
    }

    public HashMap<String, String> getAttributeSet(String name) {
        CharBuffer cb = CharBuffer.allocate();
        int i = 0;
        int len = name.length();
        HashMap<String, String> map = new HashMap<String, String>();
        while (i < len) {
            XslAttributeSet newSet;
            while (i < len && name.charAt(i) == ' ') {
                ++i;
            }
            cb.clear();
            while (i < len && name.charAt(i) != ' ') {
                cb.append(name.charAt(i));
                ++i;
            }
            if (cb.length() <= 0 || (newSet = (XslAttributeSet)this._attributeSets.get(cb.toString())) == null) continue;
            ArrayList<XslAttribute> attrList = newSet.getAttributes();
            for (int j = 0; j < attrList.size(); ++j) {
                XslAttribute attr = attrList.get(j);
                map.put(attr.getName(), attr.getValue());
            }
        }
        return map;
    }

    public ArrayList<XslAttribute> getAttributeSetList(String name) {
        CharBuffer cb = CharBuffer.allocate();
        int i = 0;
        int len = name.length();
        ArrayList<XslAttribute> set = new ArrayList<XslAttribute>();
        while (i < len) {
            XslAttributeSet newSet;
            while (i < len && name.charAt(i) == ' ') {
                ++i;
            }
            cb.clear();
            while (i < len && name.charAt(i) != ' ') {
                cb.append(name.charAt(i));
                ++i;
            }
            if (cb.length() <= 0 || (newSet = (XslAttributeSet)this._attributeSets.get(cb.toString())) == null) continue;
            set.addAll(newSet.getAttributes());
        }
        return set;
    }

    @Override
    protected void printAttribute(Element element, String name) throws Exception {
        this.print("out.pushAttribute(");
        this.generateString(name, 43, element);
        if (this._namespace != null) {
            this.print(", ");
            this.printNamespace(this._namespace);
        }
        this.println(");");
        this.generateChildren(element);
        this.println("out.popAttribute();");
    }

    private void printAttributeValue(String key, String value, Element elt) throws Exception {
        if (this._namespace == null && !this.attributeHasSpecial(key) && !this.attributeHasSpecial(value)) {
            this.print("out.setAttribute(");
            this.generateString(key, 43, elt);
            this.print(", ");
            this.generateString(value, 43, elt);
            this.println(");");
        } else {
            this.print("out.pushAttribute(");
            this.generateString(key, 43, elt);
            if (this._namespace != null) {
                this.print(", ");
                this.printNamespace(this._namespace);
            }
            this.println(");");
            this.generateString(value, 44, elt);
            this.println("out.popAttribute();");
        }
    }

    public void printNamespace(NamespaceContext namespace) throws Exception {
        for (int i = 0; i < this._namespaces.size(); ++i) {
            if (!this._namespaces.get(i).equals(namespace)) continue;
            this.print(new CharBuffer().append("_namespaces[").append(i).append("]").toString());
            return;
        }
        this.print(new CharBuffer().append("_namespaces[").append(this._namespaces.size()).append("]").toString());
        this._namespaces.add(namespace);
    }

    public int addNamespace(NamespaceContext namespace) throws Exception {
        for (int i = 0; i < this._namespaces.size(); ++i) {
            if (!this._namespaces.get(i).equals(namespace)) continue;
            return i;
        }
        this._namespaces.add(namespace);
        return this._namespaces.size() - 1;
    }

    @Override
    protected void printAttribute(Element element, String name, String namespace) throws Exception {
        this.print("out.pushAttributeNs(");
        this.generateString(name, 43, element);
        this.print(", ");
        this.generateString(namespace, 43, element);
        this.println(");");
        this.generateChildren(element);
        this.println("out.popAttribute();");
    }

    @Override
    protected void printPi(Element element) throws Exception {
        String name = element.getAttribute("name");
        if (name.equals("")) {
            throw this.error("xsl:pi expected `name' attribute.");
        }
        this.print("out.pushPi();");
        this.generateChildren(element);
        this.println("out.popPi(");
        this.generateString(name, 43, element);
        this.println(");");
    }

    @Override
    protected void printComment(Element element) throws Exception {
        this.println("out.pushComment();");
        this.generateChildren(element);
        this.println("out.popComment();");
    }

    @Override
    protected void printError(String msg) throws Exception {
        this.println(new CharBuffer().append("if (true) throw new javax.xml.transform.TransformerException(\"").append(msg).append("\");").toString());
    }

    @Override
    protected void printMessage(Element msg) throws Exception {
        int unique = this._unique++;
        this.println(new CharBuffer().append("XMLWriter frag").append(unique).append(" = out.pushFragment();").toString());
        this.generateChildren(msg);
        String terminate = msg.getAttribute("terminate");
        if (terminate.equals("yes")) {
            this.println(new CharBuffer().append("if (true) throw new javax.xml.transform.TransformerException(((QAbstractNode) out.popFragment(frag").append(unique).append(")).getTextValue());").toString());
        } else {
            this.println(new CharBuffer().append("System.err.println(((QAbstractNode) out.popFragment(frag").append(unique).append(")).getTextValue());").toString());
        }
    }

    @Override
    protected void printExpression(Element element) throws Exception {
        String expr = element.getAttribute("expr");
        if (!expr.equals("")) {
            this.print("out.print(");
            this.print(expr);
            this.println(");");
        } else {
            this.print("out.print(");
            this.print(((QAbstractNode)((Object)element)).getTextValue());
            this.println(");");
        }
    }

    @Override
    protected void printScriptlet(Element element) throws Exception {
        this.println(((QAbstractNode)((Object)element)).getTextValue());
    }

    @Override
    protected void printWhile(Element element, Expr test) throws Exception {
        this.print("while (");
        this.printExprTest(test, "node");
        this.println(") {");
        this.pushDepth();
        this.generateChildren(element);
        this.popDepth();
        this.println("}");
    }

    @Override
    protected void printDeclaration(Element element) throws Exception {
        this.println(((QAbstractNode)((Object)element)).getTextValue());
    }

    @Override
    protected void printCacheDepends(String name) throws Exception {
        this.print("out.addCacheDepend(((com.caucho.vfs.Path) out.getProperty(\"caucho.pwd\")).lookup(\"");
        this.printString(name);
        this.println("\"));");
    }

    public String getElement() {
        return new CharBuffer().append("node").append(this._loopDepth).toString();
    }

    public void pushLoop() {
        ++this._loopDepth;
    }

    public void popLoop() {
        --this._loopDepth;
    }

    public String getEnv() {
        return "env";
    }

    void pushEnv() {
        this._envDepth.add(0);
    }

    void popEnv() {
        this._envDepth.pop();
    }

    void printPattern(AbstractPattern pattern) throws Exception {
        if (pattern == null) {
            this.print("null");
        } else {
            this.print(new CharBuffer().append("_match_patterns[").append(this._matchPatterns.size()).append("]").toString());
            this._matchPatterns.add(pattern);
        }
    }

    private int createNodeSet(String select, Element element) throws Exception {
        return this.addSelect(select);
    }

    int createSelectPattern(AbstractPattern pattern) throws Exception {
        return this.addSelect(pattern);
    }

    int createMatchPattern(String select, Element element) throws Exception {
        AbstractPattern pattern = this.parseMatch(select);
        this._matchPatterns.add(pattern);
        return this._matchPatterns.size() - 1;
    }

    String getName(String tag) {
        int i;
        CharBuffer newTag = new CharBuffer();
        block4: for (i = 0; i < tag.length(); ++i) {
            char ch = tag.charAt(i);
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case '(': 
                case ')': {
                    continue block4;
                }
                case '.': 
                case ':': 
                case '|': {
                    newTag.append('_');
                    continue block4;
                }
                default: {
                    if (!(ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z') && (ch < '0' || ch > '9')) continue block4;
                    newTag.append(ch);
                }
            }
        }
        tag = newTag.toString();
        if (this._names.get(tag) == null) {
            this._names.put(tag, tag);
            return tag;
        }
        i = 0;
        while (true) {
            String subname;
            if (this._names.get(subname = new CharBuffer().append(tag).append(i).toString()) == null) {
                this._names.put(subname, subname);
                return subname;
            }
            ++i;
        }
    }

    void printExprTest(Expr expr, String element) throws Exception {
        this.print(new CharBuffer().append("_exprs[").append(this.addExpr(expr)).append("].evalBoolean(").append(element).append(", ").append(this.getEnv()).append(")").toString());
    }

    public void printExprTest(int exprId, String element) throws Exception {
        this.print(new CharBuffer().append("_exprs[").append(exprId).append("].evalBoolean(").append(element).append(", ").append(this.getEnv()).append(")").toString());
    }

    private boolean attributeHasSpecial(String string) {
        int length = string.length();
        for (int i = 0; i < length; ++i) {
            char ch = string.charAt(i);
            if (ch == '{' && i + 1 < length) {
                if (string.charAt(i + 1) == '{') {
                    ++i;
                    continue;
                }
                return true;
            }
            if (i + 2 >= length || ch != '<' || string.charAt(i + 1) != '#' || string.charAt(i + 2) != '=') continue;
            return true;
        }
        return false;
    }

    void generateString(String string, int mode, Element elt) throws Exception {
        CharBuffer cb = new CharBuffer();
        boolean first = true;
        int length = string.length();
        for (int i = 0; i < length; ++i) {
            char ch = string.charAt(i);
            if (ch == '\n') {
                cb.append("\\n");
                continue;
            }
            if (ch == '\"') {
                cb.append("\\\"");
                continue;
            }
            if (ch == '{' && i + 1 < length) {
                if (string.charAt(i + 1) == '{') {
                    cb.append('{');
                    ++i;
                    continue;
                }
                if (mode == 44) {
                    if (cb.length() > 0) {
                        this.println(new CharBuffer().append("out.print(\"").append(cb.toString()).append("\");").toString());
                    }
                } else {
                    if (!first) {
                        this.print((char)mode);
                    }
                    if (cb.length() > 0) {
                        this.print("\"");
                        this.print(cb.toString());
                        this.print("\"");
                        this.print((char)mode);
                    }
                }
                cb.clear();
                ++i;
                while (i < length && string.charAt(i) != '}') {
                    cb.append(string.charAt(i));
                    ++i;
                }
                if (mode == 44) {
                    this.printStringExpr(cb.toString(), elt);
                } else {
                    this.stringExpr(cb.toString(), elt);
                }
                cb.clear();
                first = false;
                continue;
            }
            if (ch == '}' && i + 1 < length) {
                if (string.charAt(i + 1) == '}') {
                    cb.append('}');
                    ++i;
                    continue;
                }
                cb.append('}');
                continue;
            }
            if (i + 2 < length && ch == '<' && string.charAt(i + 1) == '#' && string.charAt(i + 2) == '=') {
                if (mode == 44) {
                    if (cb.length() > 0) {
                        this.println(new CharBuffer().append("out.print(\"").append(cb.toString()).append("\");").toString());
                    }
                } else {
                    if (!first) {
                        this.print((char)mode);
                    }
                    if (cb.length() > 0) {
                        this.print("\"");
                        this.print(cb.toString());
                        this.print("\"");
                        this.print((char)mode);
                    }
                }
                cb.clear();
                i += 3;
                while (i + 1 < length && string.charAt(i) != '#' && string.charAt(i + 1) != '>') {
                    cb.append(string.charAt(i));
                    ++i;
                }
                ++i;
                if (mode == 44) {
                    this.println(new CharBuffer().append("out.print(").append((Object)cb).append(");").toString());
                } else {
                    this.print(new CharBuffer().append("(").append((Object)cb).append(")").toString());
                }
                cb.clear();
                first = false;
                continue;
            }
            cb.append(ch);
        }
        if (cb.length() > 0) {
            if (mode == 44) {
                this.println(new CharBuffer().append("out.print(\"").append((Object)cb).append("\");").toString());
            } else {
                if (!first) {
                    this.print((char)mode);
                }
                this.print(new CharBuffer().append("\"").append((Object)cb).append("\"").toString());
            }
        } else if (first && mode == 43) {
            this.print("\"\"");
        }
    }

    String generateStringVar(String string, Element elt) throws Exception {
        CharBuffer cb = new CharBuffer();
        boolean first = true;
        int length = string.length();
        String strVar = new CharBuffer().append("_xsl_str").append(this._unique++).toString();
        if (string.indexOf(123) < 0 && string.indexOf(125) < 0) {
            this.print(new CharBuffer().append("String ").append(strVar).append(" = \"").toString());
            this.printString(string);
            this.println("\";");
            return strVar;
        }
        if (string.lastIndexOf(123) == 0 && string.indexOf(125) == string.length() - 1) {
            this.println(new CharBuffer().append("String ").append(strVar).append(" = \"\";").toString());
            string = string.substring(1, string.length() - 1);
            this.addStringExpr(strVar, string, elt, true);
            return strVar;
        }
        String cbVar = new CharBuffer().append("_xsl_cb").append(this._unique++).toString();
        this.println(new CharBuffer().append("com.caucho.util.CharBuffer ").append(cbVar).append(" = com.caucho.util.CharBuffer.allocate();").toString());
        for (int i = 0; i < length; ++i) {
            char ch = string.charAt(i);
            if (ch == '\n') {
                cb.append("\\n");
                continue;
            }
            if (ch == '\"') {
                cb.append("\\\"");
                continue;
            }
            if (ch == '{' && i + 1 < length) {
                if (string.charAt(i + 1) == '{') {
                    cb.append('{');
                    ++i;
                    continue;
                }
                if (cb.length() > 0) {
                    this.println(new CharBuffer().append(cbVar).append(".append(\"").append(cb.toString()).append("\");").toString());
                }
                cb.clear();
                ++i;
                while (i < length && string.charAt(i) != '}') {
                    cb.append(string.charAt(i));
                    ++i;
                }
                this.addStringExpr(cbVar, cb.toString(), elt, false);
                cb.clear();
                first = false;
                continue;
            }
            if (ch == '}' && i + 1 < length) {
                if (string.charAt(i + 1) == '}') {
                    cb.append('}');
                    ++i;
                    continue;
                }
                cb.append('}');
                continue;
            }
            if (i + 2 < length && ch == '<' && string.charAt(i + 1) == '#' && string.charAt(i + 2) == '=') {
                if (cb.length() > 0) {
                    this.println(new CharBuffer().append(cbVar).append(".append(\"").append(cb.toString()).append("\");").toString());
                }
                cb.clear();
                i += 3;
                while (i + 1 < length && string.charAt(i) != '#' && string.charAt(i + 1) != '>') {
                    cb.append(string.charAt(i));
                    ++i;
                }
                ++i;
                this.println(new CharBuffer().append(cbVar).append(".append(").append((Object)cb).append(");").toString());
                cb.clear();
                first = false;
                continue;
            }
            cb.append(ch);
        }
        if (cb.length() > 0) {
            this.println(new CharBuffer().append(cbVar).append(".append(\"").append((Object)cb).append("\");").toString());
        }
        this.println(new CharBuffer().append("String ").append(strVar).append(" = ").append(cbVar).append(".close();").toString());
        return strVar;
    }

    private void printStringExpr(String exprString, Element elt) throws Exception {
        int length = exprString.length();
        if (length == 0) {
            return;
        }
        AbstractPattern select = null;
        try {
            select = this.parseSelect(exprString);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (exprString.equals(".")) {
            this.println("out.valueOf(node);");
            return;
        }
        if (exprString.charAt(0) == '@') {
            boolean isSimple = true;
            for (int i = 1; i < length; ++i) {
                char ch = exprString.charAt(i);
                if (XmlChar.isNameChar(ch) && ch != ':') continue;
                isSimple = false;
            }
            if (isSimple) {
                this.println("if (node instanceof Element)");
                this.print("  out.print(((Element) node).getAttribute(\"");
                this.print(exprString.substring(1));
                this.println("\"));");
                return;
            }
        } else if (this.allowJavaSelect(select)) {
            int oldSelectDepth = this._selectDepth;
            String loop = new CharBuffer().append("_xsl_loop").append(this._unique++).toString();
            this._selectLoopDepth = 0;
            String ptr = this.printSelectBegin(select, true, loop);
            this.println(new CharBuffer().append("out.valueOf(").append(ptr).append(");").toString());
            this.println(new CharBuffer().append("break ").append(loop).append(";").toString());
            while (this._selectDepth > oldSelectDepth) {
                this.popDepth();
                this.println("}");
                --this._selectDepth;
            }
            return;
        }
        this.println(new CharBuffer().append("out.valueOf(_exprs[").append(this.addExpr(exprString)).append("].evalObject(node, ").append(this.getEnv()).append("));").toString());
    }

    private void addStringExpr(String var, String exprString, Element elt, boolean isSingleString) throws Exception {
        int length = exprString.length();
        if (length == 0) {
            return;
        }
        AbstractPattern select = null;
        try {
            select = this.parseSelect(exprString);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (exprString.equals(".")) {
            if (isSingleString) {
                this.println(new CharBuffer().append(var).append(" = XmlUtil.textValue(node);").toString());
            } else {
                this.println(new CharBuffer().append("XmlUtil.textValue(").append(var).append(", node);").toString());
            }
            return;
        }
        if (exprString.charAt(0) == '@') {
            boolean isSimple = true;
            for (int i = 1; i < length; ++i) {
                char ch = exprString.charAt(i);
                if (XmlChar.isNameChar(ch) && ch != ':') continue;
                isSimple = false;
            }
            if (isSimple) {
                this.println("if (node instanceof Element)");
                if (isSingleString) {
                    this.print(new CharBuffer().append("  ").append(var).append(" = ((Element) node).getAttribute(\"").toString());
                    this.print(exprString.substring(1));
                    this.println("\");");
                } else {
                    this.print(new CharBuffer().append("  ").append(var).append(".append(((Element) node).getAttribute(\"").toString());
                    this.print(exprString.substring(1));
                    this.println("\"));");
                }
                return;
            }
        } else if (this.allowJavaSelect(select)) {
            int oldSelectDepth = this._selectDepth;
            String loopVar = new CharBuffer().append("_xsl_loop").append(this._unique++).toString();
            this._selectLoopDepth = 0;
            String ptr = this.printSelectBegin(select, true, loopVar);
            if (isSingleString) {
                this.println(new CharBuffer().append(var).append(" = XmlUtil.textValue(").append(ptr).append(");").toString());
            } else {
                this.println(new CharBuffer().append("XmlUtil.textValue(").append(var).append(", ").append(ptr).append(");").toString());
            }
            this.println(new CharBuffer().append("break ").append(loopVar).append(";").toString());
            while (this._selectDepth > oldSelectDepth) {
                this.popDepth();
                this.println("}");
                --this._selectDepth;
            }
            return;
        }
        if (isSingleString) {
            this.println(new CharBuffer().append(var).append(" = _exprs[").append(this.addExpr(exprString)).append("].evalString(node, ").append(this.getEnv()).append(");").toString());
        } else {
            this.println(new CharBuffer().append("_exprs[").append(this.addExpr(exprString)).append("].evalString(").append(var).append(", node, ").append(this.getEnv()).append(");").toString());
        }
    }

    private String printSelectBegin(AbstractPattern select, boolean isForEach, String loopVar) throws IOException, XslParseException {
        if (select == null) {
            throw new NullPointerException();
        }
        if (select instanceof FromContext && ((FromContext)select).getCount() == 0) {
            return "node";
        }
        if (select instanceof FromRoot) {
            return "ownerDocument(node)";
        }
        boolean useXPath = this.allowJavaSelect(select);
        String name = "node";
        if (!useXPath) {
            String iterName = new CharBuffer().append("_xsl_iter").append(this._unique++).toString();
            String ptrName = new CharBuffer().append("_xsl_ptr").append(this._unique++).toString();
            if (isForEach) {
                this.println("env.setCurrentNode(node);");
            }
            this.println(new CharBuffer().append("Iterator ").append(iterName).append(" = _select_patterns[").append(this.addSelect(select)).append("].select(").append(name).append(", env);").toString());
            if (loopVar != null && this._selectLoopDepth == 0) {
                this.println(new CharBuffer().append(loopVar).append(":").toString());
            }
            this.println(new CharBuffer().append("while (").append(iterName).append(".hasNext()) {").toString());
            this.pushDepth();
            ++this._selectDepth;
            ++this._selectLoopDepth;
            this.println(new CharBuffer().append("Node ").append(ptrName).append(" = (Node) ").append(iterName).append(".next();").toString());
            return ptrName;
        }
        if (select instanceof FromChildren) {
            name = this.printSelectBegin(select.getParent(), isForEach, loopVar);
            String ptrName = new CharBuffer().append("_xsl_ptr").append(this._unique++).toString();
            if (loopVar != null && this._selectLoopDepth == 0) {
                this.println(new CharBuffer().append(loopVar).append(":").toString());
            }
            this.println(new CharBuffer().append("for (Node ").append(ptrName).append(" = ").append(name).append(".getFirstChild();").toString());
            this.println(new CharBuffer().append("     ").append(ptrName).append(" != null;").toString());
            this.println(new CharBuffer().append("     ").append(ptrName).append(" = ").append(ptrName).append(".getNextSibling()) {").toString());
            this.pushDepth();
            ++this._selectDepth;
            ++this._selectLoopDepth;
            return ptrName;
        }
        if (select instanceof FromNextSibling) {
            name = this.printSelectBegin(select.getParent(), isForEach, loopVar);
            String ptrName = new CharBuffer().append("_xsl_ptr").append(this._unique++).toString();
            if (loopVar != null && this._selectLoopDepth == 0) {
                this.println(new CharBuffer().append(loopVar).append(":").toString());
            }
            this.println(new CharBuffer().append("for (Node ").append(ptrName).append(" = ").append(name).append(".getNextSibling();").toString());
            this.println(new CharBuffer().append("     ").append(ptrName).append(" != null;").toString());
            this.println(new CharBuffer().append("     ").append(ptrName).append(" = ").append(ptrName).append(".getNextSibling()) {").toString());
            this.pushDepth();
            ++this._selectDepth;
            ++this._selectLoopDepth;
            return ptrName;
        }
        if (select instanceof NodePattern) {
            name = this.printSelectBegin(select.getParent(), isForEach, loopVar);
            NodePattern pat = (NodePattern)select;
            this.println(new CharBuffer().append("if (").append(name).append(".getNodeName() == \"").append(pat.getNodeName()).append("\" &&").toString());
            this.println(new CharBuffer().append("    ").append(name).append(" instanceof Element) {").toString());
            this.pushDepth();
            ++this._selectDepth;
            return name;
        }
        if (select instanceof NodeTypePattern) {
            name = this.printSelectBegin(select.getParent(), isForEach, loopVar);
            NodeTypePattern pat = (NodeTypePattern)select;
            if (pat.getNodeType() >= 0) {
                this.println(new CharBuffer().append("if (").append(name).append(".getNodeType() == ").append(pat.getNodeType()).append(") {").toString());
                this.pushDepth();
                ++this._selectDepth;
            }
            return name;
        }
        if (select instanceof FilterPattern) {
            NumericExpr num;
            String posId = new CharBuffer().append("_xsl_pos").append(this._unique++).toString();
            this.println(new CharBuffer().append("int ").append(posId).append(" = 0;").toString());
            name = this.printSelectBegin(select.getParent(), isForEach, loopVar);
            this.println(new CharBuffer().append(posId).append("++;").toString());
            FilterPattern pat = (FilterPattern)select;
            Expr expr = pat.getExpr();
            if (expr instanceof NumericExpr && (num = (NumericExpr)expr).isConstant()) {
                this.println(new CharBuffer().append("if (").append(posId).append(" > ").append((int)num.getValue()).append(")").toString());
                this.println("  break;");
                this.println(new CharBuffer().append("else if (").append(posId).append(" == ").append((int)num.getValue()).append(") {").toString());
                this.pushDepth();
                ++this._selectDepth;
                return name;
            }
            throw new RuntimeException();
        }
        throw new RuntimeException(String.valueOf(select));
    }

    private boolean allowJavaSelect(AbstractPattern select) {
        if (select == null) {
            return false;
        }
        if (!select.isStrictlyAscending()) {
            return false;
        }
        if (select instanceof FromContext) {
            return ((FromContext)select).getCount() == 0;
        }
        if (select instanceof FromRoot) {
            return true;
        }
        if (select instanceof NodePattern) {
            return this.allowJavaSelect(select.getParent());
        }
        if (select instanceof NodeTypePattern) {
            return this.allowJavaSelect(select.getParent());
        }
        if (select instanceof FromChildren) {
            return this.allowJavaSelect(select.getParent());
        }
        if (select instanceof FromNextSibling) {
            return this.allowJavaSelect(select.getParent());
        }
        if (select instanceof FilterPattern) {
            if (!this.allowJavaSelect(select.getParent())) {
                return false;
            }
            Expr expr = ((FilterPattern)select).getExpr();
            return expr instanceof NumericExpr && ((NumericExpr)expr).isConstant();
        }
        return false;
    }

    private void stringExpr(String exprString, Element element) throws Exception, XslParseException {
        this.print(new CharBuffer().append("_exprs[").append(this.addExpr(exprString)).append("].evalString(node, ").append(this.getEnv()).append(")").toString());
    }

    public int addExpr(Expr expr) throws XslParseException {
        String exprStr = expr.toString();
        int i = this._exprMap.get(exprStr);
        if (i >= 0) {
            return i;
        }
        i = this._exprs.size();
        this._exprMap.put(exprStr, i);
        this._exprs.add(expr);
        return i;
    }

    public int addExpr(String exprString) throws XslParseException {
        int i = this._exprMap.get(exprString);
        if (i >= 0) {
            return i;
        }
        Expr expr = this.parseExpr(exprString);
        i = this._exprs.size();
        this._exprs.add(expr);
        this._exprMap.put(exprString, i);
        return i;
    }

    public int addSelect(AbstractPattern select) throws IOException, XslParseException {
        String selectStr = select.toString();
        int i = this._selectMap.get(selectStr);
        if (i >= 0) {
            return i;
        }
        i = this._selectPatterns.size();
        this._selectMap.put(selectStr, i);
        this._selectPatterns.add(select);
        return i;
    }

    public int addSelect(String selectString) throws IOException, XslParseException {
        int i = this._selectMap.get(selectString);
        if (i >= 0) {
            return i;
        }
        AbstractPattern select = this.parseSelect(selectString);
        i = this._selectPatterns.size();
        this._selectPatterns.add(select);
        this._selectMap.put(selectString, i);
        return i;
    }

    public int addMatch(AbstractPattern pattern) throws XslParseException {
        int index = this._matchPatterns.size();
        this._matchPatterns.add(pattern);
        return index;
    }

    @Override
    protected StylesheetImpl completeGenerate(ArrayList<XslNode> inits, ArrayList globals) throws Exception {
        this.printTemplates();
        this.printMacros();
        this.printInitVars(inits);
        this.printFragments();
        this.printInit();
        this.printStrings();
        this.printExpressions();
        this.printPatterns();
        this.popDepth();
        this.println("}");
        this._s.close();
        this._s = null;
        if (this._parentLoader instanceof DynamicClassLoader) {
            ((DynamicClassLoader)this._parentLoader).make();
        }
        this._compiler.compile(this._path.getPath(), this._lineMap);
        StylesheetImpl stylesheet = this._xslGenerator.loadStylesheet(this._path.getFullPath(), new CharBuffer().append(this._pkg).append(".").append(this._className).toString());
        return stylesheet;
    }

    private long getLastModified() {
        long lastModified = 0L;
        for (int i = 0; i < this._depends.size(); ++i) {
            Path path = (Path)this._depends.get(i);
            if (path.getLastModified() <= lastModified) continue;
            lastModified = path.getLastModified();
        }
        return lastModified;
    }

    protected void printInitVars(ArrayList<XslNode> inits) throws Exception {
        int i;
        this.println("private void _xsl_init_vars(XslWriter out, Node node, Env env)");
        this.println("  throws Exception");
        this.println("{");
        this.pushDepth();
        HashMap namespaces = this._qDoc.getNamespaces();
        if (namespaces != null) {
            for (String prefix : namespaces.keySet()) {
                String url = (String)namespaces.get(prefix);
                if (url.startsWith("http://www.w3.org/XSL/Transform/") || url.startsWith("http://www.w3.org/1999/XSL/Transform") || url.startsWith("http://www.w3.org/XML/2000/xmlns") || url.startsWith("http://www.w3.org/2000/xmlns") || url.equals("http://www.caucho.com/XTP/1.0") || this._excludedNamespaces.get(url) != null || this._namespaceAliases.get(url) != null) continue;
                if (prefix == null) {
                    this.println(new CharBuffer().append("out.addNamespace(\"\", \"").append(url).append("\");").toString());
                    continue;
                }
                this.println(new CharBuffer().append("out.addNamespace(\"").append(prefix).append("\", \"").append(url).append("\");").toString());
            }
        }
        this.println("Object _xsl_tmp;");
        for (i = 0; i < inits.size(); ++i) {
            XslNode node = inits.get(i);
            node.generate(this.getOut());
        }
        this.println("com.caucho.vfs.Path pwd;");
        this.println("pwd = (com.caucho.vfs.Path) out.getProperty(\"caucho.pwd\");");
        for (i = 0; i < this._cacheDepends.size(); ++i) {
            String depend = (String)this._cacheDepends.get(i);
            this.print("out.addCacheDepend(pwd.lookup(\"");
            this.printString(depend);
            this.println("\"));");
        }
        this.popDepth();
        this.println("}");
    }

    protected void printInit() throws Exception {
        int i;
        this.println("protected void _xsl_init(XslWriter out, Node node, Env env)");
        this.println("  throws Exception");
        this.println("{");
        this.pushDepth();
        this.println("Object _xsl_tmp;");
        this.println("_xsl_init_vars(out, node, env);");
        for (i = 0; this._globalActions != null && i < this._globalActions.size(); ++i) {
            QAbstractNode node = (QAbstractNode)this._globalActions.get(i);
            this.generateChild(node);
        }
        this.popDepth();
        this.println("}");
        this.println("public boolean isModified()");
        this.println("{");
        this.pushDepth();
        this.println(new CharBuffer().append("return com.caucho.util.CauchoSystem.getVersionId() != ").append(CauchoSystem.getVersionId()).append("L ||").toString());
        this.println("       super.isModified();");
        this.popDepth();
        this.println("}");
        this.println("public void init(com.caucho.vfs.Path path)");
        this.println("  throws Exception");
        this.println("{");
        this.pushDepth();
        this.println("super.init(path);");
        this.println("com.caucho.vfs.Path pwd = path.getParent();");
        for (i = 0; i < this._depends.size(); ++i) {
            Path path = (Path)this._depends.get(i);
            if (!path.canRead() || path.isDirectory()) continue;
            Depend depend = new Depend(path);
            this.print("addDepend(new com.caucho.vfs.Depend(pwd.lookup(\"");
            this.printString(path.getRelativePath());
            this.println(new CharBuffer().append("\"), ").append(depend.getDigest()).append("L));").toString());
        }
        this.println(new CharBuffer().append("stylesheets = new StylesheetEnv[").append(this._stylesheets.size()).append("];").toString());
        this.println("StylesheetEnv env;");
        for (i = 0; i < this._stylesheets.size(); ++i) {
            String ss = this._stylesheets.get(i);
            this.println("env = new StylesheetEnv();");
            this.println(new CharBuffer().append("stylesheets[").append(i).append("] = env;").toString());
            this.print("env.setPath(pwd.lookup(\"");
            this.printString(ss);
            this.println("\"));");
        }
        if (!this._strip.isEmpty()) {
            String prefix;
            this.println("HashMap preserve = new HashMap();");
            this.println("HashMap preservePrefix = new HashMap();");
            for (String key : this._preserve.keySet()) {
                if (key.endsWith(":*")) {
                    prefix = key.substring(0, key.length() - 2);
                    this.println(new CharBuffer().append("preservePrefix.put(\"").append(prefix).append("\", \"true\");").toString());
                    continue;
                }
                this.println(new CharBuffer().append("preserve.put(\"").append(key).append("\", \"true\");").toString());
            }
            this.println("HashMap strip = new HashMap();");
            this.println("HashMap stripPrefix = new HashMap();");
            for (String key : this._strip.keySet()) {
                if (key.endsWith(":*")) {
                    prefix = key.substring(0, key.length() - 2);
                    this.println(new CharBuffer().append("stripPrefix.put(\"").append(prefix).append("\", \"true\");").toString());
                    continue;
                }
                this.println(new CharBuffer().append("strip.put(\"").append(key).append("\", \"true\");").toString());
            }
            this.println("setSpaces(preserve, preservePrefix, strip, stripPrefix);");
        }
        this.printOutput();
        if (this._errorPage != null) {
            this.print("setProperty(\"caucho.error.page\", \"");
            this.printString(this._errorPage);
            this.println("\");");
        }
        if (this._globalParameters != null && this._globalParameters.size() > 0) {
            this.println("ArrayList params = new ArrayList();");
            for (int i2 = 0; i2 < this._globalParameters.size(); ++i2) {
                String param = (String)this._globalParameters.get(i2);
                this.println(new CharBuffer().append("params.add(\"").append(param).append("\");").toString());
            }
            this.print("setProperty(\"caucho.global.param\", params);");
        }
        Object disable = null;
        if (this._isRawText) {
            this.println("_defaultDisableEscaping = true;");
        }
        this.printNamespaces();
        this.printFunctions();
        this.printSorts();
        this.printFormats();
        this.popDepth();
        this.println("}");
    }

    private void printOutput() throws Exception {
        Iterator iter = this._outputAttributes.keySet().iterator();
        if (this._outputAttributes.get("encoding") == null) {
            this.println("_output.put(\"encoding\", \"utf-8\");");
        }
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String value = (String)this._outputAttributes.get(key);
            this.println(new CharBuffer().append("_output.put(\"").append(key).append("\", \"").append(value).append("\");").toString());
        }
    }

    private void printSorts() throws Exception {
        if (this._sorts.size() == 0) {
            return;
        }
        this.println();
        this.println("_xsl_sorts = new com.caucho.xsl.Sort[][] { ");
        this.pushDepth();
        for (int i = 0; i < this._sorts.size(); ++i) {
            Sort[] sorts = this._sorts.get(i);
            this.print("new com.caucho.xsl.Sort[] {");
            for (int j = 0; j < sorts.length; ++j) {
                Sort sort = sorts[j];
                Expr lang = sort.getLang();
                Expr caseOrder = sort.getCaseOrder();
                if (lang != null || caseOrder != null) {
                    this.print(new CharBuffer().append("new com.caucho.xsl.Sort(\"").append(sort.getExpr()).append("\", ").append("\"").append(sort.getAscending()).append("\", ").append(lang == null ? "null, " : new CharBuffer().append("\"").append(lang).append("\", ").toString()).append(caseOrder == null ? "null), " : new CharBuffer().append("\"").append(caseOrder).append("\"), ").toString()).toString());
                    continue;
                }
                this.print(new CharBuffer().append("new com.caucho.xsl.Sort(\"").append(sort.getExpr()).append("\", ").append("\"").append(sort.getAscending()).append("\", ").append(sort.isText()).append("), ").toString());
            }
            this.println("},");
        }
        this.popDepth();
        this.println("};");
    }

    private void printLocale(Locale locale) throws Exception {
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        if (variant != null && country != null) {
            this.print(new CharBuffer().append("new java.util.Locale(\"").append(language).append("\", ").append("\"").append(country).append("\", \"").append(variant).append("\")").toString());
        } else if (country != null) {
            this.print(new CharBuffer().append("new java.util.Locale(\"").append(language).append("\", ").append("\"").append(country).append("\")").toString());
        } else {
            this.print(new CharBuffer().append("new java.util.Locale(\"").append(language).append("\")").toString());
        }
    }

    private void printFormats() throws Exception {
        if (this._formats.size() == 0) {
            return;
        }
        this.println();
        this.println("_xsl_formats = new XslNumberFormat[] { ");
        this.pushDepth();
        for (int i = 0; i < this._formats.size(); ++i) {
            XslNumberFormat format = this._formats.get(i);
            this.println(new CharBuffer().append("new XslNumberFormat(\"").append(format.getFormat()).append("\", \"").append(format.getLang()).append("\", ").append(format.isAlphabetic()).append(", \"").append(format.getGroupSeparator()).append("\", ").append(format.getGroupSize()).append("),").toString());
        }
        this.popDepth();
        this.println("};");
    }

    private void printNamespaces() throws Exception {
        if (this._namespaces.size() == 0) {
            return;
        }
        this.println();
        this.println("_namespaces = new NamespaceContext[] { ");
        this.pushDepth();
        for (int i = 0; i < this._namespaces.size(); ++i) {
            NamespaceContext ns = this._namespaces.get(i);
            this.printNamespaceDef(ns);
            this.println(",");
        }
        this.popDepth();
        this.println("};");
    }

    private void printNamespaceDef(NamespaceContext ns) throws Exception {
        if (ns == null) {
            this.print("null");
            return;
        }
        this.print("new NamespaceContext(");
        this.printNamespaceDef(ns.getPrev());
        this.print(new CharBuffer().append(", \"").append(ns.getPrefix()).append("\", \"").append(ns.getUrl()).append("\")").toString());
    }

    private void printFunctions() throws Exception {
        this.println();
        this.println("com.caucho.xsl.fun.KeyFun keyFun = new com.caucho.xsl.fun.KeyFun();");
        HashMap<String, KeyFun.Key> keys = this._keyFun.getKeys();
        for (String name : keys.keySet()) {
            KeyFun.Key key = keys.get(name);
            this.println(new CharBuffer().append("keyFun.add(\"").append(name).append("\", XPath.parseMatch(\"").append(key.getMatch()).append("\").getPattern(), XPath.parseExpr(\"").append(key.getUse()).append("\"));").toString());
        }
        this.println("addFunction(\"key\", keyFun);");
        this.println();
        this.println("com.caucho.xsl.fun.FormatNumberFun formatFun = new com.caucho.xsl.fun.FormatNumberFun();");
        this.println("java.text.DecimalFormatSymbols symbols;");
        JavaWriter out = this._out;
        HashMap locales = this._formatNumberFun.getLocales();
        for (String name : locales.keySet()) {
            DecimalFormatSymbols symbols = (DecimalFormatSymbols)locales.get(name);
            out.println("symbols = new java.text.DecimalFormatSymbols();");
            out.print("symbols.setDecimalSeparator('");
            out.printJavaChar(symbols.getDecimalSeparator());
            out.println("');");
            out.print("symbols.setGroupingSeparator('");
            out.printJavaChar(symbols.getGroupingSeparator());
            out.println("');");
            out.print("symbols.setInfinity(\"");
            out.printJavaString(symbols.getInfinity());
            out.println("\");");
            out.print("symbols.setMinusSign('");
            out.printJavaChar(symbols.getMinusSign());
            out.println("');");
            out.print("symbols.setNaN(\"");
            out.printJavaString(symbols.getNaN());
            out.println("\");");
            out.print("symbols.setPercent('");
            out.printJavaChar(symbols.getPercent());
            out.println("');");
            out.print("symbols.setPerMill('");
            out.printJavaChar(symbols.getPerMill());
            out.println("');");
            out.print("symbols.setZeroDigit('");
            out.printJavaChar(symbols.getZeroDigit());
            out.println("');");
            out.print("symbols.setDigit('");
            out.printJavaChar(symbols.getDigit());
            out.println("');");
            out.print("symbols.setPatternSeparator('");
            out.printJavaChar(symbols.getPatternSeparator());
            out.println("');");
            this.println(new CharBuffer().append("formatFun.addLocale(\"").append(name).append("\", symbols);").toString());
        }
        this.println("addFunction(\"format-number\", formatFun);");
    }

    private void printMacros() throws Exception {
    }

    private void printFragments() throws Exception {
        for (int i = 0; i < this._fragments.size(); ++i) {
            Element elt = (Element)this._fragments.get(i);
            this.println(new CharBuffer().append("Object _xsl_fragment").append(i).append("(XslWriter out, Node inputNode, Env env )").toString());
            this.println("  throws Exception");
            this.println("{");
            this.pushDepth();
            this.println("Object _xsl_tmp;");
            this.println("Node node = inputNode;");
            this.println("XMLWriter _xsl_frag = out.pushFragment();");
            this.generateChildren(elt);
            this.println("return out.popFragment(_xsl_frag);");
            this.popDepth();
            this.println("}");
        }
    }

    private void printTemplates() throws Exception {
        for (int j = 0; j < this._modes.size(); ++j) {
            int i;
            String mode = this._modes.get(j);
            String modeName = this.getModeName(mode);
            this.printApplyNode(mode);
            this.println();
            this.println(new CharBuffer().append("static HashMap _static_templates").append(modeName).append(";").toString());
            this.println();
            this.println("static {");
            this.pushDepth();
            this.println(new CharBuffer().append("_static_templates").append(modeName).append(" = new HashMap();").toString());
            this.println("Template []values;");
            this.println("try {");
            this.pushDepth();
            ArrayList defaultTemplateList = (ArrayList)this._templates.get("*");
            if (defaultTemplateList == null) {
                defaultTemplateList = new ArrayList();
            }
            this.println("Template []star = new Template[] {");
            this.pushDepth();
            for (int i2 = 0; i2 < defaultTemplateList.size(); ++i2) {
                Template template = (Template)defaultTemplateList.get(i2);
                if (!template.getMode().equals(mode)) continue;
                this.printTemplate(template);
                this.println(",");
            }
            this.popDepth();
            this.println("};");
            this.println();
            this.println(new CharBuffer().append("_static_templates").append(modeName).append(".put(\"*\", star);").toString());
            int count = this._templates.size();
            for (i = 0; i < count; i += 64) {
                this.println(new CharBuffer().append("_init_templates").append(modeName).append("_").append(i).append("(star);").toString());
            }
            this.popDepth();
            this.println("} catch (Exception e) {");
            this.println("  e.printStackTrace();");
            this.println("}");
            this.popDepth();
            this.println("}");
            for (i = 0; i < count; i += 64) {
                this.printTemplateInitFun(mode, i, 64, defaultTemplateList);
            }
        }
    }

    private void printApplyNode(String mode) throws Exception {
        String modeName = this.getModeName(mode);
        this.print(new CharBuffer().append("protected void applyNode").append(modeName).toString());
        this.println("(XslWriter out, Node node, Env env, int _xsl_min, int _xsl_max)");
        this.println("  throws Exception");
        this.println("{");
        this.pushDepth();
        this.println("Object _xsl_tmp;");
        this.println();
        this.println(new CharBuffer().append("switch (getTemplateId(_static_templates").append(modeName).append(", ").append("node, env, _xsl_min, _xsl_max)) {").toString());
        for (int i = 0; i < this._functions.size(); ++i) {
            Template template = this._templateList.get(i);
            if (template == null || !template.getMode().equals(mode)) continue;
            this.println(new CharBuffer().append("case ").append(i + 1).append(":").toString());
            this.println(new CharBuffer().append("  ").append(this._functions.get(i)).append("(out, node, env);").toString());
            this.println("  break;");
        }
        this.println("default:");
        this.println("  switch (node.getNodeType()) {");
        this.println("  case Node.ELEMENT_NODE:");
        this.println("  case Node.DOCUMENT_NODE:");
        this.println("  case Node.DOCUMENT_FRAGMENT_NODE:");
        this.println("    env.setSelect(node, null);");
        this.println("    for (Node child = node.getFirstChild();");
        this.println("         child != null;");
        this.println("         child = child.getNextSibling()) {");
        this.println("      env.setCurrentNode(child);");
        this.println(new CharBuffer().append("      applyNode").append(modeName).append("(out, child, env, 0, ").append(Integer.MAX_VALUE).append(");").toString());
        this.println("    }");
        this.println("    break;");
        this.println("  default:");
        this.println("    applyNodeDefault(out, node, env);");
        this.println("    break;");
        this.println("  }");
        this.println("  break;");
        this.println("}");
        this.popDepth();
        this.println("}");
    }

    private void printTemplateInitFun(String mode, int offset, int length, ArrayList defaultTemplateList) throws Exception {
        String modeName = this.getModeName(mode);
        this.println(new CharBuffer().append("private static void _init_templates").append(modeName).append("_").append(offset).append("(Template []star)").toString());
        this.println("  throws Exception");
        this.println("{");
        this.pushDepth();
        Iterator iter = this._templates.keySet().iterator();
        while (iter.hasNext() && length > 0) {
            ArrayList templateList;
            String name = (String)iter.next();
            if (name.equals("*") || this.modeTemplateCount(mode, templateList = (ArrayList)this._templates.get(name)) == 0) continue;
            if (offset > 0) {
                --offset;
                continue;
            }
            this.println(new CharBuffer().append("_static_templates").append(modeName).append(".put(\"").append(name).append("\", ").toString());
            this.println("  mergeTemplates(star, new Template[] {");
            this.pushDepth();
            this.pushDepth();
            for (int i = 0; i < templateList.size(); ++i) {
                Template template = (Template)templateList.get(i);
                if (!template.getMode().equals(mode)) continue;
                this.printTemplate(template);
                this.println(",");
            }
            this.popDepth();
            this.popDepth();
            this.println("}));");
            --length;
        }
        this.popDepth();
        this.println("}");
    }

    private int modeTemplateCount(String mode, ArrayList templateList) {
        int count = 0;
        for (int i = 0; i < templateList.size(); ++i) {
            Template template = (Template)templateList.get(i);
            if (!template.getMode().equals(mode)) continue;
            ++count;
        }
        return count;
    }

    private void printTemplate(Template template) throws IOException {
        this.print("new Template(");
        AbstractPattern pattern = template.getPattern();
        this.print(new CharBuffer().append("XPath.parseMatch(\"").append(template.getPattern().toPatternString()).append("\").getPattern(), ").toString());
        this.print(new CharBuffer().append("\"").append(template.getMode()).append("\", ").toString());
        this.print(new CharBuffer().append(template.getMin()).append(", ").toString());
        this.print(new CharBuffer().append(template.getMax()).append(", ").toString());
        this.print(new CharBuffer().append(template.getPriority()).append(", ").toString());
        this.print(new CharBuffer().append(template.getCount()).append(", ").toString());
        this.print(new CharBuffer().append("\"").append(template.getFunction()).append("\", ").toString());
        this.print(new CharBuffer().append("").append(template.getId()).append(")").toString());
    }

    private void printStrings() throws Exception {
        for (int j = 0; j < this._strings.size(); ++j) {
            String text = this._strings.get(j);
            this.print(new CharBuffer().append("static char[] _xsl_string").append(j).append(" = \"").toString());
            this.printString(text);
            this.println("\".toCharArray();");
        }
    }

    private void printExpressions() throws Exception {
        if (this._exprs.size() == 0) {
            return;
        }
        this.println("private static Expr []_exprs;");
        this.println("static {");
        this.pushDepth();
        this.println("try {");
        this.pushDepth();
        this.println("_exprs = new Expr[] { ");
        this.pushDepth();
        for (int i = 0; i < this._exprs.size(); ++i) {
            Expr expr = this._exprs.get(i);
            this.println(new CharBuffer().append("XPath.parseExpr(\"").append(expr).append("\"),").toString());
        }
        this.popDepth();
        this.println("};");
        this.popDepth();
        this.println("} catch (Exception e) {");
        this.println("  e.printStackTrace();");
        this.println("}");
        this.popDepth();
        this.println("}");
    }

    private void printPatterns() throws Exception {
        AbstractPattern pattern;
        int i;
        if (this._selectPatterns.size() == 0 && this._matchPatterns.size() == 0) {
            return;
        }
        this.println("private static com.caucho.xpath.pattern.AbstractPattern []_select_patterns;");
        this.println("private static com.caucho.xpath.pattern.AbstractPattern []_match_patterns;");
        this.println("static {");
        this.pushDepth();
        this.println("try {");
        this.pushDepth();
        this.println("_select_patterns = new com.caucho.xpath.pattern.AbstractPattern[] { ");
        this.pushDepth();
        for (i = 0; i < this._selectPatterns.size(); ++i) {
            pattern = this._selectPatterns.get(i);
            this.println(new CharBuffer().append("XPath.parseSelect(\"").append(pattern).append("\").getPattern(),").toString());
        }
        this.popDepth();
        this.println("};");
        this.println("_match_patterns = new com.caucho.xpath.pattern.AbstractPattern[] { ");
        this.pushDepth();
        for (i = 0; i < this._matchPatterns.size(); ++i) {
            pattern = this._matchPatterns.get(i);
            this.println(new CharBuffer().append("XPath.parseMatch(\"").append(pattern).append("\").getPattern(),").toString());
        }
        this.popDepth();
        this.println("};");
        this.popDepth();
        this.println("} catch (Exception e) {");
        this.println("  e.printStackTrace();");
        this.println("}");
        this.popDepth();
        this.println("}");
    }

    private boolean isSingleStylesheet() {
        return false;
    }

    private void print(char ch) throws IOException {
        this._out.print(ch);
    }

    private void print(String string) throws IOException {
        this._out.print(string);
    }

    private void print(int i) throws IOException {
        this._out.print(i);
    }

    private void println() throws IOException {
        this._out.println();
    }

    private void println(char ch) throws IOException {
        this._out.println(ch);
    }

    private void println(String s) throws IOException {
        this._out.println(s);
    }

    private void pushDepth() throws IOException {
        this._out.pushDepth();
    }

    private void popDepth() throws IOException {
        this._out.popDepth();
    }

    protected void printString(String str) throws IOException {
        this._out.printJavaString(str);
    }

    public String getModeName(String mode) {
        if (mode != null && !this._modes.contains(mode)) {
            this._modes.add(mode);
        }
        if (mode == null || mode.equals("")) {
            return "";
        }
        return new CharBuffer().append("_").append(this.toJavaIdentifier(mode)).toString();
    }

    public void addMode(String mode) {
        if (!this._modes.contains(mode)) {
            this._modes.add(mode);
        }
    }

    public int addStylesheet(String filename) {
        int pos = this._stylesheets.indexOf(filename);
        if (pos < 0) {
            pos = this._stylesheets.size();
            this._stylesheets.add(filename);
        }
        return pos;
    }

    public String toJavaIdentifier(String name) {
        CharBuffer cb = new CharBuffer();
        char ch = name.charAt(0);
        if (Character.isJavaIdentifierStart(ch)) {
            cb.append(ch);
        } else {
            cb.append("_");
        }
        for (int i = 1; i < name.length(); ++i) {
            ch = name.charAt(i);
            if (Character.isJavaIdentifierPart(ch)) {
                cb.append(ch);
                continue;
            }
            cb.append("_");
            cb.append((char)((ch & 0xF) + 97));
            cb.append((char)((ch / 16 & 0xF) + 97));
        }
        return cb.toString();
    }

    @Override
    public void close() throws IOException {
        if (this._s != null) {
            this._s.close();
        }
    }

    static {
        _tagMap.put(new QName("xsl", "attribute", "http://www.w3.org/1999/XSL/Transform"), JavaGenerator._resin_compat_class_1());
        _tagMap.put(new QName("xsl", "attribute-set", "http://www.w3.org/1999/XSL/Transform"), JavaGenerator._resin_compat_class_2());
        _tagMap.put(new QName("xsl", "apply-imports", "http://www.w3.org/1999/XSL/Transform"), JavaGenerator._resin_compat_class_3());
        _tagMap.put(new QName("xsl", "apply-templates", "http://www.w3.org/1999/XSL/Transform"), JavaGenerator._resin_compat_class_4());
        _tagMap.put(new QName("xsl", "call-template", "http://www.w3.org/1999/XSL/Transform"), JavaGenerator._resin_compat_class_5());
        _tagMap.put(new QName("xsl", "choose", "http://www.w3.org/1999/XSL/Transform"), JavaGenerator._resin_compat_class_6());
        _tagMap.put(new QName("xsl", "comment", "http://www.w3.org/1999/XSL/Transform"), JavaGenerator._resin_compat_class_7());
        _tagMap.put(new QName("xsl", "copy", "http://www.w3.org/1999/XSL/Transform"), JavaGenerator._resin_compat_class_8());
        _tagMap.put(new QName("xsl", "copy-of", "http://www.w3.org/1999/XSL/Transform"), JavaGenerator._resin_compat_class_9());
        _tagMap.put(new QName("xsl", "decimal-format", "http://www.w3.org/1999/XSL/Transform"), JavaGenerator._resin_compat_class_10());
        _tagMap.put(new QName("xsl", "element", "http://www.w3.org/1999/XSL/Transform"), JavaGenerator._resin_compat_class_11());
        _tagMap.put(new QName("xsl", "for-each", "http://www.w3.org/1999/XSL/Transform"), JavaGenerator._resin_compat_class_12());
        _tagMap.put(new QName("xsl", "if", "http://www.w3.org/1999/XSL/Transform"), JavaGenerator._resin_compat_class_13());
        _tagMap.put(new QName("xsl", "import", "http://www.w3.org/1999/XSL/Transform"), JavaGenerator._resin_compat_class_14());
        _tagMap.put(new QName("xsl", "include", "http://www.w3.org/1999/XSL/Transform"), JavaGenerator._resin_compat_class_15());
        _tagMap.put(new QName("xsl", "key", "http://www.w3.org/1999/XSL/Transform"), JavaGenerator._resin_compat_class_16());
        _tagMap.put(new QName("xsl", "message", "http://www.w3.org/1999/XSL/Transform"), JavaGenerator._resin_compat_class_17());
        _tagMap.put(new QName("xsl", "namespace-alias", "http://www.w3.org/1999/XSL/Transform"), JavaGenerator._resin_compat_class_18());
        _tagMap.put(new QName("xsl", "number", "http://www.w3.org/1999/XSL/Transform"), JavaGenerator._resin_compat_class_19());
        _tagMap.put(new QName("xsl", "otherwise", "http://www.w3.org/1999/XSL/Transform"), JavaGenerator._resin_compat_class_20());
        _tagMap.put(new QName("xsl", "output", "http://www.w3.org/1999/XSL/Transform"), JavaGenerator._resin_compat_class_21());
        _tagMap.put(new QName("xsl", "param", "http://www.w3.org/1999/XSL/Transform"), JavaGenerator._resin_compat_class_22());
        _tagMap.put(new QName("xsl", "processing-instruction", "http://www.w3.org/1999/XSL/Transform"), JavaGenerator._resin_compat_class_23());
        _tagMap.put(new QName("xsl", "sort", "http://www.w3.org/1999/XSL/Transform"), JavaGenerator._resin_compat_class_24());
        _tagMap.put(new QName("xsl", "stylesheet", "http://www.w3.org/1999/XSL/Transform"), JavaGenerator._resin_compat_class_25());
        _tagMap.put(new QName("xsl", "text", "http://www.w3.org/1999/XSL/Transform"), JavaGenerator._resin_compat_class_26());
        _tagMap.put(new QName("xsl", "transform", "http://www.w3.org/1999/XSL/Transform"), JavaGenerator._resin_compat_class_27());
        _tagMap.put(new QName("xsl", "value-of", "http://www.w3.org/1999/XSL/Transform"), JavaGenerator._resin_compat_class_28());
        _tagMap.put(new QName("xsl", "variable", "http://www.w3.org/1999/XSL/Transform"), JavaGenerator._resin_compat_class_29());
        _tagMap.put(new QName("xsl", "when", "http://www.w3.org/1999/XSL/Transform"), JavaGenerator._resin_compat_class_30());
        _tagMap.put(new QName("xsl", "with-param", "http://www.w3.org/1999/XSL/Transform"), JavaGenerator._resin_compat_class_31());
        _tagMap.put(new QName("xsl", "template", "http://www.w3.org/1999/XSL/Transform"), JavaGenerator._resin_compat_class_32());
        _tagMap.put(new QName("xsl", "strip-space", "http://www.w3.org/1999/XSL/Transform"), JavaGenerator._resin_compat_class_33());
        _tagMap.put(new QName("xsl", "preserve-space", "http://www.w3.org/1999/XSL/Transform"), JavaGenerator._resin_compat_class_34());
        _tagMap.put(new QName("xsl", "result-document", "http://www.w3.org/1999/XSL/Transform"), JavaGenerator._resin_compat_class_35());
        _tagMap.put(new QName("xtp", "expression", "http://www.caucho.com/XTP/1.0"), JavaGenerator._resin_compat_class_36());
        _tagMap.put(new QName("xtp:expression", null), JavaGenerator._resin_compat_class_36());
        _tagMap.put(new QName("xtp", "eval", "http://www.caucho.com/XTP/1.0"), JavaGenerator._resin_compat_class_36());
        _tagMap.put(new QName("xtp:eval", null), JavaGenerator._resin_compat_class_36());
        _tagMap.put(new QName("xtp", "expr", "http://www.caucho.com/XTP/1.0"), JavaGenerator._resin_compat_class_36());
        _tagMap.put(new QName("xtp:expr", null), JavaGenerator._resin_compat_class_36());
        _tagMap.put(new QName("xtp", "scriptlet", "http://www.caucho.com/XTP/1.0"), JavaGenerator._resin_compat_class_37());
        _tagMap.put(new QName("xtp:scriptlet", null), JavaGenerator._resin_compat_class_37());
        _tagMap.put(new QName("xtp", "declaration", "http://www.caucho.com/XTP/1.0"), JavaGenerator._resin_compat_class_38());
        _tagMap.put(new QName("xtp", "decl", "http://www.caucho.com/XTP/1.0"), JavaGenerator._resin_compat_class_38());
        _tagMap.put(new QName("xtp:declaration", null), JavaGenerator._resin_compat_class_38());
        _tagMap.put(new QName("xtp:decl", null), JavaGenerator._resin_compat_class_38());
        _tagMap.put(new QName("xtp:directive.page", null), JavaGenerator._resin_compat_class_39());
        _tagMap.put(new QName("xtp", "directive.page", "http://www.caucho.com/XTP/1.0"), JavaGenerator._resin_compat_class_39());
        _tagMap.put(new QName("xtp:directive.cache", null), JavaGenerator._resin_compat_class_40());
        _tagMap.put(new QName("xtp", "directive.cache", "http://www.caucho.com/XTP/1.0"), JavaGenerator._resin_compat_class_40());
        _tagMap.put(new QName("xtp:assign", null), JavaGenerator._resin_compat_class_29());
        _tagMap.put(new QName("xtp", "assign", "http://www.caucho.com/XTP/1.0"), JavaGenerator._resin_compat_class_29());
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.xsl.JavaGenerator");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_1() {
        try {
            Class<?> clazz = _resin_compat_class_1;
            if (clazz == null) {
                clazz = _resin_compat_class_1 = Class.forName("com.caucho.xsl.java.XslAttribute");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_2() {
        try {
            Class<?> clazz = _resin_compat_class_2;
            if (clazz == null) {
                clazz = _resin_compat_class_2 = Class.forName("com.caucho.xsl.java.XslAttributeSet");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_3() {
        try {
            Class<?> clazz = _resin_compat_class_3;
            if (clazz == null) {
                clazz = _resin_compat_class_3 = Class.forName("com.caucho.xsl.java.XslApplyImports");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_4() {
        try {
            Class<?> clazz = _resin_compat_class_4;
            if (clazz == null) {
                clazz = _resin_compat_class_4 = Class.forName("com.caucho.xsl.java.XslApplyTemplates");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_5() {
        try {
            Class<?> clazz = _resin_compat_class_5;
            if (clazz == null) {
                clazz = _resin_compat_class_5 = Class.forName("com.caucho.xsl.java.XslCallTemplate");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_6() {
        try {
            Class<?> clazz = _resin_compat_class_6;
            if (clazz == null) {
                clazz = _resin_compat_class_6 = Class.forName("com.caucho.xsl.java.XslChoose");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_7() {
        try {
            Class<?> clazz = _resin_compat_class_7;
            if (clazz == null) {
                clazz = _resin_compat_class_7 = Class.forName("com.caucho.xsl.java.XslComment");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_8() {
        try {
            Class<?> clazz = _resin_compat_class_8;
            if (clazz == null) {
                clazz = _resin_compat_class_8 = Class.forName("com.caucho.xsl.java.XslCopy");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_9() {
        try {
            Class<?> clazz = _resin_compat_class_9;
            if (clazz == null) {
                clazz = _resin_compat_class_9 = Class.forName("com.caucho.xsl.java.XslCopyOf");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_10() {
        try {
            Class<?> clazz = _resin_compat_class_10;
            if (clazz == null) {
                clazz = _resin_compat_class_10 = Class.forName("com.caucho.xsl.java.XslDecimalFormat");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_11() {
        try {
            Class<?> clazz = _resin_compat_class_11;
            if (clazz == null) {
                clazz = _resin_compat_class_11 = Class.forName("com.caucho.xsl.java.XslElement");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_12() {
        try {
            Class<?> clazz = _resin_compat_class_12;
            if (clazz == null) {
                clazz = _resin_compat_class_12 = Class.forName("com.caucho.xsl.java.XslForEach");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_13() {
        try {
            Class<?> clazz = _resin_compat_class_13;
            if (clazz == null) {
                clazz = _resin_compat_class_13 = Class.forName("com.caucho.xsl.java.XslIf");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_14() {
        try {
            Class<?> clazz = _resin_compat_class_14;
            if (clazz == null) {
                clazz = _resin_compat_class_14 = Class.forName("com.caucho.xsl.java.XslImport");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_15() {
        try {
            Class<?> clazz = _resin_compat_class_15;
            if (clazz == null) {
                clazz = _resin_compat_class_15 = Class.forName("com.caucho.xsl.java.XslInclude");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_16() {
        try {
            Class<?> clazz = _resin_compat_class_16;
            if (clazz == null) {
                clazz = _resin_compat_class_16 = Class.forName("com.caucho.xsl.java.XslKey");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_17() {
        try {
            Class<?> clazz = _resin_compat_class_17;
            if (clazz == null) {
                clazz = _resin_compat_class_17 = Class.forName("com.caucho.xsl.java.XslMessage");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_18() {
        try {
            Class<?> clazz = _resin_compat_class_18;
            if (clazz == null) {
                clazz = _resin_compat_class_18 = Class.forName("com.caucho.xsl.java.XslNamespaceAlias");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_19() {
        try {
            Class<?> clazz = _resin_compat_class_19;
            if (clazz == null) {
                clazz = _resin_compat_class_19 = Class.forName("com.caucho.xsl.java.XslNumber");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_20() {
        try {
            Class<?> clazz = _resin_compat_class_20;
            if (clazz == null) {
                clazz = _resin_compat_class_20 = Class.forName("com.caucho.xsl.java.XslOtherwise");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_21() {
        try {
            Class<?> clazz = _resin_compat_class_21;
            if (clazz == null) {
                clazz = _resin_compat_class_21 = Class.forName("com.caucho.xsl.java.XslOutput");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_22() {
        try {
            Class<?> clazz = _resin_compat_class_22;
            if (clazz == null) {
                clazz = _resin_compat_class_22 = Class.forName("com.caucho.xsl.java.XslParam");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_23() {
        try {
            Class<?> clazz = _resin_compat_class_23;
            if (clazz == null) {
                clazz = _resin_compat_class_23 = Class.forName("com.caucho.xsl.java.XslProcessingInstruction");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_24() {
        try {
            Class<?> clazz = _resin_compat_class_24;
            if (clazz == null) {
                clazz = _resin_compat_class_24 = Class.forName("com.caucho.xsl.java.XslSort");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_25() {
        try {
            Class<?> clazz = _resin_compat_class_25;
            if (clazz == null) {
                clazz = _resin_compat_class_25 = Class.forName("com.caucho.xsl.java.XslStylesheet");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_26() {
        try {
            Class<?> clazz = _resin_compat_class_26;
            if (clazz == null) {
                clazz = _resin_compat_class_26 = Class.forName("com.caucho.xsl.java.XslText");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_27() {
        try {
            Class<?> clazz = _resin_compat_class_27;
            if (clazz == null) {
                clazz = _resin_compat_class_27 = Class.forName("com.caucho.xsl.java.XslTransform");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_28() {
        try {
            Class<?> clazz = _resin_compat_class_28;
            if (clazz == null) {
                clazz = _resin_compat_class_28 = Class.forName("com.caucho.xsl.java.XslValueOf");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_29() {
        try {
            Class<?> clazz = _resin_compat_class_29;
            if (clazz == null) {
                clazz = _resin_compat_class_29 = Class.forName("com.caucho.xsl.java.XslVariable");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_30() {
        try {
            Class<?> clazz = _resin_compat_class_30;
            if (clazz == null) {
                clazz = _resin_compat_class_30 = Class.forName("com.caucho.xsl.java.XslWhen");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_31() {
        try {
            Class<?> clazz = _resin_compat_class_31;
            if (clazz == null) {
                clazz = _resin_compat_class_31 = Class.forName("com.caucho.xsl.java.XslWithParam");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_32() {
        try {
            Class<?> clazz = _resin_compat_class_32;
            if (clazz == null) {
                clazz = _resin_compat_class_32 = Class.forName("com.caucho.xsl.java.XslTemplate");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_33() {
        try {
            Class<?> clazz = _resin_compat_class_33;
            if (clazz == null) {
                clazz = _resin_compat_class_33 = Class.forName("com.caucho.xsl.java.XslStripSpace");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_34() {
        try {
            Class<?> clazz = _resin_compat_class_34;
            if (clazz == null) {
                clazz = _resin_compat_class_34 = Class.forName("com.caucho.xsl.java.XslPreserveSpace");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_35() {
        try {
            Class<?> clazz = _resin_compat_class_35;
            if (clazz == null) {
                clazz = _resin_compat_class_35 = Class.forName("com.caucho.xsl.java.XslResultDocument");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_36() {
        try {
            Class<?> clazz = _resin_compat_class_36;
            if (clazz == null) {
                clazz = _resin_compat_class_36 = Class.forName("com.caucho.xsl.java.XtpExpression");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_37() {
        try {
            Class<?> clazz = _resin_compat_class_37;
            if (clazz == null) {
                clazz = _resin_compat_class_37 = Class.forName("com.caucho.xsl.java.XtpScriptlet");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_38() {
        try {
            Class<?> clazz = _resin_compat_class_38;
            if (clazz == null) {
                clazz = _resin_compat_class_38 = Class.forName("com.caucho.xsl.java.XtpDeclaration");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_39() {
        try {
            Class<?> clazz = _resin_compat_class_39;
            if (clazz == null) {
                clazz = _resin_compat_class_39 = Class.forName("com.caucho.xsl.java.XtpDirectivePage");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_40() {
        try {
            Class<?> clazz = _resin_compat_class_40;
            if (clazz == null) {
                clazz = _resin_compat_class_40 = Class.forName("com.caucho.xsl.java.XtpDirectiveCache");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    static class Macro {
        String _name;
        Element _elt;

        Macro(String name, Element elt) {
            this._name = name;
            this._elt = elt;
        }

        public Element getElement() {
            return this._elt;
        }

        public String getName() {
            return this._name;
        }
    }
}

