/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath.pattern;

import com.caucho.util.CharBuffer;
import com.caucho.xpath.ExprEnvironment;
import com.caucho.xpath.XPathException;
import com.caucho.xpath.pattern.AbstractPattern;
import com.caucho.xpath.pattern.FromAny;
import com.caucho.xpath.pattern.FromChildren;
import com.caucho.xpath.pattern.FromContext;
import org.w3c.dom.Node;

public class NodePattern
extends AbstractPattern {
    private NodePattern _match;
    private String _tag;
    private int _nodeType;

    public NodePattern(AbstractPattern parent, String tag, int nodeType) {
        super(parent);
        this._tag = tag.intern();
        this._nodeType = nodeType;
    }

    public double getPriority() {
        if (this._parent == null || this._parent instanceof FromChildren && (this._parent._parent instanceof FromAny || this._parent._parent instanceof FromContext)) {
            return 0.0;
        }
        return 0.5;
    }

    public String getNodeName() {
        return this._tag;
    }

    public boolean match(Node node, ExprEnvironment env) throws XPathException {
        if (node == null) {
            return false;
        }
        if (node.getNodeType() != this._nodeType) {
            return false;
        }
        if (node.getNodeName() != this._tag) {
            return false;
        }
        if (node.getNamespaceURI() != null) {
            return false;
        }
        return this._parent == null || this._parent.match(node, env);
    }

    public AbstractPattern copyPosition() {
        if (this._match == null) {
            AbstractPattern parent = null;
            if (this._parent != null) {
                parent = this._parent.copyPosition();
            }
            this._match = new NodePattern(parent, this._tag, this._nodeType);
        }
        return this._match;
    }

    public boolean equals(Object b) {
        if (!(b instanceof NodePattern)) {
            return false;
        }
        NodePattern bPattern = (NodePattern)b;
        return this._nodeType == bPattern._nodeType && this._tag.equals(bPattern._tag) && (this._parent == bPattern._parent || this._parent != null && this._parent.equals(bPattern._parent));
    }

    public String toString() {
        String prefix = this._parent == null || this._parent instanceof FromAny ? "" : (this._parent instanceof FromChildren ? this._parent.getPrefix() : this._parent.toString());
        switch (this._nodeType) {
            case 7: {
                return new CharBuffer().append(prefix).append("pi('").append(this._tag).append("')").toString();
            }
            case 2: {
                return new CharBuffer().append(prefix).append(this._tag).toString();
            }
            case 1: {
                return new CharBuffer().append(prefix).append(this._tag).toString();
            }
        }
        return super.toString();
    }
}

