/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath.pattern;

import com.caucho.util.CharBuffer;
import com.caucho.vfs.WriteStream;
import com.caucho.xml.CauchoElement;
import com.caucho.xml.CauchoNode;
import com.caucho.xml.QAbstractNode;
import com.caucho.xml.QAttr;
import java.io.IOException;
import java.util.HashMap;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NamespaceNode
extends QAbstractNode
implements CauchoNode {
    Node _parent;
    NamespaceNode _next;
    NamespaceNode _prev;
    String _local;
    String _name;
    String _url;

    public NamespaceNode(Node parent, NamespaceNode next, String prefix, String url) {
        this._parent = parent;
        this._next = next;
        if (next != null) {
            next._prev = this;
        }
        this._local = prefix;
        this._name = prefix == null || prefix.equals("") ? "xmlns" : new CharBuffer().append("xmlns:").append(prefix).toString().intern();
        this._url = url;
    }

    static NamespaceNode create(Node node) {
        Node top = node;
        NamespaceNode nodes = null;
        HashMap<String, String> map = new HashMap<String, String>();
        while (node instanceof CauchoElement) {
            CauchoElement elt = (CauchoElement)node;
            String prefix = elt.getPrefix();
            String url = elt.getNamespaceURI();
            if (url == null) {
                url = "";
            }
            if (map.get(prefix) == null) {
                map.put(prefix, url);
                if (!url.equals("")) {
                    nodes = new NamespaceNode(top, nodes, prefix, url);
                }
            }
            for (QAttr attr = (QAttr)elt.getFirstAttribute(); attr != null; attr = (QAttr)attr.getNextSibling()) {
                String name = attr.getNodeName();
                prefix = null;
                url = "";
                if (name.startsWith("xmlns:")) {
                    prefix = name.substring(6);
                    url = attr.getNodeValue();
                } else if (name.equals("xmlns")) {
                    prefix = "";
                    url = attr.getNodeValue();
                } else {
                    prefix = attr.getPrefix();
                    url = attr.getNamespaceURI();
                }
                if (url == null) {
                    url = "";
                }
                if (map.get(prefix) != null) continue;
                map.put(prefix, url);
                if (url.equals("")) continue;
                nodes = new NamespaceNode(top, nodes, prefix, url);
            }
            node = node.getParentNode();
        }
        return nodes;
    }

    public short getNodeType() {
        return 2;
    }

    public String getNodeName() {
        return this._name;
    }

    public String getPrefix() {
        return "xmlns";
    }

    public void setPrefix(String prefix) {
    }

    public boolean supports(String feature, String version) {
        return false;
    }

    public String getCanonicalName() {
        return "";
    }

    public String getLocalName() {
        return this._local;
    }

    public String getNamespaceURI() {
        return null;
    }

    public String getNodeValue() {
        return this._url;
    }

    public Node getParentNode() {
        return this._parent;
    }

    public Node getPreviousSibling() {
        return this._prev;
    }

    public Node getNextSibling() {
        return this._next;
    }

    public void setLocation(String filename, int line, int column) {
    }

    public String getFilename() {
        return null;
    }

    public int getLine() {
        return 0;
    }

    public int getColumn() {
        return 0;
    }

    public Document getOwnerDocument() {
        return null;
    }

    public void setNodeValue(String value) {
    }

    public NodeList getChildNodes() {
        return null;
    }

    public Node getFirstChild() {
        return null;
    }

    public Node getLastChild() {
        return null;
    }

    public NamedNodeMap getAttributes() {
        return null;
    }

    public Node insertBefore(Node newChild, Node refChild) {
        return null;
    }

    public Node replaceChild(Node newChild, Node refChild) {
        return null;
    }

    public Node removeChild(Node oldChild) throws DOMException {
        return null;
    }

    public Node appendChild(Node newNode) throws DOMException {
        return null;
    }

    public boolean hasChildNodes() {
        return false;
    }

    public boolean equals(Node arg, boolean deep) {
        return this == arg;
    }

    public Node cloneNode(boolean deep) {
        return null;
    }

    public void normalize() {
    }

    public String getTextValue() {
        return this.getNodeValue();
    }

    public boolean checkValid() {
        return false;
    }

    public void print(WriteStream out) throws IOException {
    }

    public void printPretty(WriteStream out) throws IOException {
    }

    public void printHtml(WriteStream out) throws IOException {
    }

    public boolean isSupported(String feature, String version) {
        return false;
    }

    public boolean hasAttributes() {
        return false;
    }

    public String toString() {
        return new CharBuffer().append("NamespaceNode[").append(this._name).append(" ").append(this._url).append("]").toString();
    }
}

