/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath.pattern;

import com.caucho.util.CharBuffer;
import com.caucho.xml.XmlUtil;
import com.caucho.xpath.Env;
import com.caucho.xpath.ExprEnvironment;
import com.caucho.xpath.XPathException;
import com.caucho.xpath.pattern.AbstractPattern;
import com.caucho.xpath.pattern.Axis;
import org.w3c.dom.Node;

public class FromPrevious
extends Axis {
    public FromPrevious(AbstractPattern parent) {
        super(parent);
        if (parent == null) {
            throw new RuntimeException();
        }
    }

    public boolean match(Node node, ExprEnvironment env) throws XPathException {
        if (node == null) {
            return false;
        }
        return this.getAxisContext(node, env, node) != null;
    }

    public boolean isAscending() {
        return false;
    }

    public int position(Node node, Env env, AbstractPattern pattern) throws XPathException {
        Node ptr;
        int index = env.getPositionIndex();
        boolean hasMatch = true;
        Node axis = XmlUtil.getNext(node);
        while (axis != null) {
            if (hasMatch && this._parent.match(axis, env)) {
                boolean hasParent = false;
                for (ptr = node.getParentNode(); ptr != null; ptr = ptr.getParentNode()) {
                    if (ptr != axis) continue;
                    hasParent = true;
                    break;
                }
                if (!hasParent && --index < 0) {
                    hasMatch = false;
                    break;
                }
            }
            if (!hasMatch && pattern.match(axis, env)) {
                hasMatch = true;
            }
            axis = XmlUtil.getNext(axis);
        }
        int count = 1;
        for (ptr = axis; ptr != null && ptr.getNextSibling() == null; ptr = ptr.getParentNode()) {
        }
        ptr = XmlUtil.getPrevious(axis);
        while (ptr != null && ptr != node) {
            if (pattern.match(ptr, env)) {
                boolean hasParent = false;
                for (Node n = node; n != null; n = n.getParentNode()) {
                    if (n != ptr) continue;
                    hasParent = true;
                    break;
                }
                if (!hasParent) {
                    ++count;
                }
            }
            ptr = XmlUtil.getPrevious(ptr);
        }
        while (axis != null) {
            if (this._parent.match(axis, env)) {
                env.setMorePositions(true);
                break;
            }
            axis = XmlUtil.getNext(axis);
        }
        return count;
    }

    public int count(Node node, Env env, AbstractPattern pattern) throws XPathException {
        Node axis = this.getAxisContext(node, env, node);
        for (int index = env.getPositionIndex(); index > 0; --index) {
            axis = this.getAxisContext(axis, env, node);
        }
        if (this.getAxisContext(axis, env, node) != null) {
            env.setMorePositions(true);
        }
        int count = 0;
        Node ptr = axis;
        while (ptr != null) {
            if (pattern.match(ptr, env) && !this.isDescendant(ptr, axis)) {
                ++count;
            }
            ptr = XmlUtil.getPrevious(ptr);
        }
        return count;
    }

    public boolean isUnique() {
        if (this._parent == null) {
            return true;
        }
        return this._parent.isSingleSelect();
    }

    public Node firstNode(Node node, ExprEnvironment env) {
        return XmlUtil.getPrevious(node);
    }

    public Node nextNode(Node node, Node lastNode) {
        block0: while (node != null) {
            node = XmlUtil.getPrevious(node);
            for (Node ptr = lastNode; ptr != null; ptr = ptr.getParentNode()) {
                if (ptr == node) continue block0;
            }
            return node;
        }
        return null;
    }

    public Node lastNode(Node node) {
        return node;
    }

    private Node getAxisContext(Node axis, ExprEnvironment env, Node node) throws XPathException {
        if (axis == null) {
            return null;
        }
        while ((axis = XmlUtil.getNext(axis)) != null) {
            if (this.isDescendant(axis, node) || !this._parent.match(axis, env)) continue;
            return axis;
        }
        return null;
    }

    private boolean isDescendant(Node descendant, Node node) {
        while (descendant != node && descendant != null) {
            descendant = descendant.getParentNode();
        }
        return descendant != null;
    }

    public String toString() {
        return new CharBuffer().append(this.getPrefix()).append("preceding::").toString();
    }
}

