/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath.functions;

import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.xml.QAbstractNode;
import com.caucho.xpath.Expr;
import com.caucho.xpath.ExprEnvironment;
import com.caucho.xpath.XPathException;
import com.caucho.xpath.XPathParseException;
import com.caucho.xpath.expr.AbstractStringExpr;
import org.w3c.dom.Node;

public class ResolveURI
extends AbstractStringExpr {
    private static final L10N L = new L10N(ResolveURI._resin_compat_class_0());
    private Expr _relExpr;
    private Expr _baseExpr;
    private static Class _resin_compat_class_0;

    public ResolveURI(Expr relExpr, Expr baseExpr) throws XPathParseException {
        this._relExpr = relExpr;
        this._baseExpr = baseExpr;
        if (relExpr == null) {
            throw new XPathParseException(L.l("fn:resolve-uri(relative,[base])"));
        }
    }

    public String evalString(Node node, ExprEnvironment env) throws XPathException {
        String rel = this._relExpr.evalString(node, env);
        if (rel.startsWith("/") || rel.indexOf(58) > 0 && rel.indexOf(58) < 47) {
            return rel;
        }
        String base = this._baseExpr != null ? this._baseExpr.evalString(node, env) : QAbstractNode.baseURI(node);
        int last = base.lastIndexOf(47);
        if (last < 0) {
            return rel;
        }
        return new CharBuffer().append(base.substring(0, last + 1)).append(rel).toString();
    }

    public String toString() {
        if (this._baseExpr != null) {
            return new CharBuffer().append("fn:resolve-uri(").append(this._relExpr).append(",").append(this._baseExpr).append(")").toString();
        }
        return new CharBuffer().append("fn:resolve-uri(").append(this._relExpr).append(")").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.xpath.functions.ResolveURI");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

