/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath.expr;

import com.caucho.util.CharBuffer;
import com.caucho.xpath.Expr;
import com.caucho.xpath.ExprEnvironment;
import com.caucho.xpath.XPathException;
import com.caucho.xpath.expr.Var;
import com.caucho.xpath.pattern.NodeIterator;
import com.caucho.xpath.pattern.SingleNodeIterator;
import org.w3c.dom.Node;

public class VarExpr
extends Expr {
    private String name;

    public VarExpr(String name) {
        this.name = name.intern();
    }

    public boolean evalBoolean(Node node, ExprEnvironment env) throws XPathException {
        Var var = env.getVar(this.name);
        return var == null ? false : var.getBoolean();
    }

    public double evalNumber(Node node, ExprEnvironment env) throws XPathException {
        Var var = env.getVar(this.name);
        return var == null ? Double.NaN : var.getDouble();
    }

    public void evalString(CharBuffer cb, Node node, ExprEnvironment env) throws XPathException {
        Var var = env.getVar(this.name);
        if (var != null) {
            var.getString(cb);
        }
    }

    public String evalString(Node node, ExprEnvironment env) throws XPathException {
        Var var = env.getVar(this.name);
        return var == null ? "" : var.getString();
    }

    public Object evalObject(Node node, ExprEnvironment env) throws XPathException {
        Var var = env.getVar(this.name);
        return var == null ? null : var.getObject();
    }

    public Var evalVar(Node node, ExprEnvironment env) throws XPathException {
        Var var = env.getVar(this.name);
        return var;
    }

    public NodeIterator evalNodeSet(Node node, ExprEnvironment env) throws XPathException {
        Var var = env.getVar(this.name);
        if (var == null) {
            return new SingleNodeIterator(env, null);
        }
        return var.getNodeSet(env);
    }

    public String toString() {
        return new CharBuffer().append("$").append(this.name).toString();
    }
}

