/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath.expr;

import com.caucho.util.CharBuffer;
import com.caucho.xpath.expr.Var;

public class NumberVar
extends Var {
    private static NumberVar[] intVar = new NumberVar[256];
    private double value;
    private Double objValue;
    private String strValue;

    private NumberVar(double value) {
        this.value = value;
    }

    public static NumberVar create(double value) {
        int index = (int)value;
        if ((double)index == value && index > -128 && index < 128) {
            NumberVar var = intVar[index + 128];
            if (var == null) {
                NumberVar.intVar[index + 128] = var = new NumberVar(value);
            }
            return var;
        }
        return new NumberVar(value);
    }

    double getDouble() {
        return this.value;
    }

    Object getObject() {
        if (this.objValue == null) {
            this.objValue = new Double(this.value);
        }
        return this.objValue;
    }

    String getString() {
        if (this.strValue == null) {
            if ((double)((int)this.value) == this.value) {
                CharBuffer cb = CharBuffer.allocate();
                cb.append((int)this.value);
                this.strValue = cb.close();
            } else {
                this.strValue = String.valueOf(this.value);
            }
        }
        return this.strValue;
    }

    void getString(CharBuffer cb) {
        if ((double)((int)this.value) == this.value) {
            cb.append((int)this.value);
        } else {
            cb.append(this.value);
        }
    }

    public Object clone() {
        NumberVar var = NumberVar.create(this.value);
        var.objValue = this.objValue;
        var.strValue = this.strValue;
        return var;
    }

    public String toString() {
        return new CharBuffer().append("[NumberVar ").append(this.value).append("]").toString();
    }
}

