/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath.expr;

import com.caucho.xpath.Expr;
import com.caucho.xpath.ExprEnvironment;
import com.caucho.xpath.XPathException;
import com.caucho.xpath.expr.NumberVar;
import com.caucho.xpath.expr.Var;
import org.w3c.dom.Node;

public abstract class AbstractNumberExpr
extends Expr {
    public boolean isNumber() {
        return true;
    }

    public Var evalVar(Node node, ExprEnvironment env) throws XPathException {
        double value = this.evalNumber(node, env);
        return NumberVar.create(value);
    }

    public abstract double evalNumber(Node var1, ExprEnvironment var2) throws XPathException;

    public boolean evalBoolean(Node node, ExprEnvironment env) throws XPathException {
        double value = this.evalNumber(node, env);
        return value != 0.0 && !Double.isNaN(value);
    }

    public String evalString(Node node, ExprEnvironment env) throws XPathException {
        double value = this.evalNumber(node, env);
        if ((double)((int)value) == value) {
            return String.valueOf((int)value);
        }
        return String.valueOf(value);
    }

    public Object evalObject(Node node, ExprEnvironment env) throws XPathException {
        return new Double(this.evalNumber(node, env));
    }
}

