/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath;

import com.caucho.util.FreeList;
import com.caucho.xml.XmlUtil;
import com.caucho.xpath.ExprEnvironment;
import com.caucho.xpath.StylesheetEnv;
import com.caucho.xpath.VarEnv;
import com.caucho.xpath.XPathFun;
import com.caucho.xpath.expr.ObjectVar;
import com.caucho.xpath.expr.Var;
import com.caucho.xpath.pattern.AbstractPattern;
import com.caucho.xpath.pattern.NodeIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Env
implements ExprEnvironment {
    static FreeList<Env> _freeList = new FreeList(32);
    HashMap _ids;
    HashMap _idCache;
    Element _lastElement;
    HashMap<String, Var> _globals;
    HashMap _functions;
    HashMap _cache;
    String[] _varKeys;
    Var[] _varValues;
    int _varSize;
    private Node _currentNode;
    private Node _contextNode;
    private int _positionIndex;
    private boolean _hasMorePositions;
    private int _useCount;
    private Env _parent;
    private Env _root;
    private ExprEnvironment _exprEnv;
    private AbstractPattern _select;
    private int _position;
    private int _size;
    private StylesheetEnv _stylesheetEnv;
    private VarEnv _varEnv;

    static Env create() {
        Env env = null;
        if (env == null) {
            env = new Env();
        }
        env._root = env;
        return env;
    }

    public void setStylesheetEnv(StylesheetEnv stylesheetEnv) {
        this._stylesheetEnv = stylesheetEnv;
    }

    public StylesheetEnv getStylesheetEnv() {
        Env env = this;
        while (env != null) {
            if (env._stylesheetEnv != null) {
                return env._stylesheetEnv;
            }
            env = env._parent;
        }
        return null;
    }

    public void setVarEnv(VarEnv varEnv) {
        this._varEnv = varEnv;
    }

    public VarEnv getVarEnv() {
        return this._varEnv;
    }

    void init(Env parent) {
        this._parent = parent;
        this._root = parent._root;
    }

    void init(Env parent, AbstractPattern select, Node currentNode) {
        this._parent = parent;
        this._root = parent._root;
        this._select = select;
        this._currentNode = currentNode;
    }

    void initMacro(Env parent) {
        this._parent = parent;
        this._root = parent._root;
        this._select = parent._select;
        this._stylesheetEnv = parent._stylesheetEnv;
        this._exprEnv = parent._exprEnv;
        this._currentNode = parent._currentNode;
        this._contextNode = parent._contextNode;
        this._position = parent._position;
        this._size = parent._size;
        this._positionIndex = 0;
        this._hasMorePositions = false;
        this._useCount = 0;
    }

    public void clear() {
    }

    Env getParent() {
        return this._parent;
    }

    public int getVarSize() {
        return this._varSize;
    }

    public void setVarSize(int size) {
        if (this._varKeys == null) {
            return;
        }
        while (this._varSize > size) {
            --this._varSize;
            this._varKeys[this._varSize] = null;
            this._varValues[this._varSize] = null;
            --this._varSize;
        }
    }

    public Var getVar(String name) {
        Var var;
        for (int i = this._varSize - 1; i >= 0; --i) {
            if (this._varKeys[i] != name) continue;
            return this._varValues[i];
        }
        if (this._root._globals != null && (var = this._root._globals.get(name)) != null) {
            return var;
        }
        if (this._root._varEnv != null) {
            return this._root._varEnv.getVar(name);
        }
        return null;
    }

    public int addVar(String name, Object value) {
        ++this._useCount;
        if (value instanceof Iterator) {
            value = this.iteratorToList((Iterator)value);
        }
        if (!(value instanceof Var)) {
            value = new ObjectVar(value);
        }
        return this.addVar(name, (Var)value);
    }

    public void setVar(String name, Object value) {
        ++this._useCount;
        if (value instanceof Iterator) {
            value = this.iteratorToList((Iterator)value);
        }
        if (!(value instanceof Var)) {
            value = new ObjectVar(value);
        }
        for (int i = this._varSize - 1; i >= 0; --i) {
            if (this._varKeys[i] != name) continue;
            this._varValues[i] = (Var)value;
            return;
        }
        this.addVar(name, (Var)value);
    }

    public int addVar(String name, Var value) {
        ++this._useCount;
        if (this._varKeys == null) {
            this._varKeys = new String[16];
            this._varValues = new Var[16];
        } else if (this._varSize == this._varKeys.length) {
            String[] newKeys = new String[2 * this._varKeys.length];
            Var[] newValues = new Var[2 * this._varKeys.length];
            System.arraycopy(this._varKeys, 0, newKeys, 0, this._varSize);
            System.arraycopy(this._varValues, 0, newValues, 0, this._varSize);
            this._varKeys = newKeys;
            this._varValues = newValues;
        }
        this._varKeys[this._varSize] = name;
        this._varValues[this._varSize] = value;
        ++this._varSize;
        return this._varSize - 1;
    }

    public void popVars(int count) {
        ++this._useCount;
        if (this._varKeys == null) {
            return;
        }
        while (count > 0 && this._varSize > 0) {
            --this._varSize;
            this._varKeys[this._varSize] = null;
            this._varValues[this._varSize].free();
            this._varValues[this._varSize] = null;
            --count;
        }
    }

    public int getTop() {
        return this._varSize;
    }

    public void popToTop(int top) {
        ++this._useCount;
        if (this._varKeys == null) {
            return;
        }
        while (top < this._varSize) {
            --this._varSize;
            this._varKeys[this._varSize] = null;
            this._varValues[this._varSize].free();
            this._varValues[this._varSize] = null;
        }
    }

    public void setGlobal(String name, Object value) {
        ++this._useCount;
        Var var = null;
        if (value instanceof Iterator) {
            value = this.iteratorToList((Iterator)value);
        }
        var = value instanceof Var ? (Var)value : new ObjectVar(value);
        if (this._root._globals == null) {
            this._root._globals = new HashMap();
        }
        this._root._globals.put(name, var);
    }

    private ArrayList iteratorToList(Iterator iter) {
        ArrayList list = new ArrayList();
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        return list;
    }

    public HashMap setFunctions(HashMap functions) {
        HashMap old = this._functions;
        this._functions = functions;
        return old;
    }

    public void addFunction(String name, Object fun) {
        if (this._functions == null) {
            this._functions = new HashMap();
        }
        this._functions.put(name, fun);
    }

    public XPathFun getFunction(String name) {
        if (this._root._functions == null) {
            return null;
        }
        return (XPathFun)this._root._functions.get(name);
    }

    public boolean hasMorePositions() {
        return this._hasMorePositions;
    }

    public boolean setMorePositions(boolean more) {
        boolean old = this._hasMorePositions;
        this._hasMorePositions = more;
        return old;
    }

    public int setPositionIndex(int index) {
        int old = this._positionIndex;
        this._positionIndex = index;
        return old;
    }

    public int getPositionIndex() {
        return this._positionIndex;
    }

    public Node getCurrentNode() {
        return this._currentNode;
    }

    public void setCurrentNode(Node node) {
        this._currentNode = node;
    }

    public AbstractPattern setSelect(Node node, AbstractPattern select) {
        AbstractPattern oldSelect = this._select;
        this._contextNode = node;
        this._select = select;
        this._position = 0;
        return oldSelect;
    }

    public AbstractPattern getSelect() {
        return this._select;
    }

    public ExprEnvironment setExprEnv(ExprEnvironment exprEnv) {
        ExprEnvironment oldExprEnv = this._exprEnv;
        this._exprEnv = exprEnv;
        return oldExprEnv;
    }

    public ExprEnvironment getExprEnv() {
        return this._exprEnv;
    }

    public Node getContextNode() {
        return this._contextNode;
    }

    public Node setContextNode(Node contextNode) {
        Node oldNode = this._contextNode;
        this._contextNode = contextNode;
        return oldNode;
    }

    public int getContextPosition() {
        if (this._exprEnv != null) {
            return this._exprEnv.getContextPosition();
        }
        if (this._position > 0) {
            return this._position;
        }
        if (this._contextNode == null || this._currentNode == null) {
            return 0;
        }
        if (this._select != null) {
            try {
                Node child;
                NodeIterator iter = this._select.select(this._contextNode, this);
                while ((child = iter.nextNode()) != null && child != this._currentNode) {
                }
                return iter.getContextPosition();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        int pos = 1;
        for (Node child = this._contextNode.getFirstChild(); child != null && child != this._currentNode; child = child.getNextSibling()) {
            ++pos;
        }
        return pos;
    }

    public int getContextSize() {
        if (this._exprEnv != null) {
            return this._exprEnv.getContextSize();
        }
        if (this._size > 0) {
            return this._size;
        }
        if (this._contextNode == null || this._currentNode == null) {
            return 0;
        }
        if (this._select != null) {
            try {
                Node child;
                NodeIterator iter = this._select.select(this._contextNode, this);
                while ((child = iter.nextNode()) != null && child != this._currentNode) {
                }
                return iter.getContextSize();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        int pos = 0;
        for (Node child = this._contextNode.getFirstChild(); child != null; child = child.getNextSibling()) {
            ++pos;
        }
        return pos;
    }

    public Document getOwnerDocument() {
        return null;
    }

    public Object systemProperty(String namespaceURI, String localName) {
        return null;
    }

    public String stringValue(Node node) {
        return XmlUtil.textValue(node);
    }

    public void setPosition(int position) {
        this._position = position;
    }

    public int setContextPosition(int position) {
        int oldPosition = this._position;
        this._position = position;
        return oldPosition;
    }

    public int setContextSize(int size) {
        int oldSize = this._size;
        this._size = size;
        return oldSize;
    }

    public Object getCache(Object key) {
        if (this._root._cache == null) {
            return null;
        }
        return this._root._cache.get(key);
    }

    public void setCache(Object key, Object value) {
        if (this._root._cache == null) {
            this._root._cache = new HashMap();
        }
        this._root._cache.put(key, value);
    }

    public int getUseCount() {
        return this._useCount;
    }

    public void free() {
        this._root = null;
        this._parent = null;
        this._select = null;
        this._exprEnv = null;
        this._stylesheetEnv = null;
        if (this._ids != null) {
            this._ids.clear();
            this._idCache.clear();
        }
        while (this._varSize-- > 0) {
            this._varKeys[this._varSize] = null;
            this._varValues[this._varSize] = null;
        }
        this._varSize = 0;
        this._lastElement = null;
        if (this._globals != null) {
            this._globals.clear();
        }
        this._functions = null;
        this._cache = null;
        this._currentNode = null;
        this._contextNode = null;
        this._size = 0;
        this._position = 0;
        this._positionIndex = 0;
        this._hasMorePositions = false;
        _freeList.free(this);
    }
}

