/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml2;

import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.TempCharBuffer;
import com.caucho.vfs.Vfs;
import com.caucho.xml.ExtendedLocator;
import com.caucho.xml.QName;
import com.caucho.xml.XmlChar;
import com.caucho.xml2.AttributesImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class XMLReaderImpl
implements XMLReader {
    private static final L10N L = new L10N(XMLReaderImpl._resin_compat_class_0());
    public static final String XMLNS = "http://www.w3.org/2000/xmlns/";
    static final QName DOC_NAME = new QName(null, "#document", null);
    static final QName TEXT_NAME = new QName(null, "#text", null);
    static final QName JSP_NAME = new QName(null, "#jsp", null);
    static final QName WHITESPACE_NAME = new QName(null, "#whitespace", null);
    static final QName JSP_ATTRIBUTE_NAME = new QName("xtp", "jsp-attribute", null);
    static final String LEXICAL_HANDLER = "http://xml.org/sax/properties/lexical-handler";
    private ContentHandler _contentHandler;
    private EntityResolver _entityResolver;
    private DTDHandler _dtdHandler;
    private ErrorHandler _errorHandler;
    private Reader _reader;
    private final AttributesImpl _attributes = new AttributesImpl();
    private final ExtendedLocator _locator = new LocatorImpl();
    private char[] _valueBuf;
    private char[] _inputBuf;
    private int _inputOffset;
    private int _inputLength;
    private String _filename;
    private String _systemId;
    private String _publicId;
    private int _line;
    private static Class _resin_compat_class_0;

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotRecognizedException(name);
    }

    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (!LEXICAL_HANDLER.equals(name)) {
            throw new SAXNotRecognizedException(name);
        }
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotRecognizedException(name);
    }

    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotRecognizedException(name);
    }

    public void setEntityResolver(EntityResolver resolver) {
        this._entityResolver = resolver;
    }

    public EntityResolver getEntityResolver() {
        return this._entityResolver;
    }

    public void setDTDHandler(DTDHandler handler) {
        this._dtdHandler = handler;
    }

    public DTDHandler getDTDHandler() {
        return this._dtdHandler;
    }

    public void setContentHandler(ContentHandler handler) {
        this._contentHandler = handler;
    }

    public ContentHandler getContentHandler() {
        return this._contentHandler;
    }

    public void setErrorHandler(ErrorHandler handler) {
        this._errorHandler = handler;
    }

    public ErrorHandler getErrorHandler() {
        return this._errorHandler;
    }

    public void parse(InputSource source) throws IOException, SAXException {
        InputStream is = source.getByteStream();
        if (is != null) {
            this._systemId = source.getSystemId();
            if (is instanceof ReadStream) {
                this._filename = ((ReadStream)is).getPath().getUserPath();
                if (this._systemId == null) {
                    this._systemId = ((ReadStream)is).getPath().getURL();
                }
            } else {
                this._filename = this._systemId;
            }
        } else {
            throw new IllegalArgumentException();
        }
        this._reader = new InputStreamReader(is);
        this.parseImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(String systemId) throws IOException, SAXException {
        ReadStream is = Vfs.lookup(systemId).openRead();
        this._reader = is.getReader();
        this._systemId = systemId;
        this._filename = systemId;
        try {
            this.parseImpl();
        }
        finally {
            this._reader = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseImpl() throws IOException, SAXException {
        TempCharBuffer inputBuffer = TempCharBuffer.allocate();
        TempCharBuffer valueBuffer = TempCharBuffer.allocate();
        try {
            this._valueBuf = valueBuffer.getBuffer();
            this._inputBuf = inputBuffer.getBuffer();
            this._inputLength = 0;
            this._inputOffset = 0;
            this._line = 1;
            this._contentHandler.setDocumentLocator(this._locator);
            this._contentHandler.startDocument();
            this.parseContent();
            this._contentHandler.endDocument();
        }
        finally {
            this._inputBuf = null;
            this._valueBuf = null;
            TempCharBuffer.free(inputBuffer);
            TempCharBuffer.free(valueBuffer);
        }
    }

    private void parseContent() throws IOException, SAXException {
        char[] valueBuffer = this._valueBuf;
        int valueLength = valueBuffer.length;
        int valueOffset = 0;
        boolean isWhitespace = true;
        boolean seenCr = false;
        block12: while (true) {
            if (this._inputLength == this._inputOffset && !this.fillBuffer()) {
                this.writeText(valueBuffer, valueOffset, isWhitespace);
                return;
            }
            char ch = this._inputBuf[this._inputOffset++];
            switch (ch) {
                case '\t': 
                case ' ': {
                    if (valueOffset < valueLength) {
                        valueBuffer[valueOffset++] = ch;
                        continue block12;
                    }
                    this.writeText(valueBuffer, valueOffset, isWhitespace);
                    valueOffset = 0;
                    continue block12;
                }
                case '\n': {
                    if (valueOffset < valueLength) {
                        valueBuffer[valueOffset++] = ch;
                    } else {
                        this.writeText(valueBuffer, valueOffset, isWhitespace);
                        valueOffset = 0;
                    }
                    ++this._line;
                    continue block12;
                }
                case '\r': {
                    if (valueOffset < valueLength) {
                        valueBuffer[valueOffset++] = ch;
                    } else {
                        this.writeText(valueBuffer, valueOffset, isWhitespace);
                        valueOffset = 0;
                    }
                    this.addCarriageReturnLine();
                    continue block12;
                }
                case '<': {
                    if (valueOffset > 0) {
                        this.writeText(valueBuffer, valueOffset, isWhitespace);
                        valueOffset = 0;
                    }
                    if (this._inputLength == this._inputOffset && !this.fillBuffer()) {
                        this.error("XXX: unexpected eof");
                    }
                    ch = this._inputBuf[this._inputOffset];
                    switch (ch) {
                        case '!': {
                            break;
                        }
                        case '?': {
                            break;
                        }
                        case '/': {
                            ++this._inputOffset;
                            return;
                        }
                        default: {
                            this.parseElement();
                        }
                    }
                    isWhitespace = true;
                    continue block12;
                }
                case '&': {
                    if (valueOffset > 0) {
                        this.writeText(valueBuffer, valueOffset, isWhitespace);
                        valueOffset = 0;
                    }
                    isWhitespace = true;
                    continue block12;
                }
            }
            isWhitespace = false;
            if (valueOffset < valueLength) {
                valueBuffer[valueOffset++] = ch;
                continue;
            }
            this.writeText(valueBuffer, valueOffset, false);
            valueOffset = 0;
        }
    }

    private void parseElement() throws IOException, SAXException {
        int ch;
        String name = this.parseName();
        this._attributes.clear();
        block8: while (true) {
            ch = this.read();
            switch (ch) {
                case -1: {
                    throw this.error("XXX: unexpected eof");
                }
                case 9: 
                case 32: {
                    continue block8;
                }
                case 13: {
                    this.addCarriageReturnLine();
                    continue block8;
                }
                case 10: {
                    ++this._line;
                    continue block8;
                }
                case 47: {
                    ch = this.read();
                    if (ch != 62) {
                        throw this.error("XXX: expected '>'");
                    }
                    this._contentHandler.startElement("", "", name, this._attributes);
                    this._contentHandler.endElement("", "", name);
                    return;
                }
                case 62: {
                    this._contentHandler.startElement("", "", name, this._attributes);
                    this.parseContent();
                    String tailName = this.parseName();
                    ch = this.read();
                    if (ch != 62) {
                        throw this.error("XXX: expected '>'");
                    }
                    if (!name.equals(tailName)) {
                        throw this.error("XXX: mismatch name");
                    }
                    this._contentHandler.endElement("", "", name);
                    return;
                }
            }
            if (!XmlChar.isNameStart(ch)) break;
            this.unread();
            String attrName = this.parseName();
            ch = this.skipWhitespace(this.read());
            if (ch != 61) {
                throw this.error(L.l("Expected '=' for attribute value at {0}.", this.badChar(ch)));
            }
            String attrValue = this.parseValue();
            this._attributes.add(new QName(attrName, null), attrValue);
        }
        throw this.error(L.l("{0} is an unexpected character in element.", this.badChar(ch)));
    }

    private String parseName() throws IOException {
        int valueOffset = 0;
        while (true) {
            char ch;
            if (this._inputLength == this._inputOffset && !this.fillBuffer()) {
                return new String(this._valueBuf, 0, valueOffset);
            }
            if (!XmlChar.isNameChar(ch = this._inputBuf[this._inputOffset++])) break;
            this._valueBuf[valueOffset++] = ch;
        }
        --this._inputOffset;
        return new String(this._valueBuf, 0, valueOffset);
    }

    private void writeText(char[] buffer, int length, boolean isWhitespace) throws SAXException {
    }

    private void addCarriageReturnLine() throws IOException {
        if (this._inputLength == this._inputOffset && !this.fillBuffer()) {
            ++this._line;
        } else if (this._inputBuf[this._inputOffset] != '\n') {
            ++this._line;
        }
    }

    private String parseValue() throws IOException, SAXException {
        int end = this.skipWhitespace(this.read());
        if (end != 39 && end != 34) {
            throw this.error(L.l("expected quote at '{0}'", this.badChar(end)));
        }
        int index = 0;
        char[] valueBuf = this._valueBuf;
        while (true) {
            if (this._inputLength == this._inputOffset && !this.fillBuffer()) {
                throw this.error(L.l("Unexpected end of file in attribute value."));
            }
            int ch = this._inputBuf[this._inputOffset++];
            switch (ch) {
                case 38: {
                    throw this.error(L.l("Can't handle entities yet."));
                }
                case 13: {
                    this.addCarriageReturnLine();
                    ch = 32;
                    break;
                }
                case 10: {
                    ++this._line;
                    ch = 32;
                    break;
                }
                case 34: 
                case 39: {
                    if (ch != end) break;
                    return new String(valueBuf, 0, index);
                }
            }
            valueBuf[index++] = ch;
        }
    }

    private int skipWhitespace(int ch) throws IOException {
        while (true) {
            switch (ch) {
                case -1: {
                    return -1;
                }
                case 9: 
                case 32: {
                    break;
                }
                case 13: {
                    this.addCarriageReturnLine();
                    break;
                }
                case 10: {
                    ++this._line;
                    break;
                }
                default: {
                    return ch;
                }
            }
            if (this._inputLength == this._inputOffset && !this.fillBuffer()) {
                return -1;
            }
            ch = this._inputBuf[this._inputOffset++];
        }
    }

    private int read() throws IOException {
        if (this._inputLength == this._inputOffset && !this.fillBuffer()) {
            return -1;
        }
        return this._inputBuf[this._inputOffset++];
    }

    private void unread() throws IOException {
        --this._inputOffset;
    }

    private boolean fillBuffer() throws IOException {
        this._inputOffset = 0;
        this._inputLength = this._reader.read(this._inputBuf, 0, this._inputBuf.length);
        return this._inputLength > 0;
    }

    private String badChar(int ch) {
        return new CharBuffer().append("").append((char)ch).toString();
    }

    private SAXException error(String msg) {
        return new SAXException(msg);
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.xml2.XMLReaderImpl");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    class LocatorImpl
    implements ExtendedLocator {
        LocatorImpl() {
        }

        public String getSystemId() {
            return XMLReaderImpl.this._systemId;
        }

        public String getFilename() {
            return XMLReaderImpl.this._filename;
        }

        public String getPublicId() {
            return XMLReaderImpl.this._publicId;
        }

        public int getLineNumber() {
            return XMLReaderImpl.this._line;
        }

        public int getColumnNumber() {
            return -1;
        }
    }
}

