/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.bytecode.compat.Box;
import com.caucho.util.CharBuffer;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;

public class XmlWriter
extends PrintWriter {
    public static final Strategy XML = new Xml();
    public static final Strategy XHTML = new Xhtml();
    public static final Strategy HTML = new Html();
    private boolean _isIndenting = false;
    private int _indent = 0;
    private boolean _isElementOpen;
    private boolean _isElementOpenNeedsNewline;
    private String _openElementName;
    private Strategy _strategy = XML;
    private String _contentType = "text/xml";
    private String _characterEncoding;
    private boolean _isNewLine = true;

    public XmlWriter(Writer out) {
        super(out);
    }

    public String getContentType() {
        return this._contentType;
    }

    public void setContentType(String contentType) {
        this._contentType = contentType;
        if (this._contentType.equals("text/xml")) {
            this._strategy = XML;
        }
        this._strategy = this._contentType.equals("application/xml") ? XML : (this._contentType.equals("text/xhtml") ? XHTML : (this._contentType.equals("application/xhtml+xml") ? XHTML : (this._contentType.equals("text/html") ? HTML : XML)));
    }

    public void setStrategy(Strategy strategy) {
        this._strategy = strategy;
    }

    public void setIndenting(boolean isIndenting) {
        this._isIndenting = isIndenting;
    }

    public boolean isIndenting() {
        return this._isIndenting;
    }

    public void setCharacterEncoding(String characterEncoding) {
        this._characterEncoding = characterEncoding;
    }

    public String getCharacterEncoding() {
        return this._characterEncoding;
    }

    private boolean closeElementIfNeeded(boolean isEnd) {
        if (this._isElementOpen) {
            this._isElementOpen = false;
            this._strategy.closeElement(this, this._openElementName, isEnd);
            if (this._isElementOpenNeedsNewline) {
                this._isElementOpenNeedsNewline = false;
                this.softPrintln();
            }
            return true;
        }
        return false;
    }

    private void startElement(String name, boolean isLineBefore, boolean isLineAfter) {
        this.closeElementIfNeeded(false);
        if (isLineBefore) {
            this.softPrintln();
        }
        this._openElementName = name;
        this._strategy.openElement(this, name);
        this._isElementOpen = true;
        this._isElementOpenNeedsNewline = isLineAfter;
        if (this._isIndenting) {
            ++this._indent;
        }
    }

    private void endElement(String name, boolean isLineBefore, boolean isLineAfter) {
        if (this._isIndenting) {
            --this._indent;
        }
        if (!this.closeElementIfNeeded(true)) {
            if (isLineBefore) {
                this.softPrintln();
            }
            this._strategy.endElement(this, name);
        }
        if (isLineAfter) {
            this.softPrintln();
        }
    }

    public void startElement(String name) {
        this.startElement(name, false, false);
    }

    public void endElement(String name) {
        this.endElement(name, false, false);
    }

    public void startBlockElement(String name) {
        this.startElement(name, true, true);
    }

    public void endBlockElement(String name) {
        this.endElement(name, true, true);
    }

    public void startLineElement(String name) {
        this.startElement(name, true, false);
    }

    public void endLineElement(String name) {
        this.endElement(name, false, true);
    }

    public void writeElement(String name) {
        this.startElement(name);
        this.endElement(name);
    }

    public void writeLineElement(String name) {
        this.startLineElement(name);
        this.endLineElement(name);
    }

    public void writeBlockElement(String name) {
        this.startBlockElement(name);
        this.endBlockElement(name);
    }

    public void writeElement(String name, Object text) {
        this.startElement(name);
        this.writeText(text);
        this.endElement(name);
    }

    public void writeLineElement(String name, Object text) {
        this.startLineElement(name);
        this.writeText(text);
        this.endLineElement(name);
    }

    public void writeBlockElement(String name, Object text) {
        this.startBlockElement(name);
        this.writeText(text);
        this.endBlockElement(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeAttribute(String name, Object value) {
        if (!this._isElementOpen) {
            throw new IllegalStateException("no open element");
        }
        if (value == null) {
            return;
        }
        this._isElementOpen = false;
        try {
            this._strategy.writeAttribute(this, name, value);
        }
        finally {
            this._isElementOpen = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeAttribute(String name, Object ... values) {
        if (!this._isElementOpen) {
            throw new IllegalStateException("no open element");
        }
        this._isElementOpen = false;
        try {
            this._strategy.writeAttribute(this, name, values);
        }
        finally {
            this._isElementOpen = true;
        }
    }

    public void writeText(char ch) {
        this.closeElementIfNeeded(false);
        this.writeIndentIfNewLine();
        this._strategy.writeText(this, ch);
    }

    public void writeText(char[] buf) {
        this.closeElementIfNeeded(false);
        this.writeIndentIfNewLine();
        this._strategy.writeText(this, buf);
    }

    public void writeText(char[] buf, int offset, int length) {
        this.closeElementIfNeeded(false);
        this.writeIndentIfNewLine();
        this._strategy.writeText(this, buf, offset, length);
    }

    public void writeText(Object obj) {
        this.closeElementIfNeeded(false);
        this.writeIndentIfNewLine();
        this._strategy.writeTextObject(this, obj);
    }

    public void writeComment(String comment) {
        this.closeElementIfNeeded(false);
        this.writeIndentIfNewLine();
        this._strategy.writeComment(this, comment);
    }

    public void flush() {
        this.closeElementIfNeeded(true);
        super.flush();
    }

    public void println() {
        this.closeElementIfNeeded(false);
        super.println();
        this._isNewLine = true;
    }

    public boolean isNewLine() {
        return this._isNewLine;
    }

    public boolean softPrintln() {
        if (!this.isNewLine()) {
            this.println();
            return true;
        }
        return false;
    }

    public void write(int ch) {
        this.closeElementIfNeeded(false);
        this._isNewLine = false;
        super.write(ch);
    }

    public void write(char[] buf, int off, int len) {
        this.closeElementIfNeeded(false);
        this._isNewLine = false;
        super.write(buf, off, len);
    }

    public void write(char[] buf) {
        this.closeElementIfNeeded(false);
        this._isNewLine = false;
        super.write(buf);
    }

    public void write(String s, int off, int len) {
        this.closeElementIfNeeded(false);
        this._isNewLine = false;
        super.write(s, off, len);
    }

    public void write(String s) {
        this.closeElementIfNeeded(false);
        this._isNewLine = false;
        super.write(s);
    }

    private void writeIndentIfNewLine() {
        if (this.isNewLine()) {
            for (int i = this._indent * 2; i > 0; --i) {
                this.write(32);
            }
        }
    }

    public static class Html
    extends Xhtml {
    }

    public static class Xhtml
    extends Xml {
        private int EMPTY = 1;
        private int BREAK_BEFORE = 2;
        private int BREAK_AFTER = 4;
        private int BREAK_AFTER_CONTENT = 8;
        private int EAT_BREAK_BEFORE = 16;
        private int BOOLEAN_ATTRIBUTE = 1024;
        private HashMap<String, Integer> _flags = new HashMap();

        public Xhtml() {
            this.addFlags("html", this.BREAK_BEFORE | this.BREAK_AFTER);
            this.addFlags("head", this.BREAK_BEFORE | this.BREAK_AFTER);
            this.addFlags("body", this.BREAK_BEFORE | this.BREAK_AFTER);
            this.addFlags("style", this.BREAK_BEFORE | this.BREAK_AFTER);
            this.addFlags("meta", this.BREAK_BEFORE | this.BREAK_AFTER | this.EMPTY);
            this.addFlags("link", this.BREAK_BEFORE | this.BREAK_AFTER | this.EMPTY);
            this.addFlags("title", this.BREAK_BEFORE | this.BREAK_AFTER_CONTENT);
            this.addFlags("base", this.BREAK_BEFORE | this.BREAK_AFTER | this.EMPTY);
            this.addFlags("h1", this.BREAK_BEFORE | this.BREAK_AFTER_CONTENT);
            this.addFlags("h2", this.BREAK_BEFORE | this.BREAK_AFTER_CONTENT);
            this.addFlags("h3", this.BREAK_BEFORE | this.BREAK_AFTER_CONTENT);
            this.addFlags("h4", this.BREAK_BEFORE | this.BREAK_AFTER_CONTENT);
            this.addFlags("h5", this.BREAK_BEFORE | this.BREAK_AFTER_CONTENT);
            this.addFlags("h6", this.BREAK_BEFORE | this.BREAK_AFTER_CONTENT);
            this.addFlags("p", this.BREAK_BEFORE | this.BREAK_AFTER);
            this.addFlags("div", this.BREAK_BEFORE | this.BREAK_AFTER);
            this.addFlags("ul", this.BREAK_BEFORE | this.BREAK_AFTER);
            this.addFlags("ol", this.BREAK_BEFORE | this.BREAK_AFTER);
            this.addFlags("li", this.BREAK_BEFORE | this.BREAK_AFTER_CONTENT);
            this.addFlags("dl", this.BREAK_BEFORE | this.BREAK_AFTER);
            this.addFlags("dt", this.BREAK_BEFORE | this.BREAK_AFTER_CONTENT);
            this.addFlags("dd", this.BREAK_BEFORE | this.BREAK_AFTER_CONTENT);
            this.addFlags("hr", this.BREAK_BEFORE | this.BREAK_AFTER | this.EMPTY);
            this.addFlags("br", this.BREAK_AFTER | this.EMPTY);
            this.addFlags("img", this.EMPTY);
            this.addFlags("area", this.EMPTY);
            this.addFlags("pre", this.BREAK_BEFORE | this.BREAK_AFTER);
            this.addFlags("blockquote", this.BREAK_BEFORE | this.BREAK_AFTER);
            this.addFlags("address", this.BREAK_BEFORE | this.BREAK_AFTER);
            this.addFlags("fieldset", this.BREAK_BEFORE | this.BREAK_AFTER);
            this.addFlags("form", this.BREAK_BEFORE | this.BREAK_AFTER);
            this.addFlags("ins", this.BREAK_BEFORE | this.BREAK_AFTER);
            this.addFlags("del", this.BREAK_BEFORE | this.BREAK_AFTER);
            this.addFlags("script", this.BREAK_BEFORE | this.BREAK_AFTER);
            this.addFlags("noscript", this.BREAK_BEFORE | this.BREAK_AFTER);
            this.addFlags("input", this.EMPTY);
            this.addFlags("table", this.BREAK_BEFORE | this.BREAK_AFTER);
            this.addFlags("thead", this.BREAK_BEFORE | this.BREAK_AFTER);
            this.addFlags("tfoot", this.BREAK_BEFORE | this.BREAK_AFTER);
            this.addFlags("tr", this.BREAK_BEFORE | this.BREAK_AFTER_CONTENT);
            this.addFlags("col", this.EMPTY);
            this.addFlags("object", this.BREAK_BEFORE | this.BREAK_AFTER);
            this.addFlags("param", this.BREAK_BEFORE | this.BREAK_AFTER | this.EMPTY);
            this.addFlags("compact", this.BOOLEAN_ATTRIBUTE);
            this.addFlags("nowrap", this.BOOLEAN_ATTRIBUTE);
            this.addFlags("ismap", this.BOOLEAN_ATTRIBUTE);
            this.addFlags("declare", this.BOOLEAN_ATTRIBUTE);
            this.addFlags("noshade", this.BOOLEAN_ATTRIBUTE);
            this.addFlags("checked", this.BOOLEAN_ATTRIBUTE);
            this.addFlags("disabled", this.BOOLEAN_ATTRIBUTE);
            this.addFlags("readonly", this.BOOLEAN_ATTRIBUTE);
            this.addFlags("multiple", this.BOOLEAN_ATTRIBUTE);
            this.addFlags("selected", this.BOOLEAN_ATTRIBUTE);
            this.addFlags("noresize", this.BOOLEAN_ATTRIBUTE);
            this.addFlags("defer", this.BOOLEAN_ATTRIBUTE);
        }

        protected void addFlags(String name, int flag) {
            int intValue = this.getFlags(name);
            this._flags.put(name, Box.boxInteger(intValue |= flag));
        }

        protected int getFlags(String name) {
            Integer integer = this._flags.get(name);
            int intValue = integer == null ? 0 : integer;
            return intValue;
        }

        void openElement(XmlWriter writer, String name) {
            int flags = this.getFlags(name);
            if ((flags & this.BREAK_BEFORE) > 0) {
                writer.softPrintln();
            }
            writer.writeIndentIfNewLine();
            writer.write(60);
            writer.write(name);
        }

        protected void writeAttributeValue(XmlWriter writer, String name, Object value) {
            int flags = this.getFlags(name);
            if ((flags & this.BOOLEAN_ATTRIBUTE) > 0) {
                value = name.toUpperCase();
            }
            super.writeAttributeValue(writer, name, value);
        }

        void closeElement(XmlWriter writer, String name, boolean isEnd) {
            boolean isEmpty;
            int flags = this.getFlags(name);
            boolean bl = isEmpty = (flags & this.EMPTY) > 0;
            if (isEnd && isEmpty) {
                writer.write(" />");
            } else {
                writer.write(62);
            }
            if ((flags & this.BREAK_AFTER) > 0) {
                writer.softPrintln();
            }
            if (isEnd && !isEmpty) {
                this.endElement(writer, name);
            }
        }

        void endElement(XmlWriter writer, String name) {
            boolean isFullBreak;
            int flags = this.getFlags(name);
            boolean bl = isFullBreak = (flags & (this.BREAK_BEFORE | this.BREAK_AFTER)) == (this.BREAK_BEFORE | this.BREAK_AFTER);
            if (isFullBreak) {
                writer.softPrintln();
            }
            writer.writeIndentIfNewLine();
            if ((flags & this.EMPTY) == 0) {
                writer.write("</");
                writer.write(name);
                writer.write(62);
            }
            if (isFullBreak || (flags & this.BREAK_AFTER_CONTENT) > 0) {
                writer.softPrintln();
            }
        }

        protected void writeDoctype(XmlWriter writer) {
            writer.println("<!DOCTYPE html  PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\"  \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">");
        }

        protected void writeXmlDeclaration(XmlWriter writer) {
            String encoding = writer.getCharacterEncoding();
            writer.println(new CharBuffer().append("<?xml version=\"1.0\" encoding=\"").append(encoding).append("\"?>").toString());
        }
    }

    public static class Xml
    extends Strategy {
        void openElement(XmlWriter writer, String name) {
            writer.writeIndentIfNewLine();
            writer.write(60);
            writer.write(name);
        }

        void closeElement(XmlWriter writer, String name, boolean isEnd) {
            if (isEnd) {
                writer.write(47);
            }
            writer.write(62);
        }

        void endElement(XmlWriter writer, String name) {
            writer.writeIndentIfNewLine();
            writer.write("</");
            writer.write(name);
            writer.write(62);
        }

        void writeAttribute(XmlWriter writer, String name, Object value) {
            writer.write(" ");
            writer.write(name);
            writer.write(61);
            writer.write("'");
            this.writeAttributeValue(writer, name, value);
            writer.write("'");
        }

        void writeAttribute(XmlWriter writer, String name, Object ... values) {
            writer.write(" ");
            writer.write(name);
            writer.write(61);
            writer.write("'");
            int len = values.length;
            for (int i = 0; i < len; ++i) {
                Object value = values[i];
                if (value == null) continue;
                if (i > 0) {
                    writer.write(32);
                }
                this.writeAttributeValue(writer, name, value);
            }
            writer.write("'");
        }

        protected void writeAttributeValue(XmlWriter writer, String name, Object value) {
            this.writeXmlEscaped(writer, value);
        }

        public void writeText(XmlWriter writer, char ch) {
            this.writeXmlEscapedChar(writer, ch);
        }

        public void writeText(XmlWriter writer, char[] buf) {
            int endIndex = buf.length;
            for (int i = 0; i < endIndex; ++i) {
                this.writeXmlEscapedChar(writer, buf[i]);
            }
        }

        public void writeText(XmlWriter writer, char[] buf, int offset, int length) {
            int endIndex = offset + length;
            for (int i = offset; i < endIndex; ++i) {
                this.writeXmlEscapedChar(writer, buf[i]);
            }
        }

        public void writeTextObject(XmlWriter writer, Object obj) {
            String string = String.valueOf(obj);
            int len = string.length();
            for (int i = 0; i < len; ++i) {
                this.writeXmlEscapedChar(writer, string.charAt(i));
            }
        }

        public void writeComment(XmlWriter writer, String comment) {
            writer.write("<!-- ");
            this.writeXmlEscaped(writer, comment);
            writer.write(" -->");
        }

        private void writeXmlEscapedChar(XmlWriter writer, char ch) {
            switch (ch) {
                case '<': {
                    writer.write("&lt;");
                    break;
                }
                case '>': {
                    writer.write("&gt;");
                    break;
                }
                case '&': {
                    writer.write("&amp;");
                    break;
                }
                case '\"': {
                    writer.write("&quot;");
                    break;
                }
                case '\'': {
                    writer.write("&apos;");
                    break;
                }
                default: {
                    writer.write(ch);
                }
            }
        }

        private void writeXmlEscaped(XmlWriter writer, Object object) {
            String string = object.toString();
            int len = string.length();
            for (int i = 0; i < len; ++i) {
                this.writeXmlEscapedChar(writer, string.charAt(i));
            }
        }
    }

    public static abstract class Strategy {
        abstract void openElement(XmlWriter var1, String var2);

        abstract void closeElement(XmlWriter var1, String var2, boolean var3);

        abstract void endElement(XmlWriter var1, String var2);

        abstract void writeAttribute(XmlWriter var1, String var2, Object var3);

        abstract void writeAttribute(XmlWriter var1, String var2, Object ... var3);

        abstract void writeText(XmlWriter var1, char var2);

        abstract void writeText(XmlWriter var1, char[] var2);

        abstract void writeText(XmlWriter var1, char[] var2, int var3, int var4);

        abstract void writeTextObject(XmlWriter var1, Object var2);

        abstract void writeComment(XmlWriter var1, String var2);
    }
}

