/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.TempFile;
import com.caucho.vfs.TempReadStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;

public class TempStream
extends StreamImpl {
    private String _encoding;
    private TempBuffer _head;
    private TempBuffer _tail;
    private Path _backingDir;
    private Path _backingFile;
    private TempFile _tempBackingFile;
    private WriteStream _backingStream;
    private boolean _useBackingFile;
    private TempReadStream _tempReadStream;

    public TempStream(Path backingDir) {
        this._backingDir = backingDir;
    }

    public TempStream() {
    }

    public void openWrite() {
        TempBuffer ptr = this._head;
        this._head = null;
        this._tail = null;
        this._encoding = null;
        TempBuffer.freeAll(ptr);
        this._useBackingFile = false;
        if (this._backingStream != null) {
            try {
                this._backingStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this._backingStream = null;
        }
    }

    public byte[] getTail() {
        return this._tail.getBuffer();
    }

    public void changeToBackingFile(int index) throws IOException {
        if (this._backingFile == null) {
            this._backingFile = this._backingDir.createTempFile("tmp", ".tmp");
            this._tempBackingFile = new TempFile(this._backingFile);
        }
        this._backingStream = this._backingFile.openWrite();
        this._useBackingFile = true;
        while (this._head != null) {
            TempBuffer next = this._head._next;
            this._backingStream.write(this._head._buf, 0, this._head._length);
            TempBuffer.free(this._head);
            this._head = next;
        }
    }

    public void setEncoding(String encoding) {
        this._encoding = encoding;
    }

    public String getEncoding() {
        return this._encoding;
    }

    public boolean canWrite() {
        return true;
    }

    public void write(byte[] buf, int offset, int length, boolean isEnd) throws IOException {
        if (this._backingStream != null) {
            this._backingStream.write(buf, offset, length);
        } else {
            int index = 0;
            while (index < length) {
                if (this._tail == null) {
                    this.addBuffer(TempBuffer.allocate());
                } else if (this._tail._length >= this._tail._buf.length) {
                    if (this._head._bufferCount < 8 || this._backingDir == null) {
                        this.addBuffer(TempBuffer.allocate());
                    } else {
                        this.changeToBackingFile(index);
                        this._backingStream.write(buf, offset, length);
                        return;
                    }
                }
                int sublen = this._tail._buf.length - this._tail._length;
                if (length - index < sublen) {
                    sublen = length - index;
                }
                System.arraycopy(buf, index + offset, this._tail._buf, this._tail._length, sublen);
                index += sublen;
                this._tail._length += sublen;
            }
        }
    }

    private void addBuffer(TempBuffer buf) {
        buf._next = null;
        if (this._tail != null) {
            this._tail._next = buf;
            this._tail = buf;
        } else {
            this._tail = buf;
            this._head = buf;
        }
        ++this._head._bufferCount;
    }

    public void flush() throws IOException {
        if (this._backingStream != null) {
            this._backingStream.flush();
        }
    }

    public void close() throws IOException {
        if (this._backingStream != null) {
            this._backingStream.close();
            this._backingStream = null;
        }
        super.close();
    }

    public ReadStream openRead() throws IOException {
        return this.openRead(false);
    }

    public ReadStream openRead(boolean free) throws IOException {
        this.close();
        if (this._useBackingFile) {
            return this._backingFile.openRead();
        }
        TempReadStream read = new TempReadStream(this._head);
        read.setFreeWhenDone(free);
        if (free) {
            this._head = null;
            this._tail = null;
        }
        read.setPath(this.getPath());
        return new ReadStream(read);
    }

    public void openRead(ReadStream rs, boolean free) throws IOException {
        this.close();
        if (this._useBackingFile) {
            StreamImpl impl = this._backingFile.openReadImpl();
            rs.init(impl, null);
        } else {
            if (this._tempReadStream == null) {
                this._tempReadStream = new TempReadStream();
                this._tempReadStream.setPath(this.getPath());
            }
            this._tempReadStream.init(this._head);
            this._tempReadStream.setFreeWhenDone(free);
            if (free) {
                this._head = null;
                this._tail = null;
            }
            rs.init(this._tempReadStream, null);
        }
    }

    public TempBuffer getHead() {
        return this._head;
    }

    public int getLength() {
        int length = 0;
        TempBuffer ptr = this._head;
        while (ptr != null) {
            length += ptr.getLength();
            ptr = ptr._next;
        }
        return length;
    }

    public ReadStream openRead(ReadStream s) throws IOException {
        this.close();
        if (this._useBackingFile) {
            return this._backingFile.openRead();
        }
        TempReadStream read = new TempReadStream(this._head);
        read.setFreeWhenDone(false);
        read.setPath(this.getPath());
        s.init(read, null);
        return s;
    }

    public void clearWrite() {
        TempBuffer ptr = this._head;
        this._head = null;
        this._tail = null;
        TempBuffer.freeAll(ptr);
        if (this._backingStream != null) {
            try {
                this._backingStream.close();
                this._backingStream = this._backingFile.openWrite();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this._useBackingFile = false;
    }

    public void discard() {
        this._head = null;
        this._tail = null;
        if (this._backingStream != null) {
            try {
                this._backingStream.close();
                this._backingStream = this._backingFile.openWrite();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this._useBackingFile = false;
    }

    public TempStream copy() {
        TempStream newStream = new TempStream();
        for (TempBuffer ptr = this._head; ptr != null; ptr = ptr.getNext()) {
            TempBuffer newPtr = TempBuffer.allocate();
            if (newStream._tail != null) {
                newStream._tail.setNext(newPtr);
            } else {
                newStream._head = newPtr;
            }
            newStream._tail = newPtr;
            newPtr.write(ptr.getBuffer(), 0, ptr.getLength());
        }
        return newStream;
    }

    public void destroy() {
        try {
            this.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            TempFile tempBackingFile;
            this._tempBackingFile = tempBackingFile = this._tempBackingFile;
            if (tempBackingFile != null) {
                tempBackingFile.remove();
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        TempBuffer ptr = this._head;
        this._head = null;
        this._tail = null;
        TempBuffer.freeAll(ptr);
    }
}

