/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.FreeList;
import com.caucho.vfs.ReadStream;
import java.io.IOException;

public class TempBuffer {
    private static FreeList<TempBuffer> _freeList = new FreeList(32);
    public static final int SIZE = 16384;
    TempBuffer _next;
    final byte[] _buf;
    int _offset;
    int _length;
    int _bufferCount;

    public TempBuffer(int size) {
        this._buf = new byte[size];
    }

    public static TempBuffer allocate() {
        TempBuffer next = _freeList.allocate();
        if (next == null) {
            return new TempBuffer(16384);
        }
        next._next = null;
        next._offset = 0;
        next._length = 0;
        next._bufferCount = 0;
        return next;
    }

    public void clear() {
        this._next = null;
        this._offset = 0;
        this._length = 0;
        this._bufferCount = 0;
    }

    public final byte[] getBuffer() {
        return this._buf;
    }

    public final int getLength() {
        return this._length;
    }

    public final void setLength(int length) {
        this._length = length;
    }

    public final int getCapacity() {
        return this._buf.length;
    }

    public int getAvailable() {
        return this._buf.length - this._length;
    }

    public final TempBuffer getNext() {
        return this._next;
    }

    public final void setNext(TempBuffer next) {
        this._next = next;
    }

    public int write(byte[] buf, int offset, int length) {
        byte[] thisBuf = this._buf;
        int thisLength = this._length;
        if (thisBuf.length - thisLength < length) {
            length = thisBuf.length - thisLength;
        }
        System.arraycopy(buf, offset, thisBuf, thisLength, length);
        this._length = thisLength + length;
        return length;
    }

    public static TempBuffer copyFromStream(ReadStream is) throws IOException {
        TempBuffer head;
        TempBuffer tail = head = TempBuffer.allocate();
        int len = 0;
        while ((len = is.readAll(tail._buf, 0, tail._buf.length)) == tail._buf.length) {
            TempBuffer buf = TempBuffer.allocate();
            tail._length = len;
            tail._next = buf;
            tail = buf;
        }
        if (len == 0 && head == tail) {
            return null;
        }
        if (len == 0) {
            TempBuffer ptr = head;
            while (ptr.getNext() != null) {
                TempBuffer next = ptr.getNext();
                if (next.getNext() == null) {
                    TempBuffer.free(next);
                    ptr._next = null;
                }
                ptr = ptr.getNext();
            }
        } else {
            tail._length = len;
        }
        return head;
    }

    public static void free(TempBuffer buf) {
        buf._next = null;
        if (buf._buf.length == 16384) {
            _freeList.free(buf);
        }
    }

    public static void freeAll(TempBuffer buf) {
        while (buf != null) {
            TempBuffer next = buf._next;
            buf._next = null;
            if (buf._buf.length == 16384) {
                _freeList.free(buf);
            }
            buf = next;
        }
    }
}

