/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.QServerSocket;
import com.caucho.vfs.QSocket;
import com.caucho.vfs.QSocketWrapper;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.logging.Level;
import java.util.logging.Logger;

public class QServerSocketWrapper
extends QServerSocket {
    private static final Logger log = Log.open(QServerSocketWrapper._resin_compat_class_0());
    private ServerSocket _ss;
    private boolean _tcpNoDelay = true;
    private int _connectionReadTimeout = 65000;
    private static Class _resin_compat_class_0;

    public QServerSocketWrapper() {
    }

    public QServerSocketWrapper(ServerSocket ss) {
        this.init(ss);
    }

    public void init(ServerSocket ss) {
        this._ss = ss;
    }

    public void setTcpNoDelay(boolean delay) {
        this._tcpNoDelay = delay;
    }

    public boolean getTcpNoDelay() {
        return this._tcpNoDelay;
    }

    public void setConnectionReadTimeout(int readTimeout) {
        this._connectionReadTimeout = readTimeout;
    }

    public void setConnectionWriteTimeout(int writeTimeout) {
    }

    public boolean accept(QSocket qSocket) throws IOException {
        QSocketWrapper s = (QSocketWrapper)qSocket;
        Socket socket = this._ss.accept();
        if (socket == null) {
            return false;
        }
        if (this._tcpNoDelay) {
            socket.setTcpNoDelay(true);
        }
        socket.setSoTimeout(this._connectionReadTimeout);
        s.init(socket);
        return true;
    }

    public QSocket createSocket() throws IOException {
        return new QSocketWrapper();
    }

    public InetAddress getLocalAddress() {
        return this._ss.getInetAddress();
    }

    public int getLocalPort() {
        return this._ss.getLocalPort();
    }

    public Selector getSelector() {
        try {
            ServerSocketChannel channel = this._ss.getChannel();
            if (channel == null) {
                return null;
            }
            SelectorProvider provider = channel.provider();
            if (provider != null) {
                return provider.openSelector();
            }
            return null;
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
            return null;
        }
    }

    public void close() throws IOException {
        ServerSocket ss;
        this._ss = ss = this._ss;
        if (ss != null) {
            try {
                ss.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String toString() {
        return new CharBuffer().append("ServerSocketWrapper[").append(this.getLocalAddress()).append(":").append(this.getLocalPort()).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.vfs.QServerSocketWrapper");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

