/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.util.Crc64;
import com.caucho.util.L10N;
import com.caucho.util.LruCache;
import com.caucho.util.RandomUtil;
import com.caucho.vfs.OutputStreamWithBuffer;
import com.caucho.vfs.RandomAccessStream;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.ReadWritePair;
import com.caucho.vfs.SchemeMap;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Path {
    protected static final L10N L = new L10N(Path._resin_compat_class_0());
    private static final Integer LOCK = new Integer(0);
    private static final LruCache<PathKey, Path> _pathLookupCache = new LruCache(1024);
    private static final PathKey _key = new PathKey();
    protected SchemeMap _schemeMap;
    private static Class _resin_compat_class_0;

    protected Path(Path root) {
        if (root != null) {
            this._schemeMap = root._schemeMap;
            return;
        }
    }

    public final Path lookup(String name) {
        return this.lookup(name, null);
    }

    public Path lookup(String userPath, Map<String, Object> newAttributes) {
        if (newAttributes != null) {
            return this.lookupImpl(userPath, newAttributes);
        }
        Path path = this.lookupImpl(userPath, newAttributes);
        return path;
    }

    public Path lookupImpl(String userPath, Map<String, Object> newAttributes) {
        Path path;
        char ch;
        int length;
        if (userPath == null) {
            return this.lookupImpl(this.getPath(), newAttributes);
        }
        String scheme = this.scanScheme(userPath);
        if (scheme == null) {
            return this.schemeWalk(userPath, newAttributes, userPath, 0);
        }
        SchemeMap schemeMap = this._schemeMap;
        if (schemeMap == null) {
            schemeMap = SchemeMap.getLocalSchemeMap();
        }
        if (CauchoSystem.isWindows() && (length = scheme.length()) == 1 && ((ch = scheme.charAt(0)) >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z')) {
            path = SchemeMap.getScheme("file");
            if (path != null) {
                return path.schemeWalk(userPath, newAttributes, new CharBuffer().append("/").append(userPath).toString(), 0);
            }
        }
        if ((path = SchemeMap.getScheme(scheme)) == null) {
            return this.schemeWalk(userPath, newAttributes, userPath, 0);
        }
        return path.schemeWalk(userPath, newAttributes, userPath, scheme.length() + 1);
    }

    public final Path lookupNative(String name) {
        return this.lookupNative(name, null);
    }

    public Path lookupNative(String name, Map<String, Object> attributes) {
        return this.lookup(name, attributes);
    }

    public ArrayList<Path> getResources(String name) {
        ArrayList<Path> list = new ArrayList<Path>();
        Path path = this.lookup(name);
        if (path.exists()) {
            list.add(path);
        }
        return list;
    }

    public ArrayList<Path> getResources() {
        ArrayList<Path> list = new ArrayList<Path>();
        list.add(this);
        return list;
    }

    public Path getParent() {
        return this;
    }

    protected String scanScheme(String uri) {
        int i = 0;
        if (uri == null) {
            return null;
        }
        int length = uri.length();
        if (length == 0) {
            return null;
        }
        char ch = uri.charAt(0);
        if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z') {
            for (i = 1; i < length; ++i) {
                ch = uri.charAt(i);
                if (ch == ':') {
                    return uri.substring(0, i).toLowerCase();
                }
                if (!(ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '0' || ch == '+' || ch == '-' || ch == '.')) break;
            }
        }
        return null;
    }

    protected abstract Path schemeWalk(String var1, Map<String, Object> var2, String var3, int var4);

    public String getURL() {
        return Path.escapeURL(new CharBuffer().append(this.getScheme()).append(":").append(this.getFullPath()).toString());
    }

    public abstract String getScheme();

    public String getHost() {
        throw new UnsupportedOperationException();
    }

    public int getPort() {
        throw new UnsupportedOperationException();
    }

    public abstract String getPath();

    public String getTail() {
        return "";
    }

    public String getQuery() {
        throw new UnsupportedOperationException();
    }

    public String getNativePath() {
        return this.getFullPath();
    }

    public String getUserPath() {
        return this.getPath();
    }

    public void setUserPath(String userPath) {
    }

    public String getFullPath() {
        return this.getPath();
    }

    public String getRelativePath() {
        return this.getPath();
    }

    public boolean exists() {
        return false;
    }

    public String getContentType() {
        return "application/octet-stream";
    }

    public boolean isDirectory() {
        return false;
    }

    public boolean isFile() {
        return false;
    }

    public boolean isObject() {
        return false;
    }

    public long getLength() {
        return 0L;
    }

    public long getLastModified() {
        return 0L;
    }

    public void setLastModified(long time) {
    }

    public long getLastAccessTime() {
        return this.getLastModified();
    }

    public long getCreateTime() {
        return this.getLastModified();
    }

    public boolean canRead() {
        return false;
    }

    public boolean canWrite() {
        return false;
    }

    public void setReadOnly(boolean isReadOnly) {
    }

    public void changeGroup(int gid) throws IOException {
    }

    public void changeGroup(String groupName) throws IOException {
    }

    public void chmod(int value) {
    }

    public void changeOwner(int uid) throws IOException {
    }

    public void changeOwner(String ownerName) throws IOException {
    }

    public String[] list() throws IOException {
        return new String[0];
    }

    public Iterator<String> iterator() throws IOException {
        return new ArrayIterator(this.list());
    }

    public boolean mkdir() throws IOException {
        return false;
    }

    public boolean mkdirs() throws IOException {
        return false;
    }

    public boolean remove() throws IOException {
        return false;
    }

    public boolean removeAll() throws IOException {
        if (this.isDirectory()) {
            String[] list = this.list();
            for (int i = 0; i < list.length; ++i) {
                Path subpath = this.lookup(list[i]);
                subpath.removeAll();
            }
        }
        return this.remove();
    }

    public boolean renameTo(Path path) throws IOException {
        return false;
    }

    public final boolean renameTo(String path) throws IOException {
        return this.renameTo(this.lookup(path));
    }

    public Path createRoot() {
        return this.createRoot(SchemeMap.getNullSchemeMap());
    }

    public Path createRoot(SchemeMap schemeMap) {
        throw new UnsupportedOperationException("createRoot");
    }

    public void bind(Path context) {
        throw new UnsupportedOperationException("bind");
    }

    public void unbind() {
        throw new UnsupportedOperationException("unbind");
    }

    public Object getValue() throws Exception {
        throw new UnsupportedOperationException("getValue");
    }

    public void setValue(Object obj) throws Exception {
        throw new UnsupportedOperationException("setValue");
    }

    public Object getAttribute(String name) throws IOException {
        return null;
    }

    public Iterator getAttributeNames() throws IOException {
        return null;
    }

    public final ReadStream openRead() throws IOException {
        StreamImpl impl = this.openReadImpl();
        impl.setPath(this);
        return new ReadStream(impl);
    }

    public final WriteStream openWrite() throws IOException {
        StreamImpl impl = this.openWriteImpl();
        impl.setPath(this);
        return new WriteStream(impl);
    }

    public ReadWritePair openReadWrite() throws IOException {
        StreamImpl impl = this.openReadWriteImpl();
        impl.setPath(this);
        WriteStream writeStream = new WriteStream(impl);
        ReadStream readStream = new ReadStream(impl, writeStream);
        return new ReadWritePair(readStream, writeStream);
    }

    public void openReadWrite(ReadStream is, WriteStream os) throws IOException {
        StreamImpl impl = this.openReadWriteImpl();
        impl.setPath(this);
        os.init(impl);
        is.init(impl, os);
    }

    public WriteStream openAppend() throws IOException {
        StreamImpl impl = this.openAppendImpl();
        return new WriteStream(impl);
    }

    public RandomAccessStream openRandomAccess() throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createNewFile() throws IOException {
        Integer n = LOCK;
        synchronized (n) {
            if (!this.exists()) {
                WriteStream s = this.openWrite();
                s.close();
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path createTempFile(String prefix, String suffix) throws IOException {
        if (prefix == null || prefix.length() < 3) {
            throw new IllegalArgumentException(new CharBuffer().append("prefix too short: ").append(prefix).toString());
        }
        if (suffix == null) {
            suffix = ".tmp";
        }
        Integer n = LOCK;
        synchronized (n) {
            for (int i = 0; i < 32768; ++i) {
                int r = Math.abs((int)RandomUtil.getRandomLong());
                Path file = this.lookup(new CharBuffer().append(prefix).append(r).append(suffix).toString());
                if (!file.createNewFile()) continue;
                return file;
            }
        }
        throw new IOException("cannot create temp file");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToStream(OutputStream os) throws IOException {
        StreamImpl is = this.openReadImpl();
        TempBuffer tempBuffer = TempBuffer.allocate();
        try {
            int len;
            byte[] buffer = tempBuffer.getBuffer();
            int length = buffer.length;
            while ((len = is.read(buffer, 0, length)) > 0) {
                os.write(buffer, 0, len);
            }
        }
        finally {
            TempBuffer.free(tempBuffer);
            is.close();
        }
    }

    public void writeToStream(OutputStreamWithBuffer os) throws IOException {
        StreamImpl is = this.openReadImpl();
        try {
            byte[] buffer = os.getBuffer();
            int offset = os.getBufferOffset();
            int length = buffer.length;
            while (true) {
                int sublen;
                if ((sublen = length - offset) <= 0) {
                    buffer = os.nextBuffer(offset);
                    offset = 0;
                    sublen = length;
                }
                if ((sublen = is.read(buffer, offset, sublen)) <= 0) {
                    os.setBufferOffset(offset);
                    return;
                }
                offset += sublen;
            }
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getCrc64() {
        long l;
        if (this.isDirectory()) {
            String[] list = this.list();
            long digest = 0L;
            for (int i = 0; i < list.length; ++i) {
                digest = Crc64.generate(digest, list[i]);
            }
            return digest;
        }
        if (!this.canRead()) return -1L;
        ReadStream is = this.openRead();
        try {
            int ch;
            long digest = 0L;
            while ((ch = is.read()) >= 0) {
                digest = Crc64.next(digest, ch);
            }
            l = digest;
        }
        catch (Throwable throwable) {
            try {
                is.close();
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                return -1L;
            }
        }
        is.close();
        return l;
    }

    public Object getObject() throws IOException {
        throw new UnsupportedOperationException(new CharBuffer().append(this.getScheme()).append(": doesn't support getObject").toString());
    }

    public void setObject(Object obj) throws IOException {
        throw new UnsupportedOperationException(new CharBuffer().append(this.getScheme()).append(": doesn't support setObject").toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Path)) {
            return false;
        }
        return this.getPath().equals(((Path)o).getPath());
    }

    public String toString() {
        return this.getPath();
    }

    protected StreamImpl openReadImpl() throws IOException {
        throw new UnsupportedOperationException(new CharBuffer().append("openRead:").append(this.getClass().getName()).toString());
    }

    protected StreamImpl openWriteImpl() throws IOException {
        throw new UnsupportedOperationException(new CharBuffer().append("openWrite:").append(this.getClass().getName()).toString());
    }

    protected StreamImpl openReadWriteImpl() throws IOException {
        throw new UnsupportedOperationException(new CharBuffer().append("openReadWrite:").append(this.getClass().getName()).toString());
    }

    protected StreamImpl openAppendImpl() throws IOException {
        throw new UnsupportedOperationException(new CharBuffer().append("openAppend:").append(this.getClass().getName()).toString());
    }

    protected static String escapeURL(String rawURL) {
        CharBuffer cb = null;
        int length = rawURL.length();
        block4: for (int i = 0; i < length; ++i) {
            char ch = rawURL.charAt(i);
            switch (ch) {
                case '#': {
                    if (cb == null) {
                        cb = new CharBuffer();
                        cb.append(rawURL, 0, i);
                    }
                    cb.append("%23");
                    continue block4;
                }
                case '%': {
                    if (cb == null) {
                        cb = new CharBuffer();
                        cb.append(rawURL, 0, i);
                    }
                    cb.append("%25");
                    continue block4;
                }
                default: {
                    if (cb == null) continue block4;
                    cb.append(ch);
                }
            }
        }
        if (cb != null) {
            return cb.toString();
        }
        return rawURL;
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.vfs.Path");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    static class PathKey {
        private Path _parent;
        private String _lookup;

        PathKey() {
        }

        PathKey(Path parent, String lookup) {
            this._parent = parent;
            this._lookup = lookup;
        }

        void init(Path parent, String lookup) {
            this._parent = parent;
            this._lookup = lookup;
        }

        public int hashCode() {
            return System.identityHashCode(this._parent) * 65521 + this._lookup.hashCode();
        }

        public boolean equals(Object test) {
            if (!(test instanceof PathKey)) {
                return false;
            }
            PathKey key = (PathKey)test;
            return this._parent == key._parent && this._lookup.equals(key._lookup);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ArrayIterator
    implements Iterator<String> {
        String[] list;
        int index;

        @Override
        public boolean hasNext() {
            return this.index < this.list.length;
        }

        @Override
        public String next() {
            return this.index < this.list.length ? this.list[this.index++] : null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        ArrayIterator(String[] list) {
            this.list = list;
            this.index = 0;
        }
    }
}

