/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.CharBuffer;
import com.caucho.vfs.StreamImpl;
import java.io.IOException;

public class JniFileStream
extends StreamImpl {
    private int _fd;
    private long _pos;
    private boolean _canRead;
    private boolean _canWrite;

    JniFileStream(int fd, boolean canRead, boolean canWrite) {
        this.init(fd, canRead, canWrite);
    }

    void init(int fd, boolean canRead, boolean canWrite) {
        this._fd = fd;
        this._pos = 0L;
        this._canRead = canRead;
        this._canWrite = canWrite;
    }

    public boolean canRead() {
        return this._canRead && this._fd >= 0;
    }

    public boolean hasSkip() {
        return this._fd >= 0;
    }

    public long skip(long length) throws IOException {
        long pos = this.nativeSkip(this._fd, length);
        if (pos < 0L) {
            return -1L;
        }
        this._pos = pos;
        return length;
    }

    public int read(byte[] buf, int offset, int length) throws IOException {
        if (buf == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || buf.length < offset + length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int result = this.nativeRead(this._fd, buf, offset, length);
        if (result > 0) {
            this._pos += (long)result;
        }
        return result;
    }

    public int getAvailable() throws IOException {
        if (this._fd >= 0) {
            long length = this.getPath().getLength();
            return (int)(length - this._pos);
        }
        return -1;
    }

    public boolean canWrite() {
        return this._canWrite && this._fd >= 0;
    }

    public void write(byte[] buf, int offset, int length, boolean isEnd) throws IOException {
        if (buf == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || buf.length < offset + length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.nativeWrite(this._fd, buf, offset, length);
    }

    public void seekStart(long offset) throws IOException {
        this.nativeSeekStart(this._fd, offset);
    }

    public void seekEnd(long offset) throws IOException {
        this.nativeSeekEnd(this._fd, offset);
    }

    public void flush() throws IOException {
    }

    public void flushToDisk() throws IOException {
        this.nativeFlushToDisk(this._fd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        int fd;
        JniFileStream jniFileStream = this;
        synchronized (jniFileStream) {
            fd = this._fd;
            this._fd = -1;
        }
        this.nativeClose(fd);
    }

    protected void finalize() throws IOException {
        this.close();
    }

    native int nativeRead(int var1, byte[] var2, int var3, int var4) throws IOException;

    native int nativeWrite(int var1, byte[] var2, int var3, int var4) throws IOException;

    native long nativeSkip(int var1, long var2) throws IOException;

    native int nativeFlushToDisk(int var1) throws IOException;

    native int nativeClose(int var1) throws IOException;

    native int nativeSeekStart(int var1, long var2) throws IOException;

    native int nativeSeekEnd(int var1, long var2) throws IOException;

    public String toString() {
        return new CharBuffer().append("JniFileStream[").append(this.getPath().getNativePath()).append("]").toString();
    }

    static {
        try {
            System.loadLibrary("resin");
        }
        catch (Throwable e) {
            System.err.println(new CharBuffer().append("Can't open Resin JNI library: ").append(e).toString());
        }
    }
}

