/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.log.Log;
import com.caucho.util.L10N;
import com.caucho.vfs.FilesystemPath;
import com.caucho.vfs.IOExceptionWrapper;
import com.caucho.vfs.Path;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JndiPath
extends FilesystemPath {
    protected static final Logger log = Log.open(JndiPath._resin_compat_class_0());
    protected static final L10N L = new L10N(JndiPath._resin_compat_class_0());
    private Context parent;
    private static Class _resin_compat_class_0;

    JndiPath() {
        super(null, "/", "/");
        this._root = this;
    }

    protected JndiPath(FilesystemPath root, String userPath, String path) {
        super(root, userPath, path);
    }

    @Override
    protected Path fsWalk(String userPath, Map<String, Object> attributes, String path) {
        return new JndiPath(this._root, userPath, path);
    }

    @Override
    public String getScheme() {
        return "jndi";
    }

    @Override
    public boolean mkdir() throws IOException {
        try {
            Context parent = this.getAllButLast(this.getPath());
            parent.createSubcontext(this.getTail());
            return true;
        }
        catch (Exception e) {
            throw new IOExceptionWrapper(e);
        }
    }

    @Override
    public Object getObject() throws IOException {
        try {
            Context parent = this.getAllButLast(this.getPath());
            return parent.lookup(this.getTail());
        }
        catch (Exception e) {
            throw new IOExceptionWrapper(e);
        }
    }

    @Override
    public void setObject(Object value) throws IOException {
        try {
            Context parent = this.getAllButLast(this.getPath());
            parent.rebind(this.getTail(), value);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOExceptionWrapper(e);
        }
    }

    private Context getAllButLast(String path) throws NamingException {
        int tail;
        if (this.parent != null) {
            return this.parent;
        }
        Context context = new InitialContext();
        int head = 1;
        while ((tail = path.indexOf(47, head)) > 0) {
            String section = path.substring(head, tail);
            if (context == null) {
                throw new NamingException(L.l("null context for `{0}'", path));
            }
            context = (Context)context.lookup(section);
            head = tail + 1;
        }
        this.parent = context;
        return this.parent;
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.vfs.JndiPath");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

