/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.L10N;
import com.caucho.vfs.FilesystemPath;
import com.caucho.vfs.HttpPath;
import com.caucho.vfs.HttpStream;
import com.caucho.vfs.HttpStreamWrapper;
import com.caucho.vfs.StreamImpl;
import java.io.IOException;
import java.util.Map;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpsPath
extends HttpPath {
    protected static L10N L = new L10N(HttpsPath._resin_compat_class_0());
    private static Class _resin_compat_class_0;

    HttpsPath(String host, int port) {
        super(host, port);
    }

    HttpsPath(FilesystemPath root, String userPath, Map<String, Object> newAttributes, String path, String query) {
        super(root, userPath, newAttributes, path, query);
    }

    @Override
    protected HttpPath create(String host, int port) {
        return new HttpsPath(host, port);
    }

    @Override
    protected HttpPath create(FilesystemPath root, String userPath, Map<String, Object> newAttributes, String path, String query) {
        return new HttpsPath(root, userPath, newAttributes, path, query);
    }

    @Override
    public String getScheme() {
        return "https";
    }

    @Override
    public StreamImpl openReadImpl() throws IOException {
        HttpStreamWrapper stream = HttpStream.openRead(this);
        stream.setSSL(true);
        return stream;
    }

    @Override
    public StreamImpl openReadWriteImpl() throws IOException {
        HttpStreamWrapper stream = HttpStream.openReadWrite(this);
        stream.setSSL(true);
        return stream;
    }

    @Override
    public int hashCode() {
        return 17 + 65537 * super.hashCode() + 37 * this._host.hashCode() + this._port;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof HttpsPath)) {
            return false;
        }
        HttpsPath test = (HttpsPath)o;
        if (!this._host.equals(test._host)) {
            return false;
        }
        if (this._port != test._port) {
            return false;
        }
        if (this._query != null && !this._query.equals(test._query)) {
            return false;
        }
        return this._query != null || test._query == null;
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.vfs.HttpsPath");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

