/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.log.Log;
import com.caucho.util.Alarm;
import com.caucho.util.CharBuffer;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ThreadPool
implements Runnable {
    private static final Logger log = Log.open(ThreadPool._resin_compat_class_0());
    private static final int RING_SIZE = 4096;
    private static final int RING_MASK = 4095;
    private static final long MAX_EXPIRE = 0x3FFFFFFFFFFFFFFFL;
    private static final int SPARE_GAP = 5;
    private static int _maxThreads = 128;
    private static int _minSpareThreads = 5;
    private static long _resetCount;
    private static final ThreadPool[] _idleRing;
    private static final ArrayList<ThreadPool> _threads;
    private static final ArrayList<Runnable> _taskQueue;
    private static final ArrayList<ClassLoader> _loaderQueue;
    private static final ThreadLauncher _launcher;
    private static final ScheduleThread _scheduler;
    private static boolean _isQueuePriority;
    private static int _threadCount;
    private static int _idleHead;
    private static int _idleTail;
    private static int _startCount;
    private static int _scheduleWaitCount;
    private static int _g_id;
    private int _id = _g_id++;
    private String _name = new CharBuffer().append("resin-").append(this._id).toString();
    private Thread _thread;
    private Thread _queueThread;
    private long _threadResetCount;
    private Runnable _task;
    private ClassLoader _classLoader;
    private static Class _resin_compat_class_0;

    private ThreadPool() {
    }

    public static void setThreadMax(int max) {
        _maxThreads = max;
    }

    public static int getThreadMax() {
        return _maxThreads;
    }

    public static void setSpareThreadMin(int min) {
        _minSpareThreads = min;
    }

    public static int getSpareThreadMin() {
        return _minSpareThreads;
    }

    public static int getThreadCount() {
        return _threadCount;
    }

    public static int getIdleThreadCount() {
        return _idleHead - _idleTail & 0xFFF;
    }

    public static int getActiveThreadCount() {
        return ThreadPool.getThreadCount() - ThreadPool.getIdleThreadCount();
    }

    public static int getFreeThreadCount() {
        return _maxThreads - _threadCount;
    }

    public static void reset() {
        ++_resetCount;
    }

    public static boolean schedule(Runnable task) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return ThreadPool.schedule(task, loader, _minSpareThreads, 0x3FFFFFFFFFFFFFFFL, true);
    }

    public static boolean schedule(Runnable task, long timeout) {
        long expire = timeout < 0L || timeout > 0x3FFFFFFFFFFFFFFFL ? 0x3FFFFFFFFFFFFFFFL : Alarm.getCurrentTime() + timeout;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return ThreadPool.schedule(task, loader, _minSpareThreads, expire, true);
    }

    public static void schedulePriority(Runnable task) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        ThreadPool.schedule(task, loader, 0, 0x3FFFFFFFFFFFFFFFL, true);
    }

    public static boolean start(Runnable task) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return ThreadPool.schedule(task, loader, _minSpareThreads, 0x3FFFFFFFFFFFFFFFL, false);
    }

    public static boolean start(Runnable task, long timeout) {
        long expire = timeout < 0L || timeout > 0x3FFFFFFFFFFFFFFFL ? 0x3FFFFFFFFFFFFFFFL : Alarm.getCurrentTime() + timeout;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return ThreadPool.schedule(task, loader, _minSpareThreads, expire, false);
    }

    public static void startPriority(Runnable task) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        ThreadPool.schedule(task, loader, 0, 0x3FFFFFFFFFFFFFFFL, false);
    }

    public static boolean startPriority(Runnable task, long timeout) {
        long expire = timeout < 0L || timeout > 0x3FFFFFFFFFFFFFFFL ? 0x3FFFFFFFFFFFFFFFL : Alarm.getCurrentTime() + timeout;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return ThreadPool.schedule(task, loader, 0, expire, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void interrupt() {
        ThreadPool[] threadPoolArray = _idleRing;
        synchronized (_idleRing) {
            for (int i = 0; i < _threads.size(); ++i) {
                ThreadPool item = _threads.get(i);
                Thread thread = item.getThread();
                if (thread == null) continue;
                try {
                    thread.interrupt();
                    continue;
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static boolean schedule(Runnable task, ClassLoader loader, int freeThreads, long expireTime, boolean queueIfFull) {
        ThreadPool poolItem = null;
        while (true) {
            if (poolItem != null) {
                super.start(task, loader);
                return true;
            }
            try {
                ThreadPool[] threadPoolArray = _idleRing;
                // MONITORENTER : _idleRing
                int idleCount = _idleHead - _idleTail & 0xFFF;
                int freeCount = idleCount + _maxThreads - _threadCount;
                boolean startNew = false;
                if (idleCount > 0 && freeThreads < freeCount) {
                    _idleHead = _idleHead - 1 & 0xFFF;
                    poolItem = _idleRing[_idleHead];
                    ThreadPool._idleRing[ThreadPool._idleHead] = null;
                    if (idleCount < _minSpareThreads) {
                        startNew = true;
                    }
                } else {
                    startNew = true;
                }
                if (startNew) {
                    Object object = _launcher;
                    // MONITORENTER : object
                    _launcher.notify();
                    // MONITOREXIT : object
                    if (poolItem == null) {
                        if (queueIfFull) {
                            object = _taskQueue;
                            // MONITORENTER : object
                            _taskQueue.add(task);
                            _loaderQueue.add(loader);
                            _taskQueue.notify();
                            // MONITOREXIT : object
                            // MONITOREXIT : threadPoolArray
                            return false;
                        }
                        if (expireTime < Alarm.getCurrentTime()) {
                            // MONITOREXIT : threadPoolArray
                            return false;
                        }
                        ++_scheduleWaitCount;
                        try {
                            Thread.interrupted();
                            _idleRing.wait(5000L);
                        }
                        finally {
                            --_scheduleWaitCount;
                        }
                    }
                }
                // MONITOREXIT : threadPoolArray
            }
            catch (OutOfMemoryError e) {
                try {
                    System.err.println("Exiting due to OutOfMemoryError");
                    continue;
                }
                finally {
                    System.exit(11);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    int getId() {
        return this._id;
    }

    String getName() {
        return this._name;
    }

    Thread getThread() {
        return this._thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean start(Runnable task, ClassLoader loader) {
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            this._task = task;
            this._classLoader = loader;
            this.notify();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this._thread = Thread.currentThread();
        Object object = _idleRing;
        synchronized (_idleRing) {
            ++_threadCount;
            _threads.add(this);
            if (--_startCount < 0) {
                System.out.println(new CharBuffer().append("ThreadPool start count is negative: ").append(_startCount).toString());
                _startCount = 0;
            }
            // ** MonitorExit[var1_1 /* !! */ ] (shouldn't be in output)
            try {
                this.runTasks();
            }
            finally {
                object = _idleRing;
                synchronized (_idleRing) {
                    _threads.remove(this);
                    // ** MonitorExit[var1_1 /* !! */ ] (shouldn't be in output)
                    if (--_threadCount < _minSpareThreads) {
                        object = _launcher;
                        synchronized (object) {
                            _launcher.notify();
                        }
                    }
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void runTasks() {
        this._threadResetCount = _resetCount;
        Thread thread = Thread.currentThread();
        ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
        boolean isIdle = false;
        while (true) {
            try {
                while (true) {
                    if (!isIdle) {
                        _isQueuePriority = true;
                        isIdle = true;
                        ThreadPool[] threadPoolArray = _idleRing;
                        // MONITORENTER : _idleRing
                        ThreadPool._idleRing[ThreadPool._idleHead] = this;
                        _idleHead = _idleHead + 1 & 0xFFF;
                        if (_scheduleWaitCount > 0) {
                            _idleRing.notify();
                        }
                        // MONITOREXIT : threadPoolArray
                    }
                    Runnable task = null;
                    ClassLoader classLoader = null;
                    Thread.interrupted();
                    ThreadPool threadPool = this;
                    // MONITORENTER : threadPool
                    if (this._task == null) {
                        thread.setContextClassLoader(systemClassLoader);
                        this.wait(60000L);
                    }
                    task = this._task;
                    this._task = null;
                    classLoader = this._classLoader;
                    this._classLoader = null;
                    // MONITOREXIT : threadPool
                    if (task != null) {
                        isIdle = false;
                        thread.setContextClassLoader(classLoader);
                        try {
                            task.run();
                        }
                        catch (Throwable e) {
                            log.log(Level.WARNING, e.toString(), e);
                        }
                        finally {
                            thread.setContextClassLoader(ClassLoader.getSystemClassLoader());
                        }
                        continue;
                    }
                    boolean isDead = false;
                    ThreadPool[] threadPoolArray = _idleRing;
                    // MONITORENTER : _idleRing
                    int idleCount = _idleHead - _idleTail & 0xFFF;
                    if (_idleRing[_idleTail] == this && (_minSpareThreads + 5 < idleCount || _resetCount != this._threadResetCount)) {
                        isDead = true;
                        ThreadPool._idleRing[ThreadPool._idleTail] = null;
                        _idleTail = (_idleTail + 1) % 4095;
                    }
                    // MONITOREXIT : threadPoolArray
                    if (isDead) return;
                }
            }
            catch (Throwable e) {
                continue;
            }
            break;
        }
    }

    static {
        _idleRing = new ThreadPool[4096];
        _threads = new ArrayList();
        _taskQueue = new ArrayList();
        _loaderQueue = new ArrayList();
        _launcher = ThreadLauncher.create();
        _scheduler = ScheduleThread.create();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.util.ThreadPool");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    static class ScheduleThread
    implements Runnable {
        private static ScheduleThread _scheduler;

        private ScheduleThread() {
            Thread thread = new Thread(this);
            thread.setName("resin-thread-scheduler");
            thread.setDaemon(true);
            thread.start();
        }

        static ScheduleThread create() {
            if (_scheduler == null) {
                _scheduler = new ScheduleThread();
            }
            return _scheduler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ClassLoader systemLoader = ClassLoader.getSystemClassLoader();
            Thread thread = Thread.currentThread();
            thread.setContextClassLoader(systemLoader);
            while (true) {
                try {
                    while (true) {
                        Runnable task = null;
                        ClassLoader loader = null;
                        Thread.interrupted();
                        ArrayList arrayList = _taskQueue;
                        synchronized (arrayList) {
                            if (_taskQueue.size() > 0) {
                                task = (Runnable)_taskQueue.remove(0);
                                loader = (ClassLoader)_loaderQueue.remove(0);
                            } else {
                                try {
                                    _taskQueue.wait(60000L);
                                }
                                catch (Throwable e) {
                                    thread.interrupted();
                                    log.finer(e.toString());
                                }
                            }
                        }
                        if (task == null) continue;
                        ThreadPool.schedule(task, loader, _minSpareThreads, 0x3FFFFFFFFFFFFFFFL, false);
                    }
                }
                catch (OutOfMemoryError e) {
                    System.exit(10);
                    continue;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }

    static class ThreadLauncher
    implements Runnable {
        private static ThreadLauncher _launcher;

        private ThreadLauncher() {
            Thread thread = new Thread(this);
            thread.setName("resin-thread-launcher");
            thread.setDaemon(true);
            thread.start();
        }

        static ThreadLauncher create() {
            if (_launcher == null) {
                _launcher = new ThreadLauncher();
            }
            return _launcher;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean startConnection(long waitTime) throws InterruptedException {
            boolean doStart = true;
            Object object = _idleRing;
            synchronized (object) {
                int idleCount = _idleHead - _idleTail & 0xFFF;
                if (_maxThreads < _threadCount + _startCount) {
                    doStart = false;
                } else if (_minSpareThreads < idleCount + _startCount) {
                    doStart = false;
                }
                if (doStart) {
                    _startCount++;
                }
            }
            if (doStart) {
                try {
                    ThreadPool poolItem = new ThreadPool();
                    Thread thread = new Thread((Runnable)poolItem, poolItem.getName());
                    thread.setDaemon(true);
                    thread.start();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    _startCount--;
                    if (_startCount < 0) {
                        Thread.dumpStack();
                        _startCount = 0;
                    }
                }
            } else {
                Thread.interrupted();
                object = this;
                synchronized (object) {
                    this.wait(waitTime);
                    return false;
                }
            }
            return true;
        }

        public void run() {
            ClassLoader systemLoader = ClassLoader.getSystemClassLoader();
            Thread.currentThread().setContextClassLoader(systemLoader);
            try {
                for (int i = 0; i < _minSpareThreads; ++i) {
                    this.startConnection(0L);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            while (true) {
                try {
                    while (true) {
                        this.startConnection(10000L);
                        Thread.currentThread();
                        Thread.yield();
                    }
                }
                catch (OutOfMemoryError e) {
                    System.exit(10);
                    continue;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

