/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.Alarm;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.TimeZone;

public class QDate {
    public static final int YEAR = 0;
    public static final int MONTH = 1;
    public static final int DAY_OF_MONTH = 2;
    public static final int DAY = 3;
    public static final int DAY_OF_WEEK = 4;
    public static final int HOUR = 5;
    public static final int MINUTE = 6;
    public static final int SECOND = 7;
    public static final int MILLISECOND = 8;
    public static final int TIME = 9;
    public static final int TIME_ZONE = 10;
    static final long MS_PER_DAY = 86400000L;
    static final long MS_PER_EON = 12622780800000L;
    static final int[] DAYS_IN_MONTH = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    static final String[] DAY_NAMES = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    static final String[] MONTH_NAMES = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private static final String[] SHORT_WEEKDAY = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    private static final String[] LONG_WEEKDAY = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
    private static final String[] SHORT_MONTH = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private static final String[] LONG_MONTH = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    private static TimeZone _localTimeZone = TimeZone.getDefault();
    private static TimeZone _gmtTimeZone = TimeZone.getTimeZone("UTC");
    private static String _localDstName = _localTimeZone.getDisplayName(true, 0);
    private static String _localStdName = _localTimeZone.getDisplayName(false, 0);
    private static String _gmtDstName = _gmtTimeZone.getDisplayName(true, 0);
    private static String _gmtStdName = _gmtTimeZone.getDisplayName(false, 0);
    private static QDate _gmtDate = new QDate(false);
    private static QDate _localDate = new QDate(true);
    private TimeZone _timeZone;
    private String _dstName;
    private String _stdName;
    private DateFormat _dateFormat;
    private Date _date = new Date();
    private long _localTimeOfEpoch;
    private long _dayOfEpoch;
    private long _year;
    private int _dayOfYear;
    private long _month;
    private long _dayOfMonth;
    private long _hour;
    private long _minute;
    private long _second;
    private long _ms;
    private boolean _isLeapYear;
    private long _timeOfDay;
    private boolean _isDaylightTime;
    private long _zoneOffset;
    private String _zoneName;
    private long _lastTime;
    private String _lastDate;

    public QDate() {
        this(_gmtTimeZone);
    }

    public QDate(boolean isLocal) {
        this(isLocal ? _localTimeZone : _gmtTimeZone);
    }

    public QDate(TimeZone zone) {
        this._timeZone = zone;
        if (zone == _gmtTimeZone) {
            this._stdName = _gmtStdName;
            this._dstName = _gmtDstName;
        } else if (zone == _localTimeZone) {
            this._stdName = _localStdName;
            this._dstName = _localDstName;
        } else {
            this._stdName = this._timeZone.getDisplayName(false, 0);
            this._dstName = this._timeZone.getDisplayName(true, 0);
        }
        this.setLocalTime(Alarm.getCurrentTime());
    }

    public QDate(long year, long month, long dayOfMonth) {
        this(_localTimeZone);
        this.setDate(year, month, dayOfMonth);
    }

    public static QDate createLocal() {
        return new QDate(true);
    }

    public void setLocalTime(long time) {
        if (this._timeZone != _gmtTimeZone) {
            this.calculateSplit(time);
        } else {
            this.calculateSplit(time - (long)_localTimeZone.getRawOffset());
            long offset = _localTimeZone.getOffset(1, (int)this._year, (int)this._month, (int)this._dayOfMonth + 1, this.getDayOfWeek(), (int)this._timeOfDay);
            this.calculateSplit(time - offset);
        }
    }

    public long getLocalTime() {
        if (this._timeZone != _gmtTimeZone) {
            return this._localTimeOfEpoch;
        }
        long offset = _localTimeZone.getOffset(1, (int)this._year, (int)this._month, (int)this._dayOfMonth + 1, this.getDayOfWeek(), (int)this._timeOfDay);
        return this._localTimeOfEpoch + offset;
    }

    public void setGMTTime(long time) {
        this.calculateSplit(time + (long)this._timeZone.getRawOffset());
        if (this._isDaylightTime) {
            this.calculateSplit(time + this._zoneOffset);
        }
    }

    public long getGMTTime() {
        return this._localTimeOfEpoch - this._zoneOffset;
    }

    public long getTimeOfDay() {
        return this._timeOfDay;
    }

    public int getYear() {
        return (int)this._year;
    }

    public void setYear(int year) {
        this._year = year;
        this.calculateJoin();
        this.calculateSplit(this._localTimeOfEpoch);
    }

    public int getMonth() {
        return (int)this._month;
    }

    public void setMonth(int month) {
        this._month = month;
        this.calculateJoin();
        this.calculateSplit(this._localTimeOfEpoch);
    }

    public int getDayOfMonth() {
        return (int)this._dayOfMonth + 1;
    }

    public void setDayOfMonth(int day) {
        this._dayOfMonth = day - 1;
        this.calculateJoin();
        this.calculateSplit(this._localTimeOfEpoch);
    }

    public int getDaysInMonth() {
        if (this._month == 1L) {
            return this._isLeapYear ? 29 : 28;
        }
        return DAYS_IN_MONTH[(int)this._month];
    }

    public int getDayOfWeek() {
        return (int)(this._dayOfEpoch % 7L + 11L) % 7 + 1;
    }

    public int getDayOfYear() {
        return this._dayOfYear;
    }

    public int getHour() {
        return (int)this._hour;
    }

    public void setHour(int hour) {
        this._hour = hour;
        this.calculateJoin();
        this.calculateSplit(this._localTimeOfEpoch);
    }

    public int getMinute() {
        return (int)this._minute;
    }

    public void setMinute(int minute) {
        this._minute = minute;
        this.calculateJoin();
        this.calculateSplit(this._localTimeOfEpoch);
    }

    public int getSecond() {
        return (int)this._second;
    }

    public void setSecond(int second) {
        this._second = second;
        this.calculateJoin();
        this.calculateSplit(this._localTimeOfEpoch);
    }

    public long getMillisecond() {
        return this._ms;
    }

    public void setMillisecond(long millisecond) {
        this._ms = millisecond;
        this.calculateJoin();
        this.calculateSplit(this._localTimeOfEpoch);
    }

    public long getZoneOffset() {
        return this._zoneOffset;
    }

    public boolean isDST() {
        return this._isDaylightTime;
    }

    public TimeZone getLocalTimeZone() {
        return _localTimeZone;
    }

    public int getWeek() {
        int week;
        int newYears = (int)((this._dayOfEpoch - (long)this._dayOfYear) % 7L + 11L) % 7;
        int normDay = this._dayOfYear - (7 - newYears) % 7;
        int n = week = normDay < 0 ? -1 : normDay / 7;
        if (newYears <= 3) {
            ++week;
        }
        return week;
    }

    public long get(int field) {
        switch (field) {
            case 9: {
                return this.getLocalTime();
            }
            case 0: {
                return this.getYear();
            }
            case 1: {
                return this.getMonth();
            }
            case 2: {
                return this.getDayOfMonth();
            }
            case 3: {
                return this.getDayOfWeek();
            }
            case 4: {
                return this.getDayOfWeek();
            }
            case 5: {
                return this.getHour();
            }
            case 6: {
                return this.getMinute();
            }
            case 7: {
                return this.getSecond();
            }
            case 8: {
                return this.getMillisecond();
            }
            case 10: {
                return this.getZoneOffset() / 1000L;
            }
        }
        return Long.MAX_VALUE;
    }

    public long set(int field, long value) {
        switch (field) {
            case 0: {
                this.setYear((int)value);
                break;
            }
            case 1: {
                this.setMonth((int)value);
                break;
            }
            case 2: {
                this.setDayOfMonth((int)value);
                break;
            }
            case 5: {
                this.setHour((int)value);
                break;
            }
            case 6: {
                this.setMinute((int)value);
                break;
            }
            case 7: {
                this.setSecond((int)value);
                break;
            }
            case 8: {
                this.setMillisecond(value);
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        return this._localTimeOfEpoch;
    }

    public String printDate() {
        if (this._lastDate != null && this._lastTime == this._localTimeOfEpoch) {
            return this._lastDate;
        }
        CharBuffer cb = CharBuffer.allocate();
        this.printDate(cb);
        this._lastDate = cb.close();
        this._lastTime = this._localTimeOfEpoch;
        return this._lastDate;
    }

    public void printDate(CharBuffer cb) {
        cb.append(DAY_NAMES[(int)(this._dayOfEpoch % 7L + 11L) % 7]);
        cb.append(", ");
        cb.append((this._dayOfMonth + 1L) / 10L);
        cb.append((this._dayOfMonth + 1L) % 10L);
        cb.append(" ");
        cb.append(MONTH_NAMES[(int)this._month]);
        cb.append(" ");
        cb.append(this._year);
        cb.append(" ");
        cb.append(this._timeOfDay / 36000000L % 10L);
        cb.append(this._timeOfDay / 3600000L % 10L);
        cb.append(":");
        cb.append(this._timeOfDay / 600000L % 6L);
        cb.append(this._timeOfDay / 60000L % 10L);
        cb.append(":");
        cb.append(this._timeOfDay / 10000L % 6L);
        cb.append(this._timeOfDay / 1000L % 10L);
        if (this._zoneName == null || this._zoneName.equals("UTC")) {
            cb.append(" GMT");
            return;
        }
        long offset = this._zoneOffset;
        if (offset < 0L) {
            cb.append(" -");
            offset = -offset;
        } else {
            cb.append(" +");
        }
        cb.append(offset / 36000000L % 10L);
        cb.append(offset / 3600000L % 10L);
        cb.append(offset / 600000L % 6L);
        cb.append(offset / 60000L % 10L);
        cb.append(" (");
        cb.append(this._zoneName);
        cb.append(")");
    }

    public void printDate(WriteStream os) throws IOException {
        os.print(DAY_NAMES[(int)(this._dayOfEpoch % 7L + 11L) % 7]);
        os.write(44);
        os.write(32);
        os.print((this._dayOfMonth + 1L) / 10L);
        os.print((this._dayOfMonth + 1L) % 10L);
        os.write(32);
        os.print(MONTH_NAMES[(int)this._month]);
        os.write(32);
        os.print(this._year);
        os.write(32);
        os.print(this._timeOfDay / 36000000L % 10L);
        os.print(this._timeOfDay / 3600000L % 10L);
        os.write(58);
        os.print(this._timeOfDay / 600000L % 6L);
        os.print(this._timeOfDay / 60000L % 10L);
        os.write(58);
        os.print(this._timeOfDay / 10000L % 6L);
        os.print(this._timeOfDay / 1000L % 10L);
        if (this._zoneName == null) {
            os.print(" GMT");
            return;
        }
        long offset = this._zoneOffset;
        if (offset < 0L) {
            os.write(32);
            os.write(45);
            offset = -offset;
        } else {
            os.write(32);
            os.write(43);
        }
        os.print(offset / 36000000L % 10L);
        os.print(offset / 3600000L % 10L);
        os.print(offset / 600000L % 6L);
        os.print(offset / 60000L % 10L);
        os.write(32);
        os.write(40);
        os.print(this._zoneName);
        os.write(41);
    }

    public String printISO8601() {
        CharBuffer cb = new CharBuffer();
        if (this._year > 0L) {
            cb.append(this._year / 1000L % 10L);
            cb.append(this._year / 100L % 10L);
            cb.append(this._year / 10L % 10L);
            cb.append(this._year % 10L);
            cb.append((this._month + 1L) / 10L % 10L);
            cb.append((this._month + 1L) % 10L);
            cb.append((this._dayOfMonth + 1L) / 10L % 10L);
            cb.append((this._dayOfMonth + 1L) % 10L);
        }
        if (this._timeOfDay != 0L || this._year <= 0L) {
            long time = this._timeOfDay / 1000L;
            long ms = this._timeOfDay % 1000L;
            cb.append("T");
            cb.append(time / 36000L % 10L);
            cb.append(time / 3600L % 10L);
            if (time % 3600L != 0L) {
                cb.append(time / 600L % 6L);
                cb.append(time / 60L % 10L);
                if (time % 60L != 0L) {
                    cb.append(time / 10L % 6L);
                    cb.append(time / 1L % 10L);
                }
            }
            if (ms != 0L) {
                cb.append('.');
                cb.append(ms / 100L % 10L);
                cb.append(ms / 10L % 10L);
                cb.append(ms % 10L);
            }
        }
        if (this._zoneName == null) {
            cb.append("Z");
            return cb.toString();
        }
        return cb.toString();
    }

    public String printISO8601Date() {
        CharBuffer cb = new CharBuffer();
        if (this._year > 0L) {
            cb.append(this._year / 1000L % 10L);
            cb.append(this._year / 100L % 10L);
            cb.append(this._year / 10L % 10L);
            cb.append(this._year % 10L);
            cb.append('-');
            cb.append((this._month + 1L) / 10L % 10L);
            cb.append((this._month + 1L) % 10L);
            cb.append('-');
            cb.append((this._dayOfMonth + 1L) / 10L % 10L);
            cb.append((this._dayOfMonth + 1L) % 10L);
        }
        return cb.toString();
    }

    public static synchronized String formatGMT(long gmtTime, String format) {
        _gmtDate.setGMTTime(gmtTime);
        return _gmtDate.format(CharBuffer.allocate(), format).close();
    }

    public static synchronized String formatGMT(long gmtTime) {
        _gmtDate.setGMTTime(gmtTime);
        return _gmtDate.printDate();
    }

    public static synchronized String formatLocal(long gmtTime, String format) {
        _localDate.setGMTTime(gmtTime);
        return _localDate.format(CharBuffer.allocate(), format).close();
    }

    public static synchronized String formatLocal(long gmtTime) {
        _localDate.setGMTTime(gmtTime);
        return _localDate.printDate();
    }

    public static synchronized CharBuffer formatLocal(CharBuffer cb, long gmtTime, String format) {
        _localDate.setGMTTime(gmtTime);
        return _localDate.format(cb, format);
    }

    public static synchronized String formatISO8601(long gmtTime) {
        if (_gmtDate == null) {
            _gmtDate = new QDate();
        }
        _gmtDate.setGMTTime(gmtTime);
        return _gmtDate.printISO8601();
    }

    public static QDate getGlobalDate() {
        return _localDate;
    }

    public String format(String format) {
        CharBuffer cb = new CharBuffer();
        return this.format(cb, format).close();
    }

    public CharBuffer format(CharBuffer cb, String format) {
        int length = format.length();
        block22: for (int i = 0; i < length; ++i) {
            char ch = format.charAt(i);
            if (ch != '%') {
                cb.append(ch);
                continue;
            }
            switch (format.charAt(++i)) {
                case 'a': {
                    cb.append(SHORT_WEEKDAY[this.getDayOfWeek() - 1]);
                    continue block22;
                }
                case 'A': {
                    cb.append(LONG_WEEKDAY[this.getDayOfWeek() - 1]);
                    continue block22;
                }
                case 'b': {
                    cb.append(SHORT_MONTH[(int)this._month]);
                    continue block22;
                }
                case 'B': {
                    cb.append(LONG_MONTH[(int)this._month]);
                    continue block22;
                }
                case 'c': {
                    cb.append(this.printLocaleDate());
                    continue block22;
                }
                case 'd': {
                    cb.append((this._dayOfMonth + 1L) / 10L);
                    cb.append((this._dayOfMonth + 1L) % 10L);
                    continue block22;
                }
                case 'H': {
                    int hour = (int)(this._timeOfDay / 3600000L) % 24;
                    cb.append(hour / 10);
                    cb.append(hour % 10);
                    continue block22;
                }
                case 'I': {
                    int hour = (int)(this._timeOfDay / 3600000L) % 12;
                    if (hour == 0) {
                        hour = 12;
                    }
                    cb.append(hour / 10);
                    cb.append(hour % 10);
                    continue block22;
                }
                case 'j': {
                    cb.append((this._dayOfYear + 1) / 100);
                    cb.append((this._dayOfYear + 1) / 10 % 10);
                    cb.append((this._dayOfYear + 1) % 10);
                    continue block22;
                }
                case 'm': {
                    cb.append((this._month + 1L) / 10L);
                    cb.append((this._month + 1L) % 10L);
                    continue block22;
                }
                case 'M': {
                    cb.append(this._timeOfDay / 600000L % 6L);
                    cb.append(this._timeOfDay / 60000L % 10L);
                    continue block22;
                }
                case 'p': {
                    int hour = (int)(this._timeOfDay / 3600000L) % 24;
                    if (hour < 12) {
                        cb.append("am");
                        continue block22;
                    }
                    cb.append("pm");
                    continue block22;
                }
                case 'S': {
                    cb.append(this._timeOfDay / 10000L % 6L);
                    cb.append(this._timeOfDay / 1000L % 10L);
                    continue block22;
                }
                case 's': {
                    cb.append(this._timeOfDay / 100L % 10L);
                    cb.append(this._timeOfDay / 10L % 10L);
                    cb.append(this._timeOfDay % 10L);
                    continue block22;
                }
                case 'W': {
                    int week = this.getWeek();
                    cb.append((week + 1) / 10);
                    cb.append((week + 1) % 10);
                    continue block22;
                }
                case 'w': {
                    cb.append(this.getDayOfWeek() - 1);
                    continue block22;
                }
                case 'y': {
                    cb.append(this._year / 10L % 10L);
                    cb.append(this._year % 10L);
                    continue block22;
                }
                case 'Y': {
                    cb.append(this._year / 1000L % 10L);
                    cb.append(this._year / 100L % 10L);
                    cb.append(this._year / 10L % 10L);
                    cb.append(this._year % 10L);
                    continue block22;
                }
                case 'Z': {
                    if (this._zoneName == null) {
                        cb.append("GMT");
                        continue block22;
                    }
                    cb.append(this._zoneName);
                    continue block22;
                }
                case 'z': {
                    long offset = this._zoneOffset;
                    if (offset < 0L) {
                        cb.append("-");
                        offset = -offset;
                    } else {
                        cb.append("+");
                    }
                    cb.append(offset / 36000000L % 10L);
                    cb.append(offset / 3600000L % 10L);
                    cb.append(offset / 600000L % 6L);
                    cb.append(offset / 60000L % 10L);
                    continue block22;
                }
                default: {
                    cb.append(format.charAt(i));
                }
            }
        }
        return cb;
    }

    public String printLocaleDate() {
        this._date.setTime(this._localTimeOfEpoch);
        if (this._dateFormat == null) {
            this._dateFormat = DateFormat.getInstance();
        }
        return this._dateFormat.format(this._date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long parseLocalDate(String string) throws Exception {
        long time = this.parseDate(string);
        QDate qDate = this;
        synchronized (qDate) {
            this.setLocalTime(time);
            return this.getGMTTime();
        }
    }

    public long parseDate(String string) throws Exception {
        try {
            int month;
            int i = this.skipWhitespace(string, 0);
            char ch = string.charAt(i);
            if (ch >= '0' && ch <= '9' || ch == 'T' && string.charAt(i + 1) >= '0' && string.charAt(i + 1) <= '9') {
                return this.parseISO8601Date(string, i);
            }
            CharBuffer cb = new CharBuffer();
            i = this.scan(string, 0, cb, true);
            if (cb.length() == 0 || !Character.isDigit(cb.charAt(0))) {
                i = this.scan(string, i, cb, true);
            }
            int dayOfMonth = this.parseInt(cb);
            i = this.scan(string, i, cb, true);
            String smonth = cb.toString();
            for (month = 0; month < 12 && !MONTH_NAMES[month].equalsIgnoreCase(smonth); ++month) {
            }
            if (month == 12) {
                throw new Exception();
            }
            i = this.scan(string, i, cb, true);
            int year = this.parseInt(cb);
            if (cb.length() < 3 && year < 50) {
                year += 2000;
            } else if (cb.length() < 3 && year < 100) {
                year += 1900;
            }
            i = this.scan(string, i, cb, false);
            long timeOfDay = this.parseInt(cb) * 3600000;
            i = this.scan(string, i, cb, false);
            timeOfDay += (long)(this.parseInt(cb) * 60000);
            i = this.scan(string, i, cb, false);
            timeOfDay += (long)(this.parseInt(cb) * 1000);
            if (year <= 1600) {
                --dayOfMonth;
            }
            long time = 86400000L * (this.yearToDayOfEpoch(year) + this.monthToDayOfYear(month, this.isLeapYear(year)) + (long)dayOfMonth - 1L) + timeOfDay;
            try {
                i = this.scan(string, i, cb, false);
                for (int j = 0; j < cb.length(); ++j) {
                    ch = cb.charAt(j);
                    if (ch != ';' && ch != ' ') continue;
                    cb.setLength(j);
                }
                ch = cb.charAt(0);
                if (ch == '-' || ch == '+' || ch >= '0' && ch <= '9') {
                    long zoneOffset = this.parseInt(cb);
                    zoneOffset = 60000L * (60L * (zoneOffset / 100L) + zoneOffset % 100L);
                    this.setGMTTime(time -= zoneOffset);
                } else if (cb.equalsIgnoreCase("gmt") || cb.equalsIgnoreCase("utc")) {
                    this.setGMTTime(time);
                } else {
                    this.setLocalTime(time);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            return this._localTimeOfEpoch - this._zoneOffset;
        }
        catch (Exception e) {
            return Long.MAX_VALUE;
        }
    }

    private long parseISO8601Date(String string, int pos) throws Exception {
        int length = string.length();
        int year = 0;
        char ch = string.charAt(pos);
        if ('0' <= ch && ch <= '9') {
            year = this.scanISOInt(string, pos, length, 4);
            pos += 4;
        }
        if (pos < length && string.charAt(pos) == '-') {
            ++pos;
        }
        int month = 0;
        if (pos < length && '0' <= (ch = string.charAt(pos)) && ch <= '9') {
            month = this.scanISOInt(string, pos, length, 2);
            --month;
            pos += 2;
        } else if (ch == 'W') {
            return Long.MAX_VALUE;
        }
        if (pos < length && string.charAt(pos) == '-') {
            ++pos;
        }
        int day = 0;
        if (pos < length && '0' <= (ch = string.charAt(pos)) && ch <= '9') {
            day = this.scanISOInt(string, pos, length, 2);
            --day;
            pos += 2;
        }
        int hour = 0;
        int minute = 0;
        int second = 0;
        if (pos < length && string.charAt(pos) == 'T') {
            if (++pos < length && '0' <= (ch = string.charAt(pos)) && ch <= '9') {
                hour = this.scanISOInt(string, pos, length, 2);
                pos += 2;
            }
            if (pos < length && string.charAt(pos) == ':') {
                ++pos;
            }
            if (pos < length && '0' <= (ch = string.charAt(pos)) && ch <= '9') {
                minute = this.scanISOInt(string, pos, length, 2);
                pos += 2;
            }
            if (pos < length && string.charAt(pos) == ':') {
                ++pos;
            }
            if (pos < length && '0' <= (ch = string.charAt(pos)) && ch <= '9') {
                second = this.scanISOInt(string, pos, length, 2);
                pos += 2;
            }
        }
        long timeOfDay = 1000 * (second + 60 * (minute + 60 * hour));
        if (year <= 1600) {
            --day;
        }
        long time = 86400000L * (this.yearToDayOfEpoch(year) + this.monthToDayOfYear(month, this.isLeapYear(year)) + (long)day) + timeOfDay;
        if (pos >= length) {
            this.setLocalTime(time);
            return this._localTimeOfEpoch;
        }
        if (string.charAt(pos) == 'Z') {
            ++pos;
        } else if (string.charAt(pos) == '-' || string.charAt(pos) == '+') {
            int sign = 1;
            if (string.charAt(pos) == '-') {
                sign = -1;
            }
            int tzHour = this.scanISOInt(string, ++pos, length, 2);
            int tzMinute = 0;
            if ((pos += 2) < length && string.charAt(pos) == ':') {
                ++pos;
            }
            if (pos < length && '0' <= (ch = string.charAt(pos)) && ch <= '9') {
                tzMinute = this.scanISOInt(string, pos, length, 2);
                pos += 2;
            }
            time += (long)(sign * 1000 * (60 * (tzMinute + 60 * tzHour)));
        } else {
            this.setLocalTime(time);
            return this._localTimeOfEpoch;
        }
        pos = this.skipWhitespace(string, pos);
        if (pos < length) {
            throw new Exception("extra junk at end of ISO date");
        }
        this.setGMTTime(time);
        return this._localTimeOfEpoch;
    }

    private long yearToDayOfEpoch(long year) {
        if (year > 0L) {
            return 365L * (year -= 1601L) + year / 4L - year / 100L + year / 400L - 134774L;
        }
        year = 2000L - year;
        return 10957L - (365L * year + year / 4L - year / 100L + year / 400L);
    }

    private long monthToDayOfYear(long month, boolean isLeapYear) {
        long day = 0L;
        for (int i = 0; (long)i < month && i < 12; ++i) {
            day += (long)DAYS_IN_MONTH[i];
            if (i != 1 || !isLeapYear) continue;
            ++day;
        }
        return day;
    }

    private boolean isLeapYear(long year) {
        return this._year % 4L == 0L && (this._year % 100L != 0L || this._year % 400L == 0L);
    }

    private int scanISOInt(String string, int pos, int length, int digits) throws Exception {
        int value = 0;
        for (int i = 0; i < digits; ++i) {
            char ch;
            if (pos >= length) {
                throw new Exception("expected ISO8601 digit");
            }
            if ('0' > (ch = string.charAt(pos++)) || ch > '9') {
                throw new Exception("expected ISO8601 digit");
            }
            value = 10 * value + ch - 48;
        }
        return value;
    }

    private int skipWhitespace(String string, int i) {
        char ch;
        while (i < string.length() && ((ch = string.charAt(i)) == ' ' || ch == '\t' || ch == '\n' || ch == '\r')) {
            ++i;
        }
        return i;
    }

    private int scan(String string, int i, CharBuffer cb, boolean dash) throws Exception {
        char ch;
        cb.setLength(0);
        while (i < string.length() && (Character.isWhitespace(ch = string.charAt(i)) || ch == ':' || dash && ch == '-')) {
            ++i;
        }
        while (!(i >= string.length() || Character.isWhitespace(ch = string.charAt(i)) || ch == ':' || dash && ch == '-')) {
            cb.append(ch);
            ++i;
        }
        if (cb.length() == 0) {
            throw new Exception();
        }
        return i;
    }

    private int parseInt(CharBuffer cb) throws Exception {
        int value = 0;
        int sign = 1;
        for (int i = 0; i < cb.length(); ++i) {
            char ch = cb.charAt(i);
            if (i == 0 && ch == '-') {
                sign = -1;
                continue;
            }
            if (i == 0 && ch == '+') continue;
            if (ch >= '0' && ch <= '9') {
                value = 10 * value + ch - 48;
                continue;
            }
            throw new Exception();
        }
        return sign * value;
    }

    public long setDate(long year, long month, long day) {
        year += (long)Math.floor((double)month / 12.0);
        month = (long)((double)month - 12.0 * Math.floor((double)month / 12.0));
        this._year = year;
        this._month = month;
        this._dayOfMonth = day - 1L;
        this.calculateJoin();
        this.calculateSplit(this._localTimeOfEpoch);
        return this._localTimeOfEpoch;
    }

    public long setTime(long hour, long minute, long second, long ms) {
        this._hour = hour;
        this._minute = minute;
        this._second = second;
        this._ms = ms;
        this.calculateJoin();
        this.calculateSplit(this._localTimeOfEpoch);
        return this._localTimeOfEpoch;
    }

    private void calculateSplit(long localTime) {
        this._localTimeOfEpoch = localTime;
        this._dayOfEpoch = this.divFloor(this._localTimeOfEpoch, 86400000L);
        this._timeOfDay = this._localTimeOfEpoch - 86400000L * this._dayOfEpoch;
        this.calculateYear();
        this.calculateMonth();
        this._hour = this._timeOfDay / 3600000L;
        this._minute = this._timeOfDay / 60000L % 60L;
        this._second = this._timeOfDay / 1000L % 60L;
        this._ms = this._timeOfDay % 1000L;
        if (this._timeZone == _gmtTimeZone) {
            this._isDaylightTime = false;
            this._zoneName = this._stdName;
        } else {
            this._zoneOffset = this._timeZone.getOffset(1, (int)this._year, (int)this._month, (int)this._dayOfMonth + 1, this.getDayOfWeek(), (int)this._timeOfDay);
            if (this._zoneOffset == (long)this._timeZone.getRawOffset()) {
                this._isDaylightTime = false;
                this._zoneName = this._stdName;
            } else {
                this._isDaylightTime = true;
                this._zoneName = this._dstName;
            }
        }
    }

    private void calculateYear() {
        long n1;
        long n4;
        long n400;
        long n100;
        long days = this._dayOfEpoch;
        days += 134774L;
        if ((n100 = this.divFloor(days -= (n400 = this.divFloor(days, 146097L)) * 146097L, 36524L)) == 4L) {
            n100 = 3L;
        }
        if ((n4 = this.divFloor(days -= n100 * 36524L, 1461L)) == 25L) {
            n4 = 24L;
        }
        if ((n1 = this.divFloor(days -= n4 * 1461L, 365L)) == 4L) {
            n1 = 3L;
        }
        this._year = 400L * n400 + 100L * n100 + 4L * n4 + n1 + 1601L;
        this._dayOfYear = (int)(days - 365L * n1);
        this._isLeapYear = this.isLeapYear(this._year);
    }

    public boolean isLeapYear() {
        return this._isLeapYear;
    }

    private void calculateMonth() {
        this._dayOfMonth = this._dayOfYear;
        this._month = 0L;
        while (this._month < 12L) {
            if (this._month == 1L && this._isLeapYear) {
                if (this._dayOfMonth < 29L) {
                    return;
                }
                this._dayOfMonth -= 29L;
            } else {
                if (this._dayOfMonth < (long)DAYS_IN_MONTH[(int)this._month]) {
                    return;
                }
                this._dayOfMonth -= (long)DAYS_IN_MONTH[(int)this._month];
            }
            ++this._month;
        }
    }

    private long calculateJoin() {
        this._year += this.divFloor(this._month, 12L);
        this._month -= 12L * this.divFloor(this._month, 12L);
        this._localTimeOfEpoch = 86400000L * (this.yearToDayOfEpoch(this._year) + this.monthToDayOfYear(this._month, this.isLeapYear(this._year)) + this._dayOfMonth);
        this._localTimeOfEpoch += this._ms + 1000L * (this._second + 60L * (this._minute + 60L * this._hour));
        return this._localTimeOfEpoch;
    }

    private long divFloor(long n, long d) {
        if (n > 0L) {
            return n / d;
        }
        return (n - d + 1L) / d;
    }

    public Object clone() {
        QDate newObj = new QDate(this._timeZone);
        newObj.calculateSplit(this._localTimeOfEpoch);
        return newObj;
    }

    public String toString() {
        return new CharBuffer().append("QDate[").append(this.printDate()).append("]").toString();
    }
}

