/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.CharBuffer;
import java.net.InetAddress;

public class InetNetwork {
    private long _address;
    private long _mask;
    private int _maskIndex;

    public InetNetwork(InetAddress inetAddress, int maskIndex) {
        byte[] bytes = inetAddress.getAddress();
        long address = 0L;
        for (int i = 0; i < bytes.length; ++i) {
            address = 256L * address + (long)(bytes[i] & 0xFF);
        }
        this._address = address;
        this._maskIndex = maskIndex;
        this._mask = -1L << 32 - maskIndex;
    }

    public InetNetwork(long address, int maskIndex) {
        this._address = address;
        this._maskIndex = maskIndex;
        this._mask = -1L << 32 - maskIndex;
    }

    public static InetNetwork create(String network) {
        int mask;
        if (network == null) {
            return null;
        }
        int i = 0;
        int len = network.length();
        long address = 0L;
        char ch = '\u0000';
        while (i < len && network.charAt(i) != '/') {
            int digit = 0;
            while (i < len && (ch = network.charAt(i)) >= '0' && ch <= '9') {
                digit = 10 * digit + ch - 48;
                ++i;
            }
            address = 256L * address + (long)digit;
            if (i >= len || ch != '.') continue;
            ++i;
        }
        if (i < len && network.charAt(i) == '/') {
            mask = 0;
            ++i;
            while (i < len && (ch = network.charAt(i)) >= '0' && ch <= '9') {
                mask = 10 * mask + ch - 48;
                ++i;
            }
        } else {
            mask = 32;
        }
        return new InetNetwork(address, mask);
    }

    public boolean isMatch(InetAddress inetAddress) {
        byte[] bytes = inetAddress.getAddress();
        long address = 0L;
        for (int i = 0; i < bytes.length; ++i) {
            address = 256L * address + (long)(bytes[i] & 0xFF);
        }
        return (this._address & this._mask) == (address & this._mask);
    }

    public boolean isMatch(byte[] bytes) {
        long address = 0L;
        for (int i = 0; i < bytes.length; ++i) {
            address = 256L * address + (long)(bytes[i] & 0xFF);
        }
        return (this._address & this._mask) == (address & this._mask);
    }

    public boolean isMatch(long address) {
        return (this._address & this._mask) == (address & this._mask);
    }

    public String toString() {
        CharBuffer cb = CharBuffer.allocate();
        for (int i = 0; i < 4; ++i) {
            if (i != 0) {
                cb.append('.');
            }
            cb.append(this._address >> (3 - i) * 8 & 0xFFL);
        }
        cb.append('/');
        cb.append(this._maskIndex);
        return cb.close();
    }
}

