/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

public class Crc64 {
    private static final long POLY64REV = -2882303761517117440L;
    private static final long[] CRC_TABLE = new long[256];

    public static long generate(String value) {
        int len = value.length();
        long crc = 0L;
        for (int i = 0; i < len; ++i) {
            crc = Crc64.next(crc, value.charAt(i));
        }
        return crc;
    }

    public static long generate(long crc, String value) {
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char ch = value.charAt(i);
            if (ch > '\u00ff') {
                crc = Crc64.next(crc, ch >> 8);
            }
            crc = Crc64.next(crc, ch);
        }
        return crc;
    }

    public static long generate(long crc, byte ch) {
        return crc >>> 8 ^ CRC_TABLE[((int)crc ^ ch) & 0xFF];
    }

    public static long next(long crc, int ch) {
        return crc >>> 8 ^ CRC_TABLE[((int)crc ^ ch) & 0xFF];
    }

    static {
        for (int i = 0; i < 256; ++i) {
            long v = i;
            for (int j = 0; j < 8; ++j) {
                boolean flag = (v & 1L) != 0L;
                long newV = v >>> 1;
                if ((v & 0x100000000L) != 0L) {
                    newV |= 0x100000000L;
                }
                if ((v & 1L) != 0L) {
                    newV ^= 0xD800000000000000L;
                }
                v = newV;
            }
            Crc64.CRC_TABLE[i] = v;
        }
    }
}

