/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.Version;
import com.caucho.java.WorkDir;
import com.caucho.util.Alarm;
import com.caucho.util.CharBuffer;
import com.caucho.util.CpuUsage;
import com.caucho.util.Crc64;
import com.caucho.vfs.CaseInsensitive;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class CauchoSystem {
    private static Logger log = Logger.getLogger("com.caucho.util.CauchoSystem");
    static char separatorChar = File.separatorChar;
    static char pathSeparatorChar = File.pathSeparatorChar;
    static String _localHost;
    static String _userDir;
    static String _userName;
    static Path _resinHome;
    static Path _serverRoot;
    static boolean _isTesting;
    static boolean _hasJni;
    private static int isUnix;
    private static String newline;
    private static long _version;
    private static String _user;
    private static String _group;
    private static String _classPath;
    static CpuUsage cpuUsage;
    private static Class _resin_compat_class_0;

    private CauchoSystem() {
    }

    public static boolean isTesting() {
        return _isTesting;
    }

    public static void setIsTesting(boolean testing) {
        _isTesting = testing;
    }

    public static void setResinHome(Path path) {
        _resinHome = path;
    }

    public static Path getResinHome() {
        int pathSep;
        if (_resinHome != null) {
            return _resinHome;
        }
        String path = System.getProperty("resin.home");
        if (path != null) {
            _resinHome = Vfs.lookupNative(path);
            return _resinHome;
        }
        String classpath = System.getProperty("java.class.path");
        int head = 0;
        char sep = CauchoSystem.getFileSeparatorChar();
        int n = pathSep = sep == '/' ? 58 : 59;
        while (path == null) {
            int p = classpath.indexOf(pathSep, head);
            String subpath = p < 0 ? classpath.substring(head) : classpath.substring(head, p);
            if (subpath.endsWith(new CharBuffer().append(sep).append("lib").append(sep).append("resin.jar").toString()) || subpath.equals(new CharBuffer().append("lib").append(sep).append("resin.jar").toString())) {
                path = subpath.substring(0, subpath.length() - new CharBuffer().append("lib").append(sep).append("resin.jar").toString().length());
            } else if (subpath.endsWith(new CharBuffer().append(sep).append("classes").toString()) || subpath.equals("classes")) {
                Path resinPath = Vfs.lookupNative(subpath);
                if ((resinPath = resinPath.lookup("com/caucho/util/CauchoSystem.class")).exists()) {
                    path = subpath.substring(0, subpath.length() - "classes".length());
                }
            }
            if (p < 0) break;
            head = p + 1;
        }
        if (path != null) {
            _resinHome = Vfs.lookupNative(path);
        }
        if (_resinHome != null && _resinHome.isDirectory()) {
            return _resinHome;
        }
        return Vfs.lookup();
    }

    public static Path getServerRoot() {
        if (_serverRoot != null) {
            return _serverRoot;
        }
        String path = System.getProperty("server.root");
        if (path != null) {
            _serverRoot = Vfs.lookupNative(path);
            return _serverRoot;
        }
        path = System.getProperty("resin.home");
        if (path != null) {
            _serverRoot = Vfs.lookupNative(path);
            return _serverRoot;
        }
        _serverRoot = CauchoSystem.getResinHome();
        return _serverRoot;
    }

    public static long getVersionId() {
        if (_version == 0L) {
            _version = Crc64.generate(Version.FULL_VERSION);
        }
        return _version;
    }

    public static String getResinConfig() {
        return new CharBuffer().append(CauchoSystem.getResinHome()).append("/conf/resin.conf").toString();
    }

    public static Path getWorkPath() {
        Path workPath = WorkDir.getLocalWorkDir();
        if (workPath != null) {
            return workPath;
        }
        String workDir = CauchoSystem.isWindows() ? "file:/c:/tmp/caucho" : "file:/tmp/caucho";
        Path path = workDir.charAt(0) == '/' ? Vfs.lookupNative(workDir) : CauchoSystem.getResinHome().lookupNative(workDir);
        try {
            path.mkdirs();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return path;
    }

    public static String getUserDir() {
        if (_userDir == null) {
            _userDir = System.getProperty("user.dir");
        }
        return _userDir;
    }

    public static char getFileSeparatorChar() {
        return separatorChar;
    }

    public static char getPathSeparatorChar() {
        return pathSeparatorChar;
    }

    public static String getNewlineString() {
        if (newline == null && (newline = System.getProperty("line.separator")) == null) {
            newline = "\n";
        }
        return newline;
    }

    public static boolean isWindows() {
        return separatorChar == '\\';
    }

    public static boolean isTest() {
        return Alarm.isTest();
    }

    public static boolean isCaseInsensitive() {
        return CaseInsensitive.isCaseInsensitive();
    }

    public static boolean isUnix() {
        if (isUnix >= 0) {
            return isUnix == 1;
        }
        isUnix = 0;
        if (separatorChar == '/' && Vfs.lookup("/bin/sh").canRead()) {
            isUnix = 1;
        }
        return isUnix == 1;
    }

    public static void setWindowsTest(boolean windows) {
        _isTesting = true;
        separatorChar = windows ? (char)92 : File.separatorChar;
    }

    public static String getLocalHost() {
        if (_localHost != null) {
            return _localHost;
        }
        try {
            InetAddress addr = InetAddress.getLocalHost();
            _localHost = addr.getHostName();
        }
        catch (Exception e) {
            _localHost = "127.0.0.1";
        }
        return _localHost;
    }

    public static String getUserName() {
        if (_userName == null) {
            _userName = System.getProperty("user.name");
        }
        return _userName;
    }

    public static CpuUsage getCpuUsage() {
        return CpuUsage.create();
    }

    public static Class loadClass(String name) throws ClassNotFoundException {
        return CauchoSystem.loadClass(name, false, null);
    }

    public static Class loadClass(String name, boolean init, ClassLoader loader) throws ClassNotFoundException {
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        if (loader == null || loader.equals(CauchoSystem._resin_compat_class_0().getClassLoader())) {
            return Class.forName(name);
        }
        return Class.forName(name, init, loader);
    }

    public static String getClassPath() {
        if (_classPath != null) {
            return _classPath;
        }
        String cp = System.getProperty("java.class.path");
        String boot = System.getProperty("sun.boot.class.path");
        if (boot != null && !boot.equals("")) {
            cp = new CharBuffer().append(cp).append(File.pathSeparatorChar).append(boot).toString();
        }
        Pattern pattern = Pattern.compile(new CharBuffer().append("").append(File.pathSeparatorChar).toString());
        String[] path = pattern.split(cp);
        CharBuffer cb = new CharBuffer();
        for (int i = 0; i < path.length; ++i) {
            Path subpath = Vfs.lookup(path[i]);
            if (!subpath.canRead() && !subpath.isDirectory()) continue;
            if (cb.length() > 0) {
                cb.append(File.pathSeparatorChar);
            }
            cb.append(path[i]);
        }
        _classPath = cb.toString();
        return _classPath;
    }

    public static int setUser(String user, String group) throws Exception {
        _user = user;
        _group = group;
        if (_hasJni && user != null) {
            return CauchoSystem.setUserNative(_user, _group);
        }
        return -1;
    }

    private static native int setUserNative(String var0, String var1) throws IOException;

    static {
        isUnix = -1;
        try {
            System.loadLibrary("resin");
            _hasJni = true;
        }
        catch (Throwable e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.util.CauchoSystem");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

