/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.sql.spy;

import com.caucho.log.Log;
import com.caucho.sql.SQLExceptionWrapper;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.logging.Logger;

public class SpyStatement
implements Statement {
    protected static final Logger log = Log.open(SpyStatement._resin_compat_class_0());
    protected static final L10N L = new L10N(SpyStatement._resin_compat_class_1());
    protected String _id;
    protected Connection _conn;
    protected Statement _stmt;
    private static Class _resin_compat_class_0;
    private static Class _resin_compat_class_1;

    SpyStatement(String id, Connection conn, Statement stmt) {
        this._id = id;
        this._conn = conn;
        this._stmt = stmt;
    }

    public Statement getStatement() {
        return this._stmt;
    }

    public void addBatch(String sql) throws SQLException {
        try {
            log.info(new CharBuffer().append(this._id).append(":addBatch(").append(sql).append(")").toString());
            this._stmt.addBatch(sql);
        }
        catch (Throwable e) {
            log.info(new CharBuffer().append(this._id).append(":exn-addBatch(").append(e).append(")").toString());
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void cancel() throws SQLException {
        try {
            log.info(new CharBuffer().append(this._id).append(":cancel()").toString());
            this._stmt.cancel();
        }
        catch (Throwable e) {
            log.info(new CharBuffer().append(this._id).append(":exn-cancel(").append(e).append(")").toString());
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void clearBatch() throws SQLException {
        try {
            log.info(new CharBuffer().append(this._id).append(":clearBatch()").toString());
            this._stmt.clearBatch();
        }
        catch (Throwable e) {
            log.info(new CharBuffer().append(this._id).append(":exn-clearBatch(").append(e).append(")").toString());
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void clearWarnings() throws SQLException {
        try {
            log.info(new CharBuffer().append(this._id).append(":clearWarnings()").toString());
            this._stmt.clearWarnings();
        }
        catch (Throwable e) {
            log.info(new CharBuffer().append(this._id).append(":exn-clearWarnings(").append(e).append(")").toString());
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void close() throws SQLException {
        try {
            log.info(new CharBuffer().append(this._id).append(":close()").toString());
            this._stmt.close();
        }
        catch (Throwable e) {
            log.info(new CharBuffer().append(this._id).append(":exn-close(").append(e).append(")").toString());
            throw SQLExceptionWrapper.create(e);
        }
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        try {
            log.info(new CharBuffer().append(this._id).append(":executeQuery(").append(sql).append(")").toString());
            ResultSet rs = this._stmt.executeQuery(sql);
            return rs;
        }
        catch (Throwable e) {
            log.info(new CharBuffer().append(this._id).append(":exn-executeQuery(").append(sql).append(") -> ").append(e).toString());
            throw SQLExceptionWrapper.create(e);
        }
    }

    public int executeUpdate(String sql) throws SQLException {
        try {
            int count = this._stmt.executeUpdate(sql);
            log.info(new CharBuffer().append(this._id).append(":executeUpdate(").append(sql).append(") -> ").append(count).toString());
            return count;
        }
        catch (Throwable e) {
            log.info(new CharBuffer().append(this._id).append(":exn-executeUpdate(").append(sql).append(") -> ").append(e).toString());
            throw SQLExceptionWrapper.create(e);
        }
    }

    public boolean execute(String sql) throws SQLException {
        try {
            boolean hasResult = this._stmt.execute(sql);
            log.info(new CharBuffer().append(this._id).append(":execute(").append(sql).append(") -> ").append(hasResult).toString());
            return hasResult;
        }
        catch (Throwable e) {
            log.info(new CharBuffer().append(this._id).append(":exn-execute(").append(sql).append(") -> ").append(e).toString());
            throw SQLExceptionWrapper.create(e);
        }
    }

    public int[] executeBatch() throws SQLException {
        try {
            int[] result = this._stmt.executeBatch();
            log.info(new CharBuffer().append(this._id).append(":executeBatch()").toString());
            return result;
        }
        catch (Throwable e) {
            log.info(new CharBuffer().append(this._id).append(":exn-executeBatch(").append(e).append(")").toString());
            throw SQLExceptionWrapper.create(e);
        }
    }

    public ResultSet getResultSet() throws SQLException {
        try {
            ResultSet result = this._stmt.getResultSet();
            log.info(new CharBuffer().append(this._id).append(":getResultSet() -> ").append(result).toString());
            return result;
        }
        catch (Throwable e) {
            log.info(new CharBuffer().append(this._id).append(":exn-getResultSet(").append(e).append(")").toString());
            throw SQLExceptionWrapper.create(e);
        }
    }

    public int getUpdateCount() throws SQLException {
        try {
            int updateCount = this._stmt.getUpdateCount();
            log.info(new CharBuffer().append(this._id).append(":getUpdateCount() -> ").append(updateCount).toString());
            return updateCount;
        }
        catch (Throwable e) {
            log.info(new CharBuffer().append(this._id).append(":exn-getUpdateCount(").append(e).append(")").toString());
            throw SQLExceptionWrapper.create(e);
        }
    }

    public Connection getConnection() throws SQLException {
        int updateCount = this._stmt.getUpdateCount();
        log.info(new CharBuffer().append(this._id).append(":getConnection()").toString());
        return this._conn;
    }

    public int getFetchDirection() throws SQLException {
        try {
            int result = this._stmt.getFetchDirection();
            log.info(new CharBuffer().append(this._id).append(":getFetchDirection() -> ").append(result).toString());
            return result;
        }
        catch (Throwable e) {
            log.info(new CharBuffer().append(this._id).append(":exn-getFetchDirection(").append(e).append(")").toString());
            throw SQLExceptionWrapper.create(e);
        }
    }

    public int getFetchSize() throws SQLException {
        try {
            int result = this._stmt.getFetchSize();
            log.info(new CharBuffer().append(this._id).append(":getFetchSize() -> ").append(result).toString());
            return result;
        }
        catch (Throwable e) {
            log.info(new CharBuffer().append(this._id).append(":exn-getFetchSize(").append(e).append(")").toString());
            throw SQLExceptionWrapper.create(e);
        }
    }

    public int getMaxFieldSize() throws SQLException {
        try {
            int result = this._stmt.getMaxFieldSize();
            log.info(new CharBuffer().append(this._id).append(":getMaxFieldSize() -> ").append(result).toString());
            return result;
        }
        catch (Throwable e) {
            log.info(new CharBuffer().append(this._id).append(":exn-getMaxFieldSize(").append(e).append(")").toString());
            throw SQLExceptionWrapper.create(e);
        }
    }

    public int getMaxRows() throws SQLException {
        try {
            int result = this._stmt.getMaxRows();
            log.info(new CharBuffer().append(this._id).append(":getMaxRows() -> ").append(result).toString());
            return result;
        }
        catch (Throwable e) {
            log.info(new CharBuffer().append(this._id).append(":exn-getMaxRows(").append(e).append(")").toString());
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setMaxRows(int max) throws SQLException {
        try {
            log.info(new CharBuffer().append(this._id).append(":setMaxRows(").append(max).append(")").toString());
            this._stmt.setMaxRows(max);
        }
        catch (Throwable e) {
            log.info(new CharBuffer().append(this._id).append(":exn-setMaxRows(").append(e).append(")").toString());
            throw SQLExceptionWrapper.create(e);
        }
    }

    public boolean getMoreResults() throws SQLException {
        try {
            boolean result = this._stmt.getMoreResults();
            log.info(new CharBuffer().append(this._id).append(":getMoreResults() -> ").append(result).toString());
            return result;
        }
        catch (Throwable e) {
            log.info(new CharBuffer().append(this._id).append(":exn-getMoreResults(").append(e).append(")").toString());
            throw SQLExceptionWrapper.create(e);
        }
    }

    public int getQueryTimeout() throws SQLException {
        try {
            int result = this._stmt.getQueryTimeout();
            log.info(new CharBuffer().append(this._id).append(":getQueryTimeout() -> ").append(result).toString());
            return result;
        }
        catch (Throwable e) {
            log.info(new CharBuffer().append(this._id).append(":exn-getQueryTimeout(").append(e).append(")").toString());
            throw SQLExceptionWrapper.create(e);
        }
    }

    public int getResultSetConcurrency() throws SQLException {
        try {
            int result = this._stmt.getResultSetConcurrency();
            log.info(new CharBuffer().append(this._id).append(":getResultSetConcurrency() -> ").append(result).toString());
            return result;
        }
        catch (Throwable e) {
            log.info(new CharBuffer().append(this._id).append(":exn-getResultSetConcurrency(").append(e).append(")").toString());
            throw SQLExceptionWrapper.create(e);
        }
    }

    public int getResultSetType() throws SQLException {
        try {
            int result = this._stmt.getResultSetType();
            log.info(new CharBuffer().append(this._id).append(":getResultSetType() -> ").append(result).toString());
            return result;
        }
        catch (Throwable e) {
            log.info(new CharBuffer().append(this._id).append(":exn-getResultSetType(").append(e).append(")").toString());
            throw SQLExceptionWrapper.create(e);
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        try {
            SQLWarning result = this._stmt.getWarnings();
            log.info(new CharBuffer().append(this._id).append(":getWarnings() -> ").append(result).toString());
            return result;
        }
        catch (Throwable e) {
            log.info(new CharBuffer().append(this._id).append(":exn-getWarnings(").append(e).append(")").toString());
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setCursorName(String name) throws SQLException {
        try {
            log.info(new CharBuffer().append(this._id).append(":setCursorName(").append(name).append(")").toString());
            this._stmt.setCursorName(name);
        }
        catch (Throwable e) {
            log.info(new CharBuffer().append(this._id).append(":exn-setCursorName(").append(e).append(")").toString());
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        try {
            log.info(new CharBuffer().append(this._id).append(":setEscapeProcessing(").append(enable).append(")").toString());
            this._stmt.setEscapeProcessing(enable);
        }
        catch (Throwable e) {
            log.info(new CharBuffer().append(this._id).append(":exn-setEscapeProcessing(").append(e).append(")").toString());
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setFetchDirection(int direction) throws SQLException {
        try {
            log.info(new CharBuffer().append(this._id).append(":setFetchDirection(").append(direction).append(")").toString());
            this._stmt.setFetchDirection(direction);
        }
        catch (Throwable e) {
            log.info(new CharBuffer().append(this._id).append(":exn-setFetchDirection(").append(e).append(")").toString());
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setFetchSize(int rows) throws SQLException {
        try {
            log.info(new CharBuffer().append(this._id).append(":setFetchSize(").append(rows).append(")").toString());
            this._stmt.setFetchSize(rows);
        }
        catch (Throwable e) {
            log.info(new CharBuffer().append(this._id).append(":exn-setFetchSize(").append(e).append(")").toString());
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setMaxFieldSize(int max) throws SQLException {
        try {
            log.info(new CharBuffer().append(this._id).append(":setMaxFieldSize(").append(max).append(")").toString());
            this._stmt.setMaxFieldSize(max);
        }
        catch (Throwable e) {
            log.info(new CharBuffer().append(this._id).append(":exn-setMaxFieldSize(").append(e).append(")").toString());
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        try {
            log.info(new CharBuffer().append(this._id).append(":setQueryTimeout(").append(seconds).append(")").toString());
            this._stmt.setQueryTimeout(seconds);
        }
        catch (Throwable e) {
            log.info(new CharBuffer().append(this._id).append(":exn-setQueryTimeout(").append(e).append(")").toString());
            throw SQLExceptionWrapper.create(e);
        }
    }

    public boolean getMoreResults(int count) throws SQLException {
        return this._stmt.getMoreResults(count);
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        return this._stmt.getGeneratedKeys();
    }

    public int executeUpdate(String query, int resultType) throws SQLException {
        return this._stmt.executeUpdate(query, resultType);
    }

    public int executeUpdate(String query, int[] columns) throws SQLException {
        return this._stmt.executeUpdate(query, columns);
    }

    public int executeUpdate(String query, String[] columns) throws SQLException {
        return this._stmt.executeUpdate(query, columns);
    }

    public boolean execute(String query, int resultType) throws SQLException {
        return this._stmt.execute(query, resultType);
    }

    public boolean execute(String query, int[] columns) throws SQLException {
        return this._stmt.execute(query, columns);
    }

    public boolean execute(String query, String[] columns) throws SQLException {
        return this._stmt.execute(query, columns);
    }

    public int getResultSetHoldability() throws SQLException {
        return this._stmt.getResultSetHoldability();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.sql.spy.SpyStatement");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_1() {
        try {
            Class<?> clazz = _resin_compat_class_1;
            if (clazz == null) {
                clazz = _resin_compat_class_1 = Class.forName("com.caucho.sql.spy.SpyConnection");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

