/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.sql.spy;

import com.caucho.log.Log;
import com.caucho.sql.spy.SpyConnection;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Logger;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

public class SpyPooledConnection
implements PooledConnection {
    protected static final Logger log = Log.open(SpyPooledConnection._resin_compat_class_0());
    protected static final L10N L = new L10N(SpyPooledConnection._resin_compat_class_0());
    protected int _id;
    private int _connCount;
    private PooledConnection _pconn;
    private static Class _resin_compat_class_0;

    public SpyPooledConnection(PooledConnection conn, int id) {
        this._pconn = conn;
        this._id = id;
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        this._pconn.addConnectionEventListener(listener);
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this._pconn.removeConnectionEventListener(listener);
    }

    public Connection getConnection() throws SQLException {
        try {
            Connection conn = this._pconn.getConnection();
            int connId = this._connCount++;
            log.info(new CharBuffer().append(this._id).append(":connect() -> ").append(connId).append(":").append(conn).toString());
            return new SpyConnection(conn, connId);
        }
        catch (SQLException e) {
            log.info(new CharBuffer().append(this._id).append(":exn-connect(").append(e).append(")").toString());
            throw e;
        }
    }

    public void close() throws SQLException {
        try {
            this._pconn.close();
            log.info(new CharBuffer().append(this._id).append(":close()").toString());
        }
        catch (SQLException e) {
            log.info(new CharBuffer().append(this._id).append(":exn-close(").append(e).append(")").toString());
            throw e;
        }
    }

    public String toString() {
        return new CharBuffer().append("SpyPooledConnection[id=").append(this._id).append(",conn=").append(this._pconn).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.sql.spy.SpyPooledConnection");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

