/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.sql.spy;

import com.caucho.log.Log;
import com.caucho.sql.spy.SpyConnection;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

public class SpyDriver
implements Driver {
    protected static final Logger log = Log.open(SpyDriver._resin_compat_class_0());
    protected static final L10N L = new L10N(SpyDriver._resin_compat_class_0());
    private static int _staticId;
    private int _id;
    private int _connCount;
    private Driver _driver;
    private static Class _resin_compat_class_0;

    public SpyDriver(Driver driver) {
        this._driver = driver;
        this._id = _staticId++;
    }

    public boolean acceptsURL(String url) throws SQLException {
        try {
            boolean result = this._driver.acceptsURL(url);
            log.info(new CharBuffer().append(this._id).append(":acceptsURL(").append(url).append(") -> ").append(result).toString());
            return result;
        }
        catch (SQLException e) {
            log.info(new CharBuffer().append(this._id).append(":exn-acceptURL(").append(e).append(")").toString());
            throw e;
        }
    }

    public Connection connect(String url, Properties info) throws SQLException {
        try {
            Connection conn = this._driver.connect(url, info);
            int connId = this._connCount++;
            log.info(new CharBuffer().append(this._id).append(":connect(").append(url).append(",info=").append(info).append(") -> ").append(connId).append(":").append(conn).toString());
            return new SpyConnection(conn, connId);
        }
        catch (SQLException e) {
            log.info(new CharBuffer().append(this._id).append(":exn-connect(").append(e).append(")").toString());
            throw e;
        }
    }

    public int getMajorVersion() {
        int result = this._driver.getMajorVersion();
        log.info(new CharBuffer().append(this._id).append(":getMajorVersion() -> ").append(result).toString());
        return result;
    }

    public int getMinorVersion() {
        int result = this._driver.getMinorVersion();
        log.info(new CharBuffer().append(this._id).append(":getMinorVersion() -> ").append(result).toString());
        return result;
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        try {
            DriverPropertyInfo[] result = this._driver.getPropertyInfo(url, info);
            Hashtable<String, String> cleanInfo = new Hashtable<String, String>();
            if (info != null) {
                Iterator<Map.Entry<Object, Object>> i$ = info.entrySet().iterator();
                while (i$.hasNext()) {
                    Map.Entry<Object, Object> entry = i$.next();
                    cleanInfo.put((String)entry.getKey(), (String)entry.getValue());
                }
            }
            if (cleanInfo.get("password") != null) {
                cleanInfo.put("password", "****");
            }
            log.info(new CharBuffer().append(this._id).append(":getPropertyInfo(").append(url).append(") -> ").append(result).toString());
            return result;
        }
        catch (SQLException e) {
            log.info(new CharBuffer().append(this._id).append(":exn-getPropertyInfo(").append(e).append(")").toString());
            throw e;
        }
    }

    public boolean jdbcCompliant() {
        boolean result = this._driver.jdbcCompliant();
        log.info(new CharBuffer().append(this._id).append(":jdbcCompliant() -> ").append(result).toString());
        return result;
    }

    public String toString() {
        return new CharBuffer().append("SpyDriver[id=").append(this._id).append(",driver=").append(this._driver).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.sql.spy.SpyDriver");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

