/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.sql.spy;

import com.caucho.log.Log;
import com.caucho.sql.spy.SpyPreparedStatement;
import com.caucho.sql.spy.SpyStatement;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpyConnection
implements Connection {
    protected static final Logger log = Log.open(SpyConnection._resin_compat_class_0());
    protected static final Logger logXA = Logger.getLogger(new CharBuffer().append(SpyConnection._resin_compat_class_0().getName()).append(".XA").toString());
    protected static final L10N L = new L10N(SpyConnection._resin_compat_class_0());
    private int _id;
    private int _stmtCount;
    private Connection _conn;
    private static Class _resin_compat_class_0;

    public SpyConnection(Connection conn, int id) {
        this._conn = conn;
        this._id = id;
    }

    public Connection getConnection() {
        return this._conn;
    }

    @Override
    public String getCatalog() throws SQLException {
        try {
            String catalog = this._conn.getCatalog();
            log.info(new CharBuffer().append(this._id).append(":getCatalog() -> ").append(catalog).toString());
            return catalog;
        }
        catch (SQLException e) {
            log.info(new CharBuffer().append(this._id).append(":exn-getCatalog(").append(e).append(")").toString());
            throw e;
        }
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        try {
            log.info(new CharBuffer().append(this._id).append(":setCatalog(").append(catalog).append(")").toString());
            this._conn.setCatalog(catalog);
        }
        catch (SQLException e) {
            log.info(new CharBuffer().append(this._id).append(":exn-setCatalog(").append(e).append(")").toString());
            throw e;
        }
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        try {
            DatabaseMetaData metaData = this._conn.getMetaData();
            log.info(new CharBuffer().append(this._id).append(":getMetaData() -> ").append(metaData).toString());
            return metaData;
        }
        catch (SQLException e) {
            log.info(new CharBuffer().append(this._id).append(":exn-getMetaData(").append(e).append(")").toString());
            throw e;
        }
    }

    public Map getTypeMap() throws SQLException {
        try {
            Map<String, Class<?>> map = this._conn.getTypeMap();
            log.info(new CharBuffer().append(this._id).append(":getTypeMap() -> ").append(map).toString());
            return map;
        }
        catch (SQLException e) {
            log.info(new CharBuffer().append(this._id).append(":exn-getTypeMap(").append(e).append(")").toString());
            throw e;
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        try {
            log.info(new CharBuffer().append(this._id).append(":setTypeMap(").append(map).append(")").toString());
            this._conn.setTypeMap(map);
        }
        catch (SQLException e) {
            log.info(new CharBuffer().append(this._id).append(":exn-setTypeMap(").append(e).append(")").toString());
            throw e;
        }
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        try {
            String nativeSQL = this._conn.nativeSQL(sql);
            log.info(new CharBuffer().append(this._id).append(":nativeSQL() -> ").append(nativeSQL).toString());
            return nativeSQL;
        }
        catch (SQLException e) {
            log.info(new CharBuffer().append(this._id).append(":exn-nativeSQL(").append(e).append(")").toString());
            throw e;
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        try {
            int isolation = this._conn.getTransactionIsolation();
            log.info(new CharBuffer().append(this._id).append(":getTransactionIsolation() -> ").append(isolation).toString());
            return isolation;
        }
        catch (SQLException e) {
            log.info(new CharBuffer().append(this._id).append(":exn-getTransactionIsolation(").append(e).append(")").toString());
            throw e;
        }
    }

    @Override
    public void setTransactionIsolation(int isolation) throws SQLException {
        try {
            log.info(new CharBuffer().append(this._id).append(":setTransactionIsolation(").append(isolation).append(")").toString());
            this._conn.setTransactionIsolation(isolation);
        }
        catch (SQLException e) {
            log.info(new CharBuffer().append(this._id).append(":exn-setTransactionIsolation(").append(e).append(")").toString());
            throw e;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            SQLWarning warning = this._conn.getWarnings();
            log.info(new CharBuffer().append(this._id).append(":getWarnings() -> ").append(warning).toString());
            return warning;
        }
        catch (SQLException e) {
            log.info(new CharBuffer().append(this._id).append(":exn-getWarnings(").append(e).append(")").toString());
            throw e;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            log.info(new CharBuffer().append(this._id).append(":clearWarnings()").toString());
            this._conn.clearWarnings();
        }
        catch (SQLException e) {
            log.info(new CharBuffer().append(this._id).append(":exn-clearWarnings(").append(e).append(")").toString());
            throw e;
        }
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        try {
            log.info(new CharBuffer().append(this._id).append(":setReadOnly(").append(readOnly).append(")").toString());
            this._conn.setReadOnly(readOnly);
        }
        catch (SQLException e) {
            log.info(new CharBuffer().append(this._id).append(":exn-setReadOnly(").append(e).append(")").toString());
            throw e;
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        try {
            boolean isReadOnly = this._conn.isReadOnly();
            log.info(new CharBuffer().append(this._id).append("isReadOnly() -> ").append(isReadOnly).toString());
            return isReadOnly;
        }
        catch (SQLException e) {
            log.info(new CharBuffer().append(this._id).append(":exn-isReadOnly(").append(e).append(")").toString());
            throw e;
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        try {
            String stmtId = new CharBuffer().append(this._id).append(".").append(this._stmtCount++).toString();
            log.info(new CharBuffer().append(stmtId).append(":createStatement()").toString());
            Statement stmt = this._conn.createStatement();
            return new SpyStatement(stmtId, this, stmt);
        }
        catch (SQLException e) {
            log.info(new CharBuffer().append(this._id).append(":exn-createStatement(").append(e).append(")").toString());
            throw e;
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            String stmtId = new CharBuffer().append(this._id).append(".").append(this._stmtCount++).toString();
            log.info(new CharBuffer().append(stmtId).append(":createStatement(type=").append(resultSetType).append(",concurrency=").append(resultSetConcurrency).append(")").toString());
            Statement stmt = this._conn.createStatement(resultSetType, resultSetConcurrency);
            return new SpyStatement(stmtId, this, stmt);
        }
        catch (SQLException e) {
            log.info(new CharBuffer().append(this._id).append(":exn-createStatement(").append(e).append(")").toString());
            throw e;
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            String stmtId = new CharBuffer().append(this._id).append(".").append(this._stmtCount++).toString();
            log.info(new CharBuffer().append(stmtId).append(":createStatement(type=").append(resultSetType).append(",concurrency=").append(resultSetConcurrency).append(",holdability=").append(resultSetHoldability).append(")").toString());
            Statement stmt = this._conn.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
            return new SpyStatement(stmtId, this, stmt);
        }
        catch (SQLException e) {
            log.info(new CharBuffer().append(this._id).append(":exn-createStatement(").append(e).append(")").toString());
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        try {
            String stmtId = new CharBuffer().append(this._id).append(".").append(this._stmtCount++).toString();
            log.info(new CharBuffer().append(stmtId).append(":prepareStatement(").append(sql).append(")").toString());
            PreparedStatement stmt = this._conn.prepareStatement(sql);
            return new SpyPreparedStatement(stmtId, this, stmt, sql);
        }
        catch (SQLException e) {
            log.info(new CharBuffer().append(this._id).append(":exn-prepareStatement(").append(e).append(")").toString());
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType) throws SQLException {
        try {
            String stmtId = new CharBuffer().append(this._id).append(".").append(this._stmtCount++).toString();
            log.info(new CharBuffer().append(stmtId).append(":prepareStatement(").append(sql).append(",type=").append(resultSetType).append(")").toString());
            PreparedStatement stmt = this._conn.prepareStatement(sql, resultSetType);
            return new SpyPreparedStatement(stmtId, this, stmt, sql);
        }
        catch (SQLException e) {
            log.info(new CharBuffer().append(this._id).append(":exn-prepareStatement(").append(e).append(")").toString());
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            String stmtId = new CharBuffer().append(this._id).append(".").append(this._stmtCount++).toString();
            log.info(new CharBuffer().append(stmtId).append(":prepareStatement(").append(sql).append(",type=").append(resultSetType).append(",concurrency=").append(resultSetConcurrency).append(")").toString());
            PreparedStatement stmt = this._conn.prepareStatement(sql, resultSetType, resultSetConcurrency);
            return new SpyPreparedStatement(stmtId, this, stmt, sql);
        }
        catch (SQLException e) {
            log.info(new CharBuffer().append(this._id).append(":exn-prepareStatement(").append(e).append(")").toString());
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return null;
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        try {
            String stmtId = new CharBuffer().append(this._id).append(".").append(this._stmtCount++).toString();
            log.info(new CharBuffer().append(stmtId).append(":prepareCall(").append(sql).append(")").toString());
            CallableStatement stmt = this._conn.prepareCall(sql);
            return stmt;
        }
        catch (SQLException e) {
            log.info(new CharBuffer().append(this._id).append(":exn-prepareCall(").append(e).append(")").toString());
            throw e;
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            String stmtId = new CharBuffer().append(this._id).append(".").append(this._stmtCount++).toString();
            log.info(new CharBuffer().append(stmtId).append(":prepareCall(").append(sql).append(",type=").append(resultSetType).append(",concurrency=").append(resultSetConcurrency).append(")").toString());
            CallableStatement stmt = this._conn.prepareCall(sql);
            return stmt;
        }
        catch (SQLException e) {
            log.info(new CharBuffer().append(this._id).append(":exn-prepareCall(").append(e).append(")").toString());
            throw e;
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return null;
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        try {
            boolean autoCommit = this._conn.getAutoCommit();
            log.info(new CharBuffer().append(this._id).append(":getAutoCommit() -> ").append(autoCommit).toString());
            return autoCommit;
        }
        catch (SQLException e) {
            log.info(new CharBuffer().append(this._id).append(":exn-getAutoCommit(").append(e).append(")").toString());
            throw e;
        }
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        try {
            logXA.info(new CharBuffer().append(this._id).append(":setAutoCommit(").append(autoCommit).append(")").toString());
            this._conn.setAutoCommit(autoCommit);
        }
        catch (SQLException e) {
            logXA.info(new CharBuffer().append(this._id).append(":exn-setAutoCommit(").append(e).append(")").toString());
            throw e;
        }
    }

    @Override
    public void commit() throws SQLException {
        try {
            logXA.info(new CharBuffer().append(this._id).append(":commit()").toString());
            this._conn.commit();
        }
        catch (SQLException e) {
            logXA.info(new CharBuffer().append(this._id).append(":exn-commit(").append(e).append(")").toString());
            throw e;
        }
    }

    @Override
    public void rollback() throws SQLException {
        try {
            logXA.info(new CharBuffer().append(this._id).append(":rollback()").toString());
            this._conn.rollback();
        }
        catch (SQLException e) {
            logXA.info(new CharBuffer().append(this._id).append(":exn-rollback(").append(e).append(")").toString());
            throw e;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        try {
            boolean isClosed = this._conn.isClosed();
            log.info(new CharBuffer().append(this._id).append(":isClosed() -> ").append(isClosed).toString());
            return isClosed;
        }
        catch (SQLException e) {
            log.info(new CharBuffer().append(this._id).append(":exn-isClosed(").append(e).append(")").toString());
            throw e;
        }
    }

    @Override
    public void close() throws SQLException {
        log.info(new CharBuffer().append(this._id).append(":close()").toString());
        try {
            this._conn.close();
        }
        catch (SQLException e) {
            log.info(new CharBuffer().append(this._id).append(":exn-close(").append(e).append(")").toString());
            throw e;
        }
    }

    @Override
    public void setHoldability(int hold) throws SQLException {
        this._conn.setHoldability(hold);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this._conn.getHoldability();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this._conn.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return this._conn.setSavepoint(name);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this._conn.releaseSavepoint(savepoint);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this._conn.rollback(savepoint);
    }

    public String toString() {
        return new CharBuffer().append("SpyConnection[id=").append(this._id).append(",conn=").append(this._conn).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.sql.spy.SpyConnection");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

