/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.sql;

import com.caucho.config.BuilderProgram;
import com.caucho.config.BuilderProgramContainer;
import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.config.StringAttributeProgram;
import com.caucho.config.types.InitParam;
import com.caucho.log.Log;
import com.caucho.naming.Jndi;
import com.caucho.sql.DBPoolImpl;
import com.caucho.sql.SQLExceptionWrapper;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import javax.sql.XADataSource;

public class DriverConfig {
    protected static final Logger log = Log.open(DriverConfig._resin_compat_class_3());
    private static final L10N L = new L10N(DriverConfig._resin_compat_class_3());
    private static final int TYPE_UNKNOWN = 0;
    private static final int TYPE_DRIVER = 1;
    private static final int TYPE_POOL = 2;
    private static final int TYPE_XA = 3;
    private static final String URL_PREFIX = "jdbc:caucho:";
    public static final String PROPERTY_USER = "user";
    public static final String PROPERTY_PASSWORD = "password";
    private DBPoolImpl _dbPool;
    private Class _driverClass;
    private String _driverURL;
    private String _user;
    private String _password;
    private Properties _info;
    private BuilderProgramContainer _init = new BuilderProgramContainer();
    private int _driverType;
    private Object _driverObject;
    private ConnectionPoolDataSource _poolDataSource;
    private XADataSource _xaDataSource;
    private Driver _driver;
    private boolean _isInit;
    private boolean _isStarted;
    private static Class _resin_compat_class_0;
    private static Class _resin_compat_class_1;
    private static Class _resin_compat_class_2;
    private static Class _resin_compat_class_3;

    public DriverConfig(DBPoolImpl pool) {
        this._dbPool = pool;
        this._info = new Properties();
    }

    public DBPoolImpl getDBPool() {
        return this._dbPool;
    }

    public void setDriverType(String type) throws ConfigException {
        if ("ConnectionPoolDataSource".equals(type)) {
            this._driverType = 2;
        } else if ("XADataSource".equals(type)) {
            this._driverType = 3;
        } else if ("Driver".equals(type)) {
            this._driverType = 1;
        } else {
            throw new ConfigException(L.l("'{0}' is an unknown driver type. Valid types are 'ConnectionPoolDataSource', 'XADataSource' and 'Driver'"));
        }
    }

    public void setDataSource(Object dataSource) throws ConfigException {
        if (dataSource instanceof String) {
            dataSource = Jndi.lookup((String)dataSource);
        }
        if (this._driverType == 3) {
            this._xaDataSource = (XADataSource)dataSource;
        } else if (this._driverType == 2) {
            this._poolDataSource = (ConnectionPoolDataSource)dataSource;
        } else if (dataSource instanceof XADataSource) {
            this._xaDataSource = (XADataSource)dataSource;
        } else if (dataSource instanceof ConnectionPoolDataSource) {
            this._poolDataSource = (ConnectionPoolDataSource)dataSource;
        } else {
            throw new ConfigException(L.l("data-source `{0}' is of type `{1}' which does not implement XADataSource or ConnectionPoolDataSource.", dataSource, dataSource.getClass().getName()));
        }
    }

    public Class getDriverClass() {
        return this._driverClass;
    }

    public void setType(Class driverClass) throws ConfigException {
        this._driverClass = driverClass;
        if (!(DriverConfig._resin_compat_class_0().isAssignableFrom(driverClass) || DriverConfig._resin_compat_class_1().isAssignableFrom(driverClass) || DriverConfig._resin_compat_class_2().isAssignableFrom(driverClass))) {
            throw new ConfigException(L.l("`{0}' is not a valid database type.", driverClass.getName()));
        }
        Config.checkCanInstantiate(driverClass);
    }

    public String getURL() {
        return this._driverURL;
    }

    public void setURL(String url) {
        this._driverURL = url;
    }

    public void addBuilderProgram(BuilderProgram program) {
        this._init.addProgram(program);
    }

    public String getUser() {
        return this._user;
    }

    public void setUser(String user) {
        this._user = user;
    }

    public String getPassword() {
        return this._password;
    }

    public void setPassword(String password) {
        this._password = password;
    }

    public void setInitParam(InitParam initParam) {
        HashMap<String, String> paramMap = initParam.getParameters();
        Iterator<String> iter = paramMap.keySet().iterator();
        while (iter.hasNext()) {
            String key = iter.next();
            this._info.setProperty(key, paramMap.get(key));
        }
    }

    public void setInitParam(String key, String value) {
        this._info.setProperty(key, value);
    }

    public Properties getInfo() {
        return this._info;
    }

    public Driver getDriver() throws SQLException {
        Object obj = this.getDriverObject();
        if (obj instanceof Driver) {
            return (Driver)obj;
        }
        return null;
    }

    public void setDriver(Driver driver) throws SQLException {
        this._driver = driver;
        this._driverObject = driver;
    }

    public ConnectionPoolDataSource getPoolDataSource() throws SQLException {
        return this._poolDataSource;
    }

    public void setPoolDataSource(ConnectionPoolDataSource pDataSource) throws SQLException {
        this._poolDataSource = pDataSource;
        this._driverObject = this._poolDataSource;
    }

    public XADataSource getXADataSource() {
        return this._xaDataSource;
    }

    public void setXADataSource(XADataSource xaDataSource) throws SQLException {
        this._xaDataSource = xaDataSource;
        this._driverObject = this._xaDataSource;
    }

    public boolean isXATransaction() {
        return this._xaDataSource != null && this._dbPool.isXA();
    }

    public boolean isLocalTransaction() {
        return this._dbPool.isXA();
    }

    synchronized void initDataSource(boolean isTransactional, boolean isSpy) throws SQLException {
        if (this._isStarted) {
            return;
        }
        this._isStarted = true;
        if (this._xaDataSource == null && this._poolDataSource == null) {
            this.initDriver();
            Object driverObject = this.getDriverObject();
            if (driverObject == null) {
                throw new SQLExceptionWrapper(L.l("driver `{0}' has not been configured for pool {1}.  <database> needs a <driver type='...'>.", (Object)this._driverClass, this.getDBPool().getName()));
            }
            if (this._driverType == 3) {
                this._xaDataSource = (XADataSource)this._driverObject;
            } else if (this._driverType == 2) {
                this._poolDataSource = (ConnectionPoolDataSource)this._driverObject;
            } else if (this._driverType == 1) {
                this._driver = (Driver)this._driverObject;
            } else if (driverObject instanceof XADataSource) {
                this._xaDataSource = (XADataSource)this._driverObject;
            } else if (this._driverObject instanceof ConnectionPoolDataSource) {
                this._poolDataSource = (ConnectionPoolDataSource)this._driverObject;
            } else if (this._driverObject instanceof Driver) {
                this._driver = (Driver)this._driverObject;
            } else {
                throw new SQLExceptionWrapper(L.l("driver `{0}' has not been configured for pool {1}.  <database> needs a <driver type='...'>.", (Object)this._driverClass, this.getDBPool().getName()));
            }
        }
    }

    synchronized Object getDriverObject() throws SQLException {
        if (this._driverObject != null) {
            return this._driverObject;
        }
        if (this._driverClass == null) {
            return null;
        }
        if (log.isLoggable(Level.CONFIG)) {
            log.config(new CharBuffer().append("loading driver: ").append(this._driverClass.getName()).toString());
        }
        try {
            this._driverObject = this._driverClass.newInstance();
        }
        catch (Exception e) {
            throw new SQLExceptionWrapper(e);
        }
        return this._driverObject;
    }

    PooledConnection createPooledConnection(String user, String password) throws SQLException {
        PooledConnection conn = null;
        if (this._xaDataSource != null) {
            conn = user == null && password == null ? this._xaDataSource.getXAConnection() : this._xaDataSource.getXAConnection(user, password);
        } else if (this._poolDataSource != null) {
            conn = user == null && password == null ? this._poolDataSource.getPooledConnection() : this._poolDataSource.getPooledConnection(user, password);
        }
        return conn;
    }

    Connection createDriverConnection(String user, String password) throws SQLException {
        if (this._xaDataSource != null || this._poolDataSource != null) {
            throw new IllegalStateException();
        }
        if (this._driver == null) {
            throw new IllegalStateException();
        }
        Driver driver = this._driver;
        String url = this.getURL();
        if (url == null) {
            throw new SQLException(L.l("can't create connection with null url"));
        }
        Properties properties = this.getInfo();
        if (user != null) {
            properties.put(PROPERTY_USER, user);
        } else {
            properties.put(PROPERTY_USER, "");
        }
        if (password != null) {
            properties.put(PROPERTY_PASSWORD, password);
        } else {
            properties.put(PROPERTY_PASSWORD, "");
        }
        Connection conn = driver != null ? driver.connect(url, properties) : DriverManager.getConnection(url, properties);
        return conn;
    }

    public void initDriver() throws SQLException {
        Object driverObject;
        block17: {
            StringAttributeProgram program;
            block16: {
                if (this._isInit) {
                    return;
                }
                this._isInit = true;
                driverObject = this.getDriverObject();
                if (driverObject == null) {
                    if (this._xaDataSource != null || this._poolDataSource != null) {
                        return;
                    }
                    throw new SQLExceptionWrapper(L.l("driver `{0}' has not been configured for pool {1}.  <database> needs either a <data-source> or a <type>.", (Object)this._driverClass, this.getDBPool().getName()));
                }
                try {
                    if (this._driverURL != null) {
                        program = new StringAttributeProgram("url", this._driverURL);
                        program.configure(driverObject);
                    }
                }
                catch (Throwable e) {
                    if (driverObject instanceof Driver) {
                        log.log(Level.FINEST, e.toString(), e);
                    }
                    throw new SQLExceptionWrapper(e);
                }
                try {
                    if (this._user != null) {
                        program = new StringAttributeProgram(PROPERTY_USER, this._user);
                        program.configure(driverObject);
                    }
                }
                catch (Throwable e) {
                    log.log(Level.FINEST, e.toString(), e);
                    if (driverObject instanceof Driver) break block16;
                    throw new SQLExceptionWrapper(e);
                }
            }
            try {
                if (this._password != null) {
                    program = new StringAttributeProgram(PROPERTY_PASSWORD, this._password);
                    program.configure(driverObject);
                }
            }
            catch (Throwable e) {
                log.log(Level.FINEST, e.toString(), e);
                if (driverObject instanceof Driver) break block17;
                throw new SQLExceptionWrapper(e);
            }
        }
        try {
            if (this._init != null) {
                this._init.configure(driverObject);
                this._init = null;
            }
            Config.init(driverObject);
        }
        catch (Throwable e) {
            log.log(Level.FINE, e.toString(), e);
            throw new SQLExceptionWrapper(e);
        }
    }

    public String toString() {
        return new CharBuffer().append("Driver[").append(this._driverURL).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("java.sql.Driver");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_1() {
        try {
            Class<?> clazz = _resin_compat_class_1;
            if (clazz == null) {
                clazz = _resin_compat_class_1 = Class.forName("javax.sql.XADataSource");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_2() {
        try {
            Class<?> clazz = _resin_compat_class_2;
            if (clazz == null) {
                clazz = _resin_compat_class_2 = Class.forName("javax.sql.ConnectionPoolDataSource");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_3() {
        try {
            Class<?> clazz = _resin_compat_class_3;
            if (clazz == null) {
                clazz = _resin_compat_class_3 = Class.forName("com.caucho.sql.DriverConfig");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

