/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.sql;

import com.caucho.config.ConfigException;
import com.caucho.config.types.InitParam;
import com.caucho.config.types.Period;
import com.caucho.jca.ConnectionPool;
import com.caucho.jca.ResourceManagerImpl;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.log.Log;
import com.caucho.naming.Jndi;
import com.caucho.sql.ConnectionConfig;
import com.caucho.sql.DBPoolImpl;
import com.caucho.sql.DataSourceImpl;
import com.caucho.sql.DriverConfig;
import com.caucho.transaction.TransactionManagerImpl;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.logging.Logger;
import javax.resource.spi.ManagedConnectionFactory;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;

public class DBPool
implements DataSource {
    protected static final Logger log = Log.open(DBPool._resin_compat_class_0());
    private static final L10N L = new L10N(DBPool._resin_compat_class_0());
    private EnvironmentLocal<DBPoolImpl> _localPoolImpl;
    private EnvironmentLocal<DataSourceImpl> _localDataSourceImpl;
    private String _var;
    private String _jndiName;
    private ResourceManagerImpl _resourceManager;
    private ConnectionPool _connectionPool;
    private DBPoolImpl _poolImpl = new DBPoolImpl();
    private DataSourceImpl _dataSource;
    private static Class _resin_compat_class_0;

    public DBPool() {
        this._resourceManager = ResourceManagerImpl.createLocalManager();
        this._connectionPool = this._resourceManager.createConnectionPool();
    }

    public String getJndiName() {
        return this._jndiName;
    }

    public void setJndiName(String name) {
        this._jndiName = name;
        if (this._var == null) {
            this.getPool().setName(name);
        }
    }

    public void setVar(String var) {
        this._var = var;
        this.getPool().setName(var);
    }

    public String getName() {
        if (this._var != null) {
            return this._var;
        }
        return this.getJndiName();
    }

    public DriverConfig createDriver() throws ConfigException {
        return this.getPool().createDriver();
    }

    public DriverConfig createBackupDriver() throws ConfigException {
        return this.getPool().createBackupDriver();
    }

    public void setInitParam(InitParam init) {
        this.getPool().setInitParam(init);
    }

    public void setJDBCDriver(Driver jdbcDriver) throws SQLException {
        this.getPool().setJDBCDriver(jdbcDriver);
    }

    public ConnectionConfig createConnection() throws ConfigException {
        return this.getPool().createConnection();
    }

    public void setPoolDataSource(ConnectionPoolDataSource poolDataSource) throws SQLException {
        this.getPool().setPoolDataSource(poolDataSource);
    }

    public void setXADataSource(XADataSource xaDataSource) throws SQLException {
        this.getPool().setXADataSource(xaDataSource);
    }

    public void setURL(String url) throws ConfigException {
        this.getPool().setURL(url);
    }

    public String getUser() {
        return this.getPool().getUser();
    }

    public void setUser(String user) {
        this.getPool().setUser(user);
    }

    public String getPassword() {
        return this.getPool().getPassword();
    }

    public void setPassword(String password) {
        this.getPool().setPassword(password);
    }

    public int getMaxConnections() {
        return this._connectionPool.getMaxConnections();
    }

    public void setMaxConnections(int maxConnections) throws ConfigException {
        this._connectionPool.setMaxConnections(maxConnections);
    }

    public int getTotalConnections() {
        return this._connectionPool.getConnectionCount();
    }

    public void setConnectionWaitTime(Period waitTime) {
        this._connectionPool.setConnectionWaitTime(waitTime);
    }

    public long getConnectionWaitTime() {
        return this._connectionPool.getConnectionWaitTime();
    }

    public void setMaxOverflowConnections(int maxOverflowConnections) {
        this._connectionPool.setMaxOverflowConnections(maxOverflowConnections);
    }

    public void setSaveAllocationStackTrace(boolean save) {
        this._connectionPool.setSaveAllocationStackTrace(save);
    }

    public int getMaxOverflowConnections() {
        return this._connectionPool.getMaxOverflowConnections();
    }

    public int getActiveConnections() {
        return this._connectionPool.getActiveConnectionCount();
    }

    public long getMaxIdleTime() {
        return this._connectionPool.getMaxIdleTime();
    }

    public void setMaxIdleTime(Period idleTime) {
        this._connectionPool.setMaxIdleTime(idleTime.getPeriod());
    }

    public long getMaxPoolTime() {
        return this._connectionPool.getMaxPoolTime();
    }

    public void setMaxPoolTime(Period maxPoolTime) {
        this._connectionPool.setMaxPoolTime(maxPoolTime.getPeriod());
    }

    public long getMaxActiveTime() {
        return this._connectionPool.getMaxActiveTime();
    }

    public void setMaxActiveTime(Period maxActiveTime) {
        this._connectionPool.setMaxActiveTime(maxActiveTime.getPeriod());
    }

    public String getPingTable() {
        return this.getPool().getPingTable();
    }

    public void setPingTable(String pingTable) {
        this.getPool().setPingTable(pingTable);
    }

    public boolean getPingOnReuse() {
        return this.getPool().getPingOnReuse();
    }

    public void setPingOnReuse(boolean pingOnReuse) {
        this.getPool().setPingOnReuse(pingOnReuse);
    }

    public boolean getPingOnIdle() {
        return this.getPool().getPingOnIdle();
    }

    public void setPingOnIdle(boolean pingOnIdle) {
        this.getPool().setPingOnIdle(pingOnIdle);
    }

    public void setPing(boolean ping) {
        this.getPool().setPing(ping);
    }

    public void setPingInterval(Period interval) {
        this.getPool().setPingInterval(interval);
    }

    public long getPingInterval() {
        return this.getPool().getPingInterval();
    }

    public int getPreparedStatementCacheSize() {
        return this.getPool().getPreparedStatementCacheSize();
    }

    public void setPreparedStatementCacheSize(int size) {
        this.getPool().setPreparedStatementCacheSize(size);
    }

    public void setTransactionManager(TransactionManagerImpl tm) {
        this.getPool().setTransactionManager(tm);
    }

    public void setTransactionTimeout(Period period) {
        this.getPool().setTransactionTimeout(period);
    }

    public boolean isXA() {
        return this.getPool().isXA();
    }

    public void setXA(boolean isTransactional) {
        this.getPool().setXA(isTransactional);
    }

    public void setXAForbidSameRM(boolean isXAForbidSameRM) {
        this.getPool().setXAForbidSameRM(isXAForbidSameRM);
    }

    public void setSpy(boolean isSpy) throws IOException {
        this.getPool().setSpy(isSpy);
    }

    public void init() throws Exception {
        this._localPoolImpl = new EnvironmentLocal(new CharBuffer().append("caucho.db-pool.").append(this.getName()).toString());
        this._localPoolImpl.set(this._poolImpl);
        this._poolImpl.init();
        this._connectionPool.setName(this.getName());
        this._connectionPool.setShareable(true);
        this._connectionPool.setXATransaction(this._poolImpl.isXATransaction());
        this._connectionPool.setLocalTransaction(this._poolImpl.isLocalTransaction());
        ManagedConnectionFactory mcf = this._poolImpl.getManagedConnectionFactory();
        this._dataSource = (DataSourceImpl)this._connectionPool.init(mcf);
        this._connectionPool.start();
        this._localDataSourceImpl = new EnvironmentLocal(new CharBuffer().append("caucho.data-source.").append(this.getName()).toString());
        this._localDataSourceImpl.set(this._dataSource);
        if (this._jndiName != null) {
            String name = this._jndiName;
            if (!name.startsWith("java:")) {
                name = new CharBuffer().append("java:comp/env/").append(name).toString();
            }
            log.config(new CharBuffer().append("database ").append(name).append(" starting").toString());
            Jndi.bindDeep(name, this);
        }
    }

    public Connection getConnection() throws SQLException {
        return this.getDataSource().getConnection();
    }

    public Connection getConnection(String user, String password) throws SQLException {
        return this.getDataSource().getConnection(user, password);
    }

    public int getLoginTimeout() throws SQLException {
        return this.getDataSource().getLoginTimeout();
    }

    public void setLoginTimeout(int timeout) throws SQLException {
        this.getDataSource().setLoginTimeout(timeout);
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.getDataSource().getLogWriter();
    }

    public void setLogWriter(PrintWriter log) throws SQLException {
        this.getDataSource().setLogWriter(log);
    }

    private DBPoolImpl getPool() {
        if (this._poolImpl == null || this._poolImpl.isClosed()) {
            this._poolImpl = this._localPoolImpl.get();
            if (this._poolImpl == null) {
                throw new IllegalStateException(L.l("DBPool `{0}' no longer exists.", this.getName()));
            }
        }
        return this._poolImpl;
    }

    private DataSourceImpl getDataSource() {
        if (this._dataSource == null || this._dataSource.isClosed()) {
            this._dataSource = this._localDataSourceImpl.get();
            if (this._dataSource == null) {
                throw new IllegalStateException(L.l("DBPool `{0}' no longer exists.", this.getName()));
            }
        }
        return this._dataSource;
    }

    public String toString() {
        return new CharBuffer().append("DBPool[").append(this.getName()).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.sql.DBPool");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

