/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.sql;

import com.caucho.config.ConfigException;
import com.caucho.util.L10N;

public class ConnectionConfig {
    private static final L10N L = new L10N(ConnectionConfig._resin_compat_class_0());
    private int _isolation = -1;
    private boolean _readOnly;
    private String _catalog;
    private static Class _resin_compat_class_0;

    public void setTransactionIsolation(String name) throws ConfigException {
        if ("none".equals(name)) {
            this._isolation = 0;
        } else if ("read-committed".equals(name)) {
            this._isolation = 2;
        } else if ("read-uncommitted".equals(name)) {
            this._isolation = 1;
        } else if ("repeatable-read".equals(name)) {
            this._isolation = 4;
        } else if ("serializable".equals(name)) {
            this._isolation = 8;
        } else {
            throw new ConfigException(L.l("'{0}' is an unknown transaction isolation.", name));
        }
    }

    public int getTransactionIsolation() {
        return this._isolation;
    }

    public void setReadOnly(boolean isReadOnly) {
        this._readOnly = isReadOnly;
    }

    public boolean isReadOnly() {
        return this._readOnly;
    }

    public void setCatalog(String catalog) {
        this._catalog = catalog;
    }

    public String getCatalog() {
        return this._catalog;
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.sql.ConnectionConfig");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

