/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.soap.jaxrpc;

import com.caucho.log.Log;
import com.caucho.soap.jaxrpc.CallImpl;
import com.caucho.soap.wsdl.WSDLOperation;
import com.caucho.soap.wsdl.WSDLPort;
import com.caucho.soap.wsdl.WSDLService;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.net.URL;
import java.rmi.Remote;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.rpc.Call;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.encoding.TypeMappingRegistry;
import javax.xml.rpc.handler.HandlerRegistry;

public class ServiceImpl
implements Service {
    private static final Logger log = Log.open(ServiceImpl._resin_compat_class_0());
    private static final L10N L = new L10N(ServiceImpl._resin_compat_class_0());
    private final QName _serviceName;
    private WSDLService _service;
    private static Class _resin_compat_class_0;

    ServiceImpl(QName serviceName) {
        this._serviceName = serviceName;
    }

    ServiceImpl(WSDLService service) {
        this._serviceName = service.getName();
        this._service = service;
    }

    public Call createCall() {
        throw new UnsupportedOperationException();
    }

    public Call createCall(QName portName) {
        throw new UnsupportedOperationException();
    }

    public Call createCall(QName portName, QName opName) throws ServiceException {
        WSDLPort port = this.getPort(portName);
        WSDLOperation op = port.getOperation(opName);
        if (op == null) {
            throw new ServiceException(L.l("{0} is an unknown operation in {1}", (Object)portName, opName));
        }
        return new CallImpl(port, op);
    }

    public Call createCall(QName portName, String operationName) {
        throw new UnsupportedOperationException();
    }

    public Call[] getCalls(QName portName) {
        throw new UnsupportedOperationException();
    }

    public HandlerRegistry getHandlerRegistry() {
        throw new UnsupportedOperationException();
    }

    public Remote getPort(Class serviceEndpointInterface) {
        throw new UnsupportedOperationException();
    }

    public Remote getPort(QName portName, Class serviceEndpointInterface) {
        throw new UnsupportedOperationException();
    }

    public Iterator getPorts() {
        return this._service.getPortNames();
    }

    public QName getServiceName() {
        return this._serviceName;
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        throw new UnsupportedOperationException();
    }

    public URL getWSDLDocumentLocation() {
        throw new UnsupportedOperationException();
    }

    private WSDLPort getPort(QName portName) throws ServiceException {
        WSDLPort port = this._service.getPort(portName);
        if (port == null) {
            throw new ServiceException(L.l("'{0}' is an unknown port in service '{1}'", (Object)portName, this.getServiceName()));
        }
        return port;
    }

    public String toString() {
        return new CharBuffer().append("ServiceImpl[").append(this.getServiceName()).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.soap.jaxrpc.ServiceImpl");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

