/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webapp;

import com.caucho.config.types.PathBuilder;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentListener;
import com.caucho.log.Log;
import com.caucho.server.deploy.DeployContainer;
import com.caucho.server.deploy.DeployGenerator;
import com.caucho.server.webapp.ApplicationContainer;
import com.caucho.server.webapp.WebAppConfig;
import com.caucho.server.webapp.WebAppController;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.Path;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebAppSingleDeployGenerator
extends DeployGenerator<WebAppController>
implements EnvironmentListener {
    private static final Logger log = Log.open(WebAppSingleDeployGenerator._resin_compat_class_0());
    private ApplicationContainer _container;
    private WebAppController _parentWebApp;
    private String _urlPrefix = "";
    private Path _archivePath;
    private Path _rootDirectory;
    private WebAppConfig _config;
    private ClassLoader _parentLoader;
    private WebAppController _controller;
    private static Class _resin_compat_class_0;

    public WebAppSingleDeployGenerator(DeployContainer<WebAppController> deployContainer) {
        super(deployContainer);
    }

    public WebAppSingleDeployGenerator(DeployContainer<WebAppController> deployContainer, ApplicationContainer container, WebAppConfig config) throws Exception {
        super(deployContainer);
        this.setContainer(container);
        String contextPath = config.getContextPath();
        if (contextPath.equals("/")) {
            contextPath = "";
        }
        this.setURLPrefix(config.getContextPath());
        this._config = config;
    }

    public ApplicationContainer getContainer() {
        return this._container;
    }

    public void setContainer(ApplicationContainer container) {
        this._container = container;
        if (this._parentLoader == null) {
            this._parentLoader = container.getClassLoader();
        }
    }

    public void setParentWebApp(WebAppController parent) {
        this._parentWebApp = parent;
    }

    public void setParentClassLoader(ClassLoader loader) {
        this._parentLoader = loader;
    }

    public void setURLPrefix(String prefix) {
        if (!prefix.startsWith("/")) {
            prefix = new CharBuffer().append("/").append(prefix).toString();
        }
        while (prefix.endsWith("/")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        this._urlPrefix = prefix;
    }

    public String getURLPrefix() {
        return this._urlPrefix;
    }

    public void setRootDirectory(Path rootDirectory) {
        this._rootDirectory = rootDirectory;
    }

    @Override
    protected Logger getLog() {
        return log;
    }

    public void init() throws Exception {
        if (this._controller != null) {
            return;
        }
        String appDir = this._config.getDocumentDirectory();
        if (appDir == null) {
            appDir = new CharBuffer().append("./").append(this._urlPrefix).toString();
        }
        if (this._rootDirectory == null) {
            this._rootDirectory = PathBuilder.lookupPath(appDir, null, this._container.getDocumentDirectory());
        }
        this._controller = new WebAppController(this._urlPrefix, this._rootDirectory, this._container);
        this._controller.setArchivePath(this._archivePath);
        if (this._archivePath != null) {
            this._controller.addDepend(this._archivePath);
        }
        this._controller.setParentWebApp(this._parentWebApp);
        this._controller.setConfig(this._config);
        this._controller.setSourceType("single");
        Environment.addEnvironmentListener(this, this._parentLoader);
    }

    @Override
    protected void fillDeployedKeys(Set<String> keys) {
        keys.add(this._controller.getContextPath());
    }

    @Override
    public WebAppController generateController(String name) {
        if (name.equals(this._controller.getContextPath())) {
            return this._controller;
        }
        return null;
    }

    @Override
    public WebAppController mergeController(WebAppController controller, String name) {
        if (controller.getRootDirectory().equals(this._controller.getRootDirectory())) {
            return this._controller.merge(controller);
        }
        if (!this._controller.isNameMatch(name)) {
            return controller;
        }
        return this._controller;
    }

    public void deploy() {
        try {
            this.init();
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    @Override
    public void destroy() {
        this._container.removeWebAppDeploy(this);
    }

    @Override
    public void environmentStart(EnvironmentClassLoader loader) {
    }

    @Override
    public void environmentStop(EnvironmentClassLoader loader) {
        this.destroy();
    }

    public String toString() {
        return new CharBuffer().append("WebAppDeploy[").append(this._urlPrefix).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.server.webapp.WebAppSingleDeployGenerator");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

