/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webapp;

import com.caucho.config.types.PathBuilder;
import com.caucho.log.Log;
import com.caucho.server.deploy.DeployConfig;
import com.caucho.server.deploy.DeployContainer;
import com.caucho.server.deploy.DeployGenerator;
import com.caucho.server.webapp.ApplicationContainer;
import com.caucho.server.webapp.WebAppConfig;
import com.caucho.server.webapp.WebAppController;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebAppRegexpDeployGenerator
extends DeployGenerator<WebAppController> {
    private static final Logger log = Log.open(WebAppRegexpDeployGenerator._resin_compat_class_0());
    private ApplicationContainer _container;
    private WebAppController _parent;
    private WebAppConfig _config;
    private ArrayList<WebAppConfig> _webAppDefaults = new ArrayList();
    private ArrayList<WebAppController> _entries = new ArrayList();
    private static Class _resin_compat_class_0;

    public WebAppRegexpDeployGenerator(DeployContainer<WebAppController> deployContainer) {
        super(deployContainer);
    }

    public WebAppRegexpDeployGenerator(DeployContainer<WebAppController> deployContainer, ApplicationContainer container, WebAppConfig config) {
        super(deployContainer);
        this.setContainer(container);
        this._config = config;
    }

    public ApplicationContainer getContainer() {
        return this._container;
    }

    public void setContainer(ApplicationContainer container) {
        this._container = container;
    }

    public void setParent(WebAppController parent) {
        this._parent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public WebAppController generateController(String name) {
        Pattern regexp = this._config.getURLRegexp();
        Matcher matcher = regexp.matcher(name);
        if (!matcher.find()) return null;
        if (matcher.start() != 0) {
            return null;
        }
        int length = matcher.end() - matcher.start();
        String contextPath = matcher.group();
        ArrayList<String> vars = new ArrayList<String>();
        HashMap<String, Object> varMap = new HashMap<String, Object>();
        for (int j = 0; j <= matcher.groupCount(); ++j) {
            vars.add(matcher.group(j));
            varMap.put(new CharBuffer().append("app").append(j).toString(), matcher.group(j));
        }
        varMap.put("regexp", vars);
        Path appDir = null;
        try {
            String appDirPath = this._config.getDocumentDirectory();
            if (appDirPath == null) {
                appDirPath = new CharBuffer().append("./").append(matcher.group(0)).toString();
            }
            if (!(appDir = PathBuilder.lookupPath(appDirPath, varMap)).canRead()) {
                return null;
            }
        }
        catch (Exception e) {
            log.log(Level.FINER, e.toString(), e);
            return null;
        }
        WebAppController controller = null;
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.getParentClassLoader());
            ArrayList<WebAppController> arrayList = this._entries;
            synchronized (arrayList) {
                int i;
                for (i = 0; i < this._entries.size(); ++i) {
                    controller = this._entries.get(i);
                    if (!appDir.equals(controller.getRootDirectory())) continue;
                    WebAppController webAppController = controller;
                    return webAppController;
                }
                controller = new WebAppController(name, appDir, this._container);
                controller.getVariableMap().putAll(varMap);
                controller.setRegexpValues(vars);
                controller.setConfig(this._config);
                for (i = 0; i < this._webAppDefaults.size(); ++i) {
                    controller.addConfigDefault((DeployConfig)this._webAppDefaults.get(i));
                }
                this._entries.add(controller);
            }
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
        controller.setSourceType("regexp");
        return controller;
    }

    @Override
    public void destroy() {
    }

    public String toString() {
        return new CharBuffer().append("WebAppRegexpDeployGenerator[").append(this._config.getURLRegexp().pattern()).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.server.webapp.WebAppSingleDeployGenerator");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

