/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webapp;

import com.caucho.jmx.AdminAttributeCategory;
import com.caucho.jmx.AdminInfo;
import com.caucho.server.deploy.DeployControllerAdmin;
import com.caucho.server.session.SessionManager;
import com.caucho.server.webapp.Application;
import com.caucho.server.webapp.WebAppController;
import com.caucho.server.webapp.mbean.WebAppMBean;
import com.caucho.util.L10N;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebAppAdmin
extends DeployControllerAdmin<WebAppController>
implements WebAppMBean {
    private static L10N L = new L10N(WebAppAdmin._resin_compat_class_0());
    private static Class _resin_compat_class_0;

    public WebAppAdmin(WebAppController controller) {
        super(controller);
    }

    @Override
    public AdminInfo getAdminInfo() {
        AdminInfo descriptor = super.getAdminInfo();
        String contextPath = this.getContextPath();
        if (contextPath == null || contextPath.length() == 0) {
            contextPath = "/";
        }
        descriptor.setTitle(L.l("WebApp {0}", contextPath));
        descriptor.setDescription(L.l("A web application is a self-contained subtree of the web site."));
        descriptor.createAdminAttributeInfo("ContextPath").setCategory(AdminAttributeCategory.CONFIGURATION);
        descriptor.createAdminAttributeInfo("ActiveSessionCount").setCategory(AdminAttributeCategory.STATISTIC);
        return descriptor;
    }

    @Override
    public String getContextPath() {
        return ((WebAppController)this.getController()).getContextPath();
    }

    @Override
    public int getActiveSessionCount() {
        Application app = this.getApplication();
        if (app == null) {
            return 0;
        }
        SessionManager manager = app.getSessionManager();
        if (manager == null) {
            return 0;
        }
        return manager.getActiveSessionCount();
    }

    protected Application getApplication() {
        return ((WebAppController)this.getController()).getApplication();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.server.webapp.WebAppAdmin");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

