/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webapp;

import com.caucho.config.ConfigException;
import com.caucho.config.types.PathBuilder;
import com.caucho.server.dispatch.UrlMap;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RewriteRealPath {
    static final L10N L = new L10N(RewriteRealPath._resin_compat_class_0());
    static final Logger log = Logger.getLogger(RewriteRealPath._resin_compat_class_0().getName());
    private Path _appDir;
    private final ArrayList<Program> _programList = new ArrayList();
    private UrlMap<String> _pathMapping;
    private static Class _resin_compat_class_0;

    public RewriteRealPath(Path appDir) {
        this._appDir = appDir;
    }

    public void addRewrite(Rewrite rewrite) {
        this._programList.add(rewrite);
    }

    public void addRealPath(RealPath realPath) {
        this._programList.add(realPath);
    }

    public void addPathPattern(String urlPattern, String realPath) {
        if (this._pathMapping == null) {
            this._pathMapping = new UrlMap();
        }
        this._pathMapping.addMap(urlPattern, realPath);
    }

    public void addPathRegexp(String urlRegexp, String realPath) {
        if (this._pathMapping == null) {
            this._pathMapping = new UrlMap();
        }
        this._pathMapping.addRegexp(urlRegexp, realPath);
    }

    public String mapToRealPath(String uri) {
        for (int i = 0; i < this._programList.size(); ++i) {
            Program program = this._programList.get(i);
            String realPath = program.toRealPath(uri = program.rewrite(uri));
            if (realPath == null) continue;
            return this._appDir.lookup(realPath).getNativePath();
        }
        return this.pathMappingToRealPath(uri);
    }

    private String pathMappingToRealPath(String uri) {
        Path path;
        if (this._pathMapping == null) {
            return this._appDir.lookup(new CharBuffer().append("./").append(uri).toString()).getNativePath();
        }
        ArrayList<String> regexpVars = new ArrayList<String>();
        String map = this._pathMapping.map(uri, regexpVars);
        if (map == null) {
            path = this._appDir.lookup(new CharBuffer().append("./").append(uri).toString());
        } else {
            try {
                path = PathBuilder.lookupPath(map, regexpVars);
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString(), e);
                path = this._appDir.lookup(map);
            }
            String match = regexpVars.get(0);
            String tail = uri.substring(match.length());
            if (uri.endsWith("/") && !tail.endsWith("/")) {
                tail = new CharBuffer().append(tail).append('/').toString();
            }
            if (tail.startsWith("/")) {
                tail = new CharBuffer().append('.').append(tail).toString();
            }
            if (!tail.equals("")) {
                path = path.lookup(tail);
            }
        }
        String nativePath = path.getNativePath();
        return nativePath;
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.server.webapp.RewriteRealPath");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static class RealPath
    extends Program {
        private Pattern _regexp;
        private String _target;

        public void setRegexp(String regexp) {
            this._regexp = Pattern.compile(regexp);
        }

        public void setTarget(String target) {
            this._target = target;
        }

        public void init() throws ConfigException {
            if (this._regexp == null) {
                throw new ConfigException(L.l("real-path needs 'regexp' attribute."));
            }
            if (this._target == null) {
                throw new ConfigException(L.l("real-path needs 'target' attribute."));
            }
        }

        public String toRealPath(String uri) {
            Matcher matcher = this._regexp.matcher(uri);
            if (matcher.find()) {
                matcher.reset();
                return matcher.replaceAll(this._target);
            }
            return null;
        }
    }

    public static class Rewrite
    extends Program {
        private Pattern _regexp;
        private String _replacement;

        public void setRegexp(String regexp) {
            this._regexp = Pattern.compile(regexp);
        }

        public void setReplacement(String replacement) {
            this._replacement = replacement;
        }

        public void init() throws ConfigException {
            if (this._regexp == null) {
                throw new ConfigException(L.l("rewrite needs 'regexp' attribute."));
            }
            if (this._replacement == null) {
                throw new ConfigException(L.l("rewrite needs 'replacement' attribute."));
            }
        }

        public String rewrite(String uri) {
            Matcher matcher = this._regexp.matcher(uri);
            if (matcher.find()) {
                matcher.reset();
                return matcher.replaceAll(this._replacement);
            }
            return uri;
        }
    }

    static class Program {
        Program() {
        }

        public String rewrite(String uri) {
            return uri;
        }

        public String toRealPath(String uri) {
            return null;
        }
    }
}

