/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.resin;

import com.caucho.jmx.AdminAttributeCategory;
import com.caucho.jmx.AdminInfo;
import com.caucho.jmx.AdminInfoFactory;
import com.caucho.log.Log;
import com.caucho.server.resin.mbean.ThreadPoolMBean;
import com.caucho.util.L10N;
import com.caucho.util.ThreadPool;
import java.util.logging.Logger;

public class ThreadPoolAdmin
implements ThreadPoolMBean,
AdminInfoFactory {
    private static final L10N L = new L10N(ThreadPoolAdmin._resin_compat_class_0());
    private static final Logger log = Log.open(ThreadPoolAdmin._resin_compat_class_0());
    private static Class _resin_compat_class_0;

    public AdminInfo getAdminInfo() {
        AdminInfo descriptor = new AdminInfo();
        descriptor.setTitle(L.l("ThreadPool"));
        descriptor.setDescription(L.l("The ThreadPool manages all threads used by Resin."));
        descriptor.createAdminAttributeInfo("ThreadMax").setCategory(AdminAttributeCategory.CONFIGURATION).setDescription(L.l("The maximum number of threads that Resin can allocate."));
        descriptor.createAdminAttributeInfo("SpareThreadMin").setCategory(AdminAttributeCategory.CONFIGURATION).setDescription(L.l("The minimum number of threads Resin should have available for new requests or other tasks.  This value causes a minimum number of idle threads, useful for situations where there is a sudden increase in the number of threads required."));
        descriptor.createAdminAttributeInfo("ThreadCount").setCategory(AdminAttributeCategory.STATISTIC).setDescription(L.l("The current total number of threads managed by the pool."));
        descriptor.createAdminAttributeInfo("ActiveThreadCount").setCategory(AdminAttributeCategory.STATISTIC).setDescription(L.l("The number of active threads. These threads are busy servicing requests or performing other tasks."));
        descriptor.createAdminAttributeInfo("IdleThreadCount").setCategory(AdminAttributeCategory.CONFIGURATION).setDescription(L.l("The number of idle threads. These threads are allocated but inactive, available for new requests or tasks."));
        return descriptor;
    }

    public int getThreadMax() {
        return ThreadPool.getThreadMax();
    }

    public int getSpareThreadMin() {
        return ThreadPool.getSpareThreadMin();
    }

    public int getThreadCount() {
        return ThreadPool.getThreadCount();
    }

    public int getActiveThreadCount() {
        return ThreadPool.getActiveThreadCount();
    }

    public int getIdleThreadCount() {
        return ThreadPool.getIdleThreadCount();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.server.resin.ThreadPoolAdmin");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

