/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.resin;

import com.caucho.jmx.AdminAttributeCategory;
import com.caucho.jmx.AdminInfo;
import com.caucho.jmx.AdminInfoFactory;
import com.caucho.server.resin.ResinServer;
import com.caucho.server.resin.ServerController;
import com.caucho.server.resin.mbean.ResinServerMBean;
import com.caucho.util.CauchoSystem;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class ResinServerAdmin
implements ResinServerMBean,
AdminInfoFactory {
    private static final L10N L = new L10N(ResinServerAdmin._resin_compat_class_0());
    private static final ObjectName THREADPOOL_OBJECTNAME;
    private final ResinServer _resinServer;
    private static Class _resin_compat_class_0;

    public ResinServerAdmin(ResinServer resinServer) {
        this._resinServer = resinServer;
    }

    public AdminInfo getAdminInfo() {
        AdminInfo descriptor = new AdminInfo();
        descriptor.setTitle(L.l("ResinServer"));
        descriptor.setDescription(L.l("An instance of Resin running in a JVM"));
        descriptor.createAdminAttributeInfo("LocalHost").setCategory(AdminAttributeCategory.CONFIGURATION).setDescription(L.l("The ip address of the machine that is running this instance of Resin."));
        descriptor.createAdminAttributeInfo("ServerId").setCategory(AdminAttributeCategory.CONFIGURATION).setDescription(L.l("The server id used when starting this version of Resin, the value of `-server id'."));
        descriptor.createAdminAttributeInfo("ConfigFile").setCategory(AdminAttributeCategory.CONFIGURATION).setDescription(L.l("The configuration file used when starting this instance of Resin, the value of `-config file'."));
        descriptor.createAdminAttributeInfo("ResinHome").setCategory(AdminAttributeCategory.CONFIGURATION).setDescription(L.l("The Resin home directory used when starting this instance of Resin. This is the location of the Resin program files."));
        descriptor.createAdminAttributeInfo("ServerRoot").setCategory(AdminAttributeCategory.CONFIGURATION).setDescription(L.l("The server root directory used when starting this instance of Resin. This is the root directory of the web server files."));
        descriptor.createAdminAttributeInfo("State").setCategory(AdminAttributeCategory.STATISTIC).setDescription(L.l("The current lifecycle state."));
        descriptor.createAdminAttributeInfo("InitialStartTime").setCategory(AdminAttributeCategory.STATISTIC).setDescription(L.l("The time that this instance was first started."));
        descriptor.createAdminAttributeInfo("StartTime").setCategory(AdminAttributeCategory.STATISTIC).setDescription(L.l("The time that this instance was last started or restarted."));
        descriptor.createAdminAttributeInfo("ThreadPoolObjectName").setCategory(AdminAttributeCategory.CHILD).setDescription(L.l("The ThreadPool manages all threads used by Resin."));
        descriptor.createAdminAttributeInfo("ServerObjectNames").setCategory(AdminAttributeCategory.CHILD).setDescription(L.l("The servers that are active within this JVM."));
        descriptor.createAdminOperationInfo("Restart").setImpact(1).setDescription(L.l("Exit this instance cleanly and allow the wrapper script to start a new JVM."));
        return descriptor;
    }

    public String getLocalHost() {
        return CauchoSystem.getLocalHost();
    }

    public String getServerId() {
        return this._resinServer.getServerId();
    }

    public String getConfigFile() {
        return this._resinServer.getConfigFile();
    }

    public String getResinHome() {
        return CauchoSystem.getResinHome().getNativePath();
    }

    public String getServerRoot() {
        return CauchoSystem.getServerRoot().getNativePath();
    }

    public String getState() {
        if (this._resinServer.isClosed()) {
            return "destroyed";
        }
        if (this._resinServer.isClosing()) {
            return "destroying";
        }
        return "active";
    }

    public Date getInitialStartTime() {
        return this._resinServer.getInitialStartTime();
    }

    public Date getStartTime() {
        return this._resinServer.getStartTime();
    }

    public ObjectName getThreadPoolObjectName() {
        return THREADPOOL_OBJECTNAME;
    }

    public ObjectName[] getServerObjectNames() {
        ArrayList<ServerController> servers = this._resinServer.getServerList();
        ObjectName[] objectNames = new ObjectName[servers.size()];
        int i = 0;
        Iterator<ServerController> i$ = servers.iterator();
        while (i$.hasNext()) {
            ServerController server = i$.next();
            objectNames[i++] = server.getObjectName();
        }
        return objectNames;
    }

    public void restart() {
        this._resinServer.destroy();
    }

    static {
        try {
            THREADPOOL_OBJECTNAME = new ObjectName("resin:type=ThreadPool");
        }
        catch (MalformedObjectNameException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.server.resin.ResinServerAdmin");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

