/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.port;

import com.caucho.config.ConfigException;
import com.caucho.config.types.Period;
import com.caucho.jmx.AdminAttributeCategory;
import com.caucho.jmx.AdminInfo;
import com.caucho.jmx.AdminInfoFactory;
import com.caucho.jmx.Jmx;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentBean;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentListener;
import com.caucho.log.Log;
import com.caucho.server.port.AbstractSelectManager;
import com.caucho.server.port.Protocol;
import com.caucho.server.port.ProtocolDispatchServer;
import com.caucho.server.port.TcpConnection;
import com.caucho.server.port.mbean.PortMBean;
import com.caucho.util.CharBuffer;
import com.caucho.util.FreeList;
import com.caucho.util.L10N;
import com.caucho.util.ThreadPool;
import com.caucho.vfs.JsseSSLFactory;
import com.caucho.vfs.QJniServerSocket;
import com.caucho.vfs.QServerSocket;
import com.caucho.vfs.QSocket;
import com.caucho.vfs.SSLFactory;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;

public class Port
implements EnvironmentListener,
Runnable,
PortMBean,
AdminInfoFactory {
    private static final L10N L = new L10N(Port._resin_compat_class_0());
    private static final Logger log = Log.open(Port._resin_compat_class_0());
    private static final long CLOSE_INTERVAL = 1000L;
    private FreeList<TcpConnection> _freeConn = new FreeList(32);
    private ProtocolDispatchServer _server;
    private String _serverId = "";
    private String _host;
    private int _port;
    private Protocol _protocol;
    private SSLFactory _sslFactory;
    private InetAddress _socketAddress;
    private long _readTimeout;
    private long _writeTimeout;
    private long _timeout = 65000L;
    private int _connectionMax = 512;
    private int _minSpareConnection = 16;
    private int _keepaliveMax = -1;
    private long _keepaliveTimeout = 120000L;
    private int _minSpareListen = 5;
    private int _maxSpareListen = 10;
    private int _listenBacklog = 100;
    private String _virtualHost;
    private boolean _tcpNoDelay = true;
    private boolean _isIgnoreClientDisconnect;
    private ObjectName _objectName;
    private QServerSocket _serverSocket;
    private AbstractSelectManager _selectManager;
    private volatile int _threadCount;
    private final Object _threadCountLock = new Object();
    private volatile int _idleThreadCount;
    private volatile int _startThreadCount;
    private volatile long _lastThreadTime;
    private volatile int _connectionCount;
    private volatile int _keepaliveCount;
    private final Object _keepaliveCountLock = new Object();
    private Thread _thread;
    private volatile boolean _isBound;
    private final Lifecycle _lifecycle = new Lifecycle();
    private static Class _resin_compat_class_0;

    public void setParent(ProtocolDispatchServer parent) {
        this.setServer(parent);
    }

    public void setServer(ProtocolDispatchServer server) {
        this._server = server;
        if (this._protocol != null) {
            this._protocol.setServer(server);
        }
    }

    public ProtocolDispatchServer getServer() {
        return this._server;
    }

    public void setId(String id) {
        this._serverId = id;
    }

    public void setServerId(String id) {
        this._serverId = id;
    }

    public String getServerId() {
        return this._serverId;
    }

    public ObjectName getObjectName() {
        return this._objectName;
    }

    public void setProtocol(Protocol protocol) throws ConfigException {
        this._protocol = protocol;
        this._protocol.setServer(this._server);
    }

    public Protocol getProtocol() {
        return this._protocol;
    }

    public String getProtocolName() {
        if (this._protocol != null) {
            return this._protocol.getProtocolName();
        }
        return null;
    }

    public void setHost(String host) throws UnknownHostException {
        if ("*".equals(host)) {
            host = null;
        }
        this._host = host;
        if (host != null) {
            this._socketAddress = InetAddress.getByName(host);
        }
    }

    public String getHost() {
        return this._host;
    }

    public void setPort(int port) {
        this._port = port;
    }

    public int getPort() {
        return this._port;
    }

    public void setVirtualHost(String host) {
        this._virtualHost = host;
    }

    public String getVirtualHost() {
        return this._virtualHost;
    }

    public void setSSL(SSLFactory factory) {
        this._sslFactory = factory;
    }

    public SSLFactory createOpenssl() throws ConfigException {
        try {
            Class<?> cl = Class.forName("com.caucho.vfs.OpenSSLFactory");
            this._sslFactory = (SSLFactory)cl.newInstance();
            return this._sslFactory;
        }
        catch (Throwable e) {
            log.log(Level.FINER, e.toString(), e);
            throw new ConfigException(L.l("<openssl> requires Resin Professional.  See http://www.caucho.com for more information."));
        }
    }

    public JsseSSLFactory createJsse() {
        return new JsseSSLFactory();
    }

    public void setJsseSsl(JsseSSLFactory factory) {
        this._sslFactory = factory;
    }

    public SSLFactory getSSL() {
        return this._sslFactory;
    }

    public boolean isSSL() {
        return this._sslFactory != null;
    }

    public void setServerSocket(QServerSocket socket) {
        this._serverSocket = socket;
    }

    public void setMinSpareListen(int minSpare) throws ConfigException {
        if (minSpare < 1) {
            throw new ConfigException(L.l("min-spare-listen must be at least 1."));
        }
        this._minSpareListen = minSpare;
    }

    public void setMaxSpareListen(int maxSpare) throws ConfigException {
        if (maxSpare < 1) {
            throw new ConfigException(L.l("max-spare-listen must be at least 1."));
        }
        this._maxSpareListen = maxSpare;
    }

    public boolean getTcpNoDelay() {
        return this._tcpNoDelay;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this._tcpNoDelay = tcpNoDelay;
    }

    public void setSocketListenBacklog(int backlog) {
        this._listenBacklog = backlog;
    }

    public boolean isIgnoreClientDisconnect() {
        return this._server.isIgnoreClientDisconnect();
    }

    public int getThreadCount() {
        return this._threadCount;
    }

    public void setTimeout(Period period) {
        this._timeout = period.getPeriod();
    }

    public void setReadTimeout(Period period) {
        this._readTimeout = period.getPeriod();
    }

    public long getReadTimeout() {
        return this._readTimeout;
    }

    public void setWriteTimeout(Period period) {
        this._writeTimeout = period.getPeriod();
    }

    public long getWriteTimeout() {
        return this._writeTimeout;
    }

    public int getActiveThreadCount() {
        return this._threadCount - this._idleThreadCount;
    }

    public int getIdleThreadCount() {
        return this._idleThreadCount;
    }

    public void setConnectionMax(int max) {
        this._connectionMax = max;
    }

    public int getConnectionMax() {
        return this._connectionMax;
    }

    public int getConnectionCount() {
        return this._connectionCount;
    }

    public void setKeepaliveMax(int max) {
        if (this._server != null && this._server.getKeepaliveMax() < max) {
            max = this._server.getKeepaliveMax();
            log.config(L.l("keepalive limited to {0}", max));
        }
        this._keepaliveMax = max;
    }

    public int getKeepaliveMax() {
        return this._keepaliveMax;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getKeepaliveCount() {
        Object object = this._keepaliveCountLock;
        synchronized (object) {
            return this._keepaliveCount;
        }
    }

    public boolean isActive() {
        return this._lifecycle.isActive();
    }

    public int getFreeKeepalive() {
        int freeKeepalive = this._keepaliveMax - this._keepaliveCount;
        int freeConnections = this._connectionMax - this._connectionCount - this._minSpareConnection;
        int freeSelect = this._server.getFreeSelectKeepalive();
        if (freeKeepalive < freeConnections) {
            return freeSelect < freeKeepalive ? freeSelect : freeKeepalive;
        }
        return freeSelect < freeConnections ? freeSelect : freeConnections;
    }

    public boolean matchesServerId(String serverId) {
        return this.getServerId().equals("*") || this.getServerId().equals(serverId);
    }

    public void init() throws ConfigException {
        if (!this._lifecycle.toInit()) {
            return;
        }
        if (this._server instanceof EnvironmentBean) {
            Environment.addEnvironmentListener(this, ((EnvironmentBean)((Object)this._server)).getClassLoader());
        }
        if (this._readTimeout <= 0L) {
            this._readTimeout = this._timeout;
        }
        if (this._writeTimeout <= 0L) {
            this._writeTimeout = this._timeout;
        }
    }

    public AdminInfo getAdminInfo() {
        AdminInfo descriptor = new AdminInfo();
        String host = this.getHost();
        if (host == null || host.length() == 0) {
            host = "*";
        }
        descriptor.setTitle(L.l("Port {0}:{1}", (Object)host, this.getPort()));
        descriptor.createAdminAttributeInfo("ProtocolName").setCategory(AdminAttributeCategory.CONFIGURATION);
        descriptor.createAdminAttributeInfo("Host").setCategory(AdminAttributeCategory.CONFIGURATION);
        descriptor.createAdminAttributeInfo("Port").setCategory(AdminAttributeCategory.CONFIGURATION);
        descriptor.createAdminAttributeInfo("ThreadCount").setCategory(AdminAttributeCategory.STATISTIC);
        descriptor.createAdminAttributeInfo("ActiveThreadCount").setCategory(AdminAttributeCategory.STATISTIC);
        descriptor.createAdminAttributeInfo("IdleThreadCount").setCategory(AdminAttributeCategory.STATISTIC);
        descriptor.createAdminAttributeInfo("ConnectionMax").setCategory(AdminAttributeCategory.CONFIGURATION);
        descriptor.createAdminAttributeInfo("KeepaliveMax").setCategory(AdminAttributeCategory.CONFIGURATION);
        descriptor.createAdminAttributeInfo("KeepaliveCount").setDeprecated("3.0.15 Use KeepaliveConnectionCount");
        descriptor.createAdminAttributeInfo("Active").setCategory(AdminAttributeCategory.STATISTIC);
        descriptor.createAdminAttributeInfo("TotalConnectionCount").setCategory(AdminAttributeCategory.STATISTIC);
        descriptor.createAdminAttributeInfo("ActiveConnectionCount").setCategory(AdminAttributeCategory.STATISTIC);
        descriptor.createAdminAttributeInfo("KeepaliveConnectionCount").setCategory(AdminAttributeCategory.STATISTIC);
        descriptor.createAdminAttributeInfo("SelectConnectionCount").setCategory(AdminAttributeCategory.STATISTIC);
        return descriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind() throws Exception {
        Port port = this;
        synchronized (port) {
            if (this._isBound) {
                return;
            }
            this._isBound = true;
        }
        if (this._protocol == null) {
            throw new IllegalStateException(L.l("`{0}' must have a configured protocol before starting.", this));
        }
        try {
            this._objectName = this._host == null ? Jmx.getObjectName(new CharBuffer().append("type=Port,port=").append(this._port).toString()) : Jmx.getObjectName(new CharBuffer().append("type=Port,port=").append(this._port).append(",host=").append(this._host).toString());
            Jmx.register((Object)this, this._objectName);
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        if (this._serverSocket != null) {
            if (this._port != 0) {
                if (this._host != null) {
                    log.info(new CharBuffer().append("listening to ").append(this._host).append(":").append(this._port).toString());
                } else {
                    log.info(new CharBuffer().append("listening to ").append(this._port).toString());
                }
            }
        } else if (this._sslFactory != null && this._socketAddress != null) {
            this._serverSocket = this._sslFactory.create(this._socketAddress, this._port);
            log.info(new CharBuffer().append(this._protocol.getProtocolName()).append("s listening to ").append(this._socketAddress.getHostName()).append(":").append(this._port).toString());
        } else if (this._sslFactory != null) {
            if (this._host == null) {
                this._serverSocket = this._sslFactory.create(null, this._port);
                log.info(new CharBuffer().append(this._protocol.getProtocolName()).append("s listening to *:").append(this._port).toString());
            } else {
                InetAddress addr = InetAddress.getByName(this._host);
                this._serverSocket = this._sslFactory.create(addr, this._port);
                log.info(new CharBuffer().append(this._protocol.getProtocolName()).append("s listening to ").append(this._host).append(":").append(this._port).toString());
            }
        } else if (this._socketAddress != null) {
            this._serverSocket = QJniServerSocket.create(this._socketAddress, this._port, this._listenBacklog);
            log.info(new CharBuffer().append(this._protocol.getProtocolName()).append(" listening to ").append(this._socketAddress.getHostName()).append(":").append(this._port).toString());
        } else {
            this._serverSocket = QJniServerSocket.create(this._port, this._listenBacklog);
            log.info(new CharBuffer().append(this._protocol.getProtocolName()).append(" listening to *:").append(this._port).toString());
        }
        if (this._tcpNoDelay) {
            this._serverSocket.setTcpNoDelay(this._tcpNoDelay);
        }
        this._serverSocket.setConnectionReadTimeout((int)this._readTimeout);
        this._serverSocket.setConnectionWriteTimeout((int)this._writeTimeout);
    }

    public void start() throws Throwable {
        if (!this._lifecycle.toActive()) {
            return;
        }
        try {
            this.bind();
            if (this._serverSocket.isJNI()) {
                this._selectManager = this._server.getSelectManager();
                if (this._selectManager == null) {
                    throw new IllegalStateException(L.l("Cannot load select manager"));
                }
            }
            if (this._keepaliveMax < 0) {
                this._keepaliveMax = this._server.getKeepaliveMax();
            }
            if (this._keepaliveMax < 0) {
                this._keepaliveMax = 256;
            }
            String name = new CharBuffer().append("resin-port-").append(this._serverSocket.getLocalPort()).toString();
            this._thread = new Thread((Runnable)this, name);
            this._thread.setDaemon(true);
            this._thread.start();
        }
        catch (Throwable e) {
            this.close();
            log.log(Level.WARNING, e.toString(), e);
            throw e;
        }
    }

    public int getTotalConnectionCount() {
        return this._connectionCount;
    }

    public int getActiveConnectionCount() {
        return this._threadCount - this._idleThreadCount;
    }

    public int getKeepaliveConnectionCount() {
        return this.getKeepaliveCount();
    }

    public AbstractSelectManager getSelectManager() {
        return this._selectManager;
    }

    public int getSelectConnectionCount() {
        if (this._selectManager != null) {
            return this._selectManager.getSelectCount();
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean accept(TcpConnection conn, boolean isFirst) {
        try {
            Port port = this;
            synchronized (port) {
                ++this._idleThreadCount;
                if (isFirst) {
                    --this._startThreadCount;
                    if (this._startThreadCount < 0) {
                        Thread.dumpStack();
                    }
                }
                if (this._maxSpareListen < this._idleThreadCount) {
                    boolean bl = false;
                    return bl;
                }
            }
            do {
                if (!this._lifecycle.isActive()) return false;
                QSocket socket = conn.startSocket();
                Thread.interrupted();
                if (!this._serverSocket.accept(socket)) continue;
                conn.initSocket();
                boolean bl = true;
                return bl;
            } while (this._maxSpareListen >= this._idleThreadCount);
            boolean bl = false;
            return bl;
        }
        catch (Throwable e) {
            if (!this._lifecycle.isActive()) return false;
            if (!log.isLoggable(Level.FINER)) return false;
            log.log(Level.FINER, e.toString(), e);
            return false;
        }
        finally {
            boolean newConn = false;
            Port port = this;
            synchronized (port) {
                --this._idleThreadCount;
                if (this._idleThreadCount + this._startThreadCount < this._minSpareListen) {
                    this.notify();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startConnection(TcpConnection conn) {
        Port port = this;
        synchronized (port) {
            --this._startThreadCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void threadBegin(TcpConnection conn) {
        Object object = this._threadCountLock;
        synchronized (object) {
            ++this._threadCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void threadEnd(TcpConnection conn) {
        Object object = this._threadCountLock;
        synchronized (object) {
            --this._threadCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean keepaliveBegin(TcpConnection conn) {
        Object object = this._keepaliveCountLock;
        synchronized (object) {
            if (this._keepaliveMax <= this._keepaliveCount) {
                return false;
            }
            if (this._connectionMax <= this._connectionCount + this._minSpareConnection) {
                return false;
            }
            ++this._keepaliveCount;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void keepaliveEnd(TcpConnection conn) {
        Object object = this._keepaliveCountLock;
        synchronized (object) {
            --this._keepaliveCount;
            if (this._keepaliveCount < 0) {
                int count = this._keepaliveCount;
                this._keepaliveCount = 0;
                log.warning(new CharBuffer().append("internal error: negative keepalive count ").append(count).toString());
            }
        }
    }

    public boolean isClosed() {
        return this._lifecycle.isAfterActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this._lifecycle.isActive()) {
            boolean isStart = false;
            try {
                Thread.yield();
                Thread.sleep(10L);
                Port port = this;
                synchronized (port) {
                    boolean bl = isStart = this._startThreadCount + this._idleThreadCount < this._minSpareListen;
                    if (this._connectionMax <= this._connectionCount) {
                        isStart = false;
                    }
                    if (!isStart) {
                        Thread.interrupted();
                        this.wait(60000L);
                    }
                    if (isStart) {
                        ++this._connectionCount;
                        ++this._startThreadCount;
                    }
                }
                if (!isStart || !this._lifecycle.isActive()) continue;
                TcpConnection conn = this._freeConn.allocate();
                if (conn == null) {
                    conn = new TcpConnection(this, this._serverSocket.createSocket());
                    conn.setRequest(this._protocol.createRequest(conn));
                }
                ThreadPool.schedule(conn);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        this._thread = null;
    }

    public void environmentStart(EnvironmentClassLoader loader) {
    }

    public void environmentStop(EnvironmentClassLoader loader) {
        this.close();
    }

    void free(TcpConnection conn) {
        this.closeConnection(conn);
        this._freeConn.free(conn);
    }

    void kill(TcpConnection conn) {
        this.closeConnection(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConnection(TcpConnection conn) {
        Port port = this;
        synchronized (port) {
            if (this._connectionCount-- == this._connectionMax) {
                try {
                    this.notify();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Environment.removeEnvironmentListener(this);
        if (!this._lifecycle.toDestroy()) {
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(new CharBuffer().append("closing ").append(this).toString());
        }
        QServerSocket serverSocket = this._serverSocket;
        this._serverSocket = null;
        this._selectManager = null;
        AbstractSelectManager selectManager = null;
        if (this._server != null) {
            selectManager = this._server.getSelectManager();
            this._server.setSelectManager(null);
        }
        InetAddress localAddress = null;
        int localPort = 0;
        if (serverSocket != null) {
            localAddress = serverSocket.getLocalAddress();
            localPort = serverSocket.getLocalPort();
        }
        if (serverSocket != null) {
            try {
                serverSocket.close();
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                QServerSocket e = serverSocket;
                synchronized (e) {
                    serverSocket.notifyAll();
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        if (selectManager != null) {
            try {
                selectManager.close();
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        try {
            if (this._objectName != null) {
                Jmx.unregister(this._objectName);
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        if (localPort > 0) {
            int idleCount = this._idleThreadCount + this._startThreadCount;
            for (int i = 0; i < idleCount + 10; ++i) {
                try {
                    Socket socket = localAddress == null || localAddress.getHostAddress().startsWith("0.") ? new Socket("127.0.0.1", localPort) : new Socket(localAddress, localPort);
                    socket.close();
                    continue;
                }
                catch (ConnectException e) {
                    continue;
                }
                catch (Throwable e) {
                    log.log(Level.FINEST, e.toString(), e);
                }
            }
        }
        log.finest(new CharBuffer().append("closed ").append(this).toString());
    }

    public String toString() {
        return new CharBuffer().append("Port[").append(this.getHost()).append(":").append(this.getPort()).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.server.port.Port");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

