/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.util.CharBuffer;

public class InvocationKey {
    private CharSequence _host;
    private int _port;
    private byte[] _uri;
    private int _uriLength;

    public InvocationKey() {
    }

    InvocationKey(CharSequence host, int port, byte[] uri, int uriLength) {
        if (host != null) {
            CharBuffer cb = CharBuffer.allocate();
            cb.append(host);
            this._host = cb;
        }
        this._port = port;
        this._uri = new byte[uriLength];
        System.arraycopy(uri, 0, this._uri, 0, uriLength);
        this._uriLength = uriLength;
    }

    public void init(CharSequence host, int port, byte[] uri, int uriLength) {
        this._host = host;
        this._port = port;
        this._uri = uri;
        this._uriLength = uriLength;
    }

    public CharSequence getHost() {
        return this._host;
    }

    public void setHost(CharSequence host) {
        this._host = host;
    }

    public int getPort() {
        return this._port;
    }

    public void setPort(int port) {
        this._port = port;
    }

    public byte[] getUriBuffer() {
        return this._uri;
    }

    public int getUriLength() {
        return this._uriLength;
    }

    public int hashCode() {
        int hash = this._port + 31;
        byte[] uri = this._uri;
        int length = this._uriLength;
        for (int i = length - 1; i >= 0; --i) {
            hash = 65521 * hash + uri[i];
        }
        if (this._host != null) {
            hash = 65521 * hash + this._host.hashCode();
        }
        return hash;
    }

    public boolean equals(Object b) {
        if (!(b instanceof InvocationKey)) {
            return false;
        }
        InvocationKey test = (InvocationKey)b;
        if (this._port != test._port) {
            return false;
        }
        int length = this._uriLength;
        if (length != test._uriLength) {
            return false;
        }
        byte[] uriA = this._uri;
        byte[] uriB = test._uri;
        for (int i = length - 1; i >= 0; --i) {
            if (uriA[i] == uriB[i]) continue;
            return false;
        }
        if (this._host == null) {
            return test._host == null;
        }
        return this._host.equals(test._host);
    }

    public Object clone() {
        return new InvocationKey(this._host, this._port, this._uri, this._uriLength);
    }

    public String toString() {
        if (this._host == null) {
            return new CharBuffer().append("InvocationKey[").append(new String(this._uri, 0, this._uriLength)).append("]").toString();
        }
        return new CharBuffer().append("InvocationKey[host=").append(this._host).append(",port=").append(this._port).append(",uri=").append(new String(this._uri, 0, this._uriLength)).append("]").toString();
    }
}

