/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.host;

import com.caucho.config.Config;
import com.caucho.log.Log;
import com.caucho.server.deploy.DeployContainer;
import com.caucho.server.deploy.DeployGenerator;
import com.caucho.server.host.HostConfig;
import com.caucho.server.host.HostContainer;
import com.caucho.server.host.HostController;
import com.caucho.util.CharBuffer;
import java.util.Set;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HostSingleDeployGenerator
extends DeployGenerator<HostController> {
    private static final Logger log = Log.open(HostSingleDeployGenerator._resin_compat_class_0());
    private HostContainer _container;
    private HostConfig _config;
    private HostController _controller;
    private static Class _resin_compat_class_0;

    public HostSingleDeployGenerator(DeployContainer<HostController> container) {
        super(container);
    }

    public HostSingleDeployGenerator(DeployContainer<HostController> container, HostContainer hostContainer, HostConfig config) throws Exception {
        super(container);
        this._container = hostContainer;
        this._config = config;
        this.init();
    }

    public HostContainer getContainer() {
        return this._container;
    }

    @Override
    public ClassLoader getParentClassLoader() {
        return this._container.getClassLoader();
    }

    @Override
    protected Logger getLog() {
        return log;
    }

    public void init() throws Exception {
        String rawHostName = this._config.getId();
        String hostName = Config.evalString(rawHostName);
        this._controller = new HostController(hostName, this._config, this._container, null);
        this._controller.init();
    }

    @Override
    protected void fillDeployedKeys(Set<String> keys) {
        keys.add(this._controller.getName());
    }

    @Override
    public HostController generateController(String name) {
        if (this._controller.isNameMatch(name)) {
            return this._controller;
        }
        return null;
    }

    @Override
    public HostController mergeController(HostController controller, String name) {
        if (controller.getRootDirectory().equals(this._controller.getRootDirectory())) {
            return controller.merge(this._controller);
        }
        if (!this._controller.isNameMatch(name)) {
            return controller;
        }
        return this._controller;
    }

    public String toString() {
        return new CharBuffer().append("HostDeploy[").append(this._config.getHostName()).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.server.host.HostSingleDeployGenerator");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

