/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.host;

import com.caucho.config.Config;
import com.caucho.log.Log;
import com.caucho.server.deploy.DeployConfig;
import com.caucho.server.deploy.DeployContainer;
import com.caucho.server.deploy.DeployGenerator;
import com.caucho.server.host.HostConfig;
import com.caucho.server.host.HostContainer;
import com.caucho.server.host.HostController;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HostRegexpDeployGenerator
extends DeployGenerator<HostController> {
    private static final Logger log = Log.open(HostRegexpDeployGenerator._resin_compat_class_0());
    private HostContainer _container;
    private HostConfig _config;
    private ArrayList<HostConfig> _hostDefaults = new ArrayList();
    private ArrayList<HostController> _entries = new ArrayList();
    private static Class _resin_compat_class_0;

    public HostRegexpDeployGenerator(DeployContainer<HostController> container) {
        super(container);
    }

    public HostRegexpDeployGenerator(DeployContainer<HostController> container, HostContainer hostContainer, HostConfig config) {
        super(container);
        this.setContainer(hostContainer);
        this._config = config;
    }

    public HostContainer getContainer() {
        return this._container;
    }

    public void setContainer(HostContainer container) {
        this._container = container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public HostController generateController(String name) {
        Pattern regexp = this._config.getRegexp();
        Matcher matcher = regexp.matcher(name);
        if (!matcher.find()) return null;
        if (matcher.start() != 0) {
            return null;
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.getParentClassLoader());
            int length = matcher.end() - matcher.start();
            String hostName = matcher.group();
            ArrayList<String> vars = new ArrayList<String>();
            HashMap<String, Object> varMap = new HashMap<String, Object>();
            for (int j = 0; j <= matcher.groupCount(); ++j) {
                vars.add(matcher.group(j));
                varMap.put(new CharBuffer().append("host").append(j).toString(), matcher.group(j));
            }
            varMap.put("regexp", vars);
            if (this._config.getHostName() != null) {
                try {
                    hostName = Config.evalString(this._config.getHostName(), varMap);
                }
                catch (Exception e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
            HostController controller = new HostController(name, this._config, this._container, varMap);
            controller.setRegexpName(name);
            controller.setRegexp(regexp);
            controller.setRootDirectoryPattern(this._config.getRootDirectory());
            for (int i = 0; i < this._hostDefaults.size(); ++i) {
                controller.addConfigDefault((DeployConfig)this._hostDefaults.get(i));
            }
            controller.init();
            Path rootDir = controller.getRootDirectory();
            if (rootDir == null || !rootDir.canRead()) {
                HostController hostController = null;
                return hostController;
            }
            Object object = this._entries;
            synchronized (object) {
                for (int i = 0; i < this._entries.size(); ++i) {
                    HostController oldController = this._entries.get(i);
                    if (!rootDir.equals(oldController.getRootDirectory())) continue;
                    HostController hostController = oldController;
                    return hostController;
                }
                this._entries.add(controller);
            }
            object = controller;
            return object;
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    @Override
    public void destroy() {
    }

    public String toString() {
        return new CharBuffer().append("HostRegexpDeployGenerator[").append(this._config).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.server.host.HostSingleDeployGenerator");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

