/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.host;

import com.caucho.jmx.AdminAttributeCategory;
import com.caucho.jmx.AdminInfo;
import com.caucho.server.deploy.DeployControllerAdmin;
import com.caucho.server.host.Host;
import com.caucho.server.host.HostController;
import com.caucho.server.host.mbean.HostMBean;
import com.caucho.server.webapp.WebAppController;
import com.caucho.server.webapp.mbean.WebAppMBean;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import java.util.ArrayList;
import javax.management.ObjectName;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HostAdmin
extends DeployControllerAdmin<HostController>
implements HostMBean {
    private static final L10N L = new L10N(HostAdmin._resin_compat_class_0());
    private static Class _resin_compat_class_0;

    public HostAdmin(HostController controller) {
        super(controller);
    }

    @Override
    public AdminInfo getAdminInfo() {
        AdminInfo descriptor = super.getAdminInfo();
        String hostName = this.getHostName();
        if (hostName == null || hostName.length() == 0) {
            hostName = "*";
        }
        descriptor.setTitle(L.l("Host {0}", hostName));
        descriptor.createAdminAttributeInfo("HostName").setCategory(AdminAttributeCategory.CONFIGURATION);
        descriptor.createAdminAttributeInfo("URL").setCategory(AdminAttributeCategory.CONFIGURATION);
        descriptor.createAdminAttributeInfo("RootDirectory").setCategory(AdminAttributeCategory.CONFIGURATION);
        boolean isDocumentDirectoryIgnored = this.getDocumentDirectory().equals(this.getRootDirectory());
        descriptor.createAdminAttributeInfo("DocumentDirectory").setCategory(AdminAttributeCategory.CONFIGURATION).setIgnored(isDocumentDirectoryIgnored);
        descriptor.createAdminAttributeInfo("WebAppObjectNames").setCategory(AdminAttributeCategory.CHILD);
        descriptor.createAdminAttributeInfo("WebAppNames").setCategory(AdminAttributeCategory.CHILD).setDeprecated("3.0.15 Use WebAppObjectNames");
        descriptor.createAdminAttributeInfo("WebApps").setDeprecated("3.0.15 Use WebAppNames");
        descriptor.createAdminAttributeInfo("WarDirectory").setIgnored(true);
        descriptor.createAdminAttributeInfo("WarExpandDirectory").setIgnored(true);
        descriptor.createAdminAttributeInfo("UpdateWebAppDeploy").setIgnored(true);
        descriptor.createAdminAttributeInfo("UpdateEarDeploy").setIgnored(true);
        descriptor.createAdminAttributeInfo("ExpandEarDeploy").setIgnored(true);
        descriptor.createAdminAttributeInfo("StartEarDeploy").setIgnored(true);
        return descriptor;
    }

    public String getName() {
        return ((HostController)this.getController()).getName();
    }

    @Override
    public String getHostName() {
        return ((HostController)this.getController()).getHostName();
    }

    @Override
    public ObjectName getObjectName() {
        return ((HostController)this.getController()).getObjectName();
    }

    @Override
    public String getURL() {
        Host host = this.getHost();
        if (host != null) {
            return host.getURL();
        }
        return null;
    }

    @Override
    public String getRootDirectory() {
        Path path = null;
        Host host = this.getHost();
        if (host != null) {
            path = host.getRootDirectory();
        }
        if (path != null) {
            return path.getNativePath();
        }
        return null;
    }

    @Override
    public String getDocumentDirectory() {
        Path path = null;
        Host host = this.getHost();
        if (host != null) {
            path = host.getDocumentDirectory();
        }
        if (path != null) {
            return path.getNativePath();
        }
        return null;
    }

    @Override
    public String getWarDirectory() {
        Path path = null;
        Host host = this.getHost();
        if (host != null) {
            path = host.getWarDir();
        }
        if (path != null) {
            return path.getNativePath();
        }
        return null;
    }

    @Override
    public String getWarExpandDirectory() {
        Path path = null;
        Host host = this.getHost();
        if (host != null) {
            path = host.getWarExpandDir();
        }
        if (path != null) {
            return path.getNativePath();
        }
        return null;
    }

    @Override
    public void updateWebAppDeploy(String name) throws Throwable {
        Host host = this.getHost();
        if (host != null) {
            host.updateWebAppDeploy(name);
        }
    }

    @Override
    public void updateEarDeploy(String name) throws Throwable {
        Host host = this.getHost();
        if (host != null) {
            host.updateEarDeploy(name);
        }
    }

    @Override
    public void expandEarDeploy(String name) {
        Host host = this.getHost();
        if (host != null) {
            host.expandEarDeploy(name);
        }
    }

    @Override
    public void startEarDeploy(String name) {
        Host host = this.getHost();
        if (host != null) {
            host.startEarDeploy(name);
        }
    }

    @Override
    public ObjectName[] getWebAppObjectNames() {
        Host host = this.getHost();
        if (host == null) {
            return new ObjectName[0];
        }
        ArrayList<WebAppController> webappList = host.getApplicationList();
        int size = webappList.size();
        ArrayList<ObjectName> webappNameList = new ArrayList<ObjectName>(size);
        for (int i = 0; i < size; ++i) {
            ObjectName name = webappList.get(i).getObjectName();
            if (name == null) continue;
            webappNameList.add(name);
        }
        ObjectName[] webappNames = new ObjectName[webappNameList.size()];
        webappNames = webappNameList.toArray(webappNames);
        return webappNames;
    }

    @Override
    public final ObjectName[] getWebAppNames() {
        return this.getWebAppObjectNames();
    }

    public WebAppMBean[] getWebApps() {
        Host host = this.getHost();
        if (host == null) {
            return new WebAppMBean[0];
        }
        ArrayList<WebAppController> webappList = host.getApplicationList();
        WebAppMBean[] webapps = new WebAppMBean[webappList.size()];
        for (int i = 0; i < webapps.length; ++i) {
            WebAppController controller = webappList.get(i);
            webapps[i] = controller.getAdmin();
        }
        return webapps;
    }

    protected Host getHost() {
        return (Host)((HostController)this.getController()).getDeployInstance();
    }

    @Override
    public String toString() {
        return new CharBuffer().append("HostAdmin[").append(this.getName()).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.server.host.HostAdmin");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

