/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.host;

import com.caucho.config.ConfigException;
import com.caucho.config.SchemaBean;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.loader.EnvironmentBean;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.log.Log;
import com.caucho.make.AlwaysModified;
import com.caucho.make.Dependency;
import com.caucho.server.cluster.Cluster;
import com.caucho.server.deploy.EnvironmentDeployInstance;
import com.caucho.server.dispatch.ExceptionFilterChain;
import com.caucho.server.dispatch.Invocation;
import com.caucho.server.host.HostContainer;
import com.caucho.server.host.HostController;
import com.caucho.server.webapp.ApplicationContainer;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Host
extends ApplicationContainer
implements EnvironmentBean,
Dependency,
SchemaBean,
EnvironmentDeployInstance {
    static final Logger log = Log.open(Host._resin_compat_class_0());
    static final L10N L = new L10N(Host._resin_compat_class_0());
    private HostContainer _parent;
    private HostController _hostEntry;
    private String _hostName = "";
    private String _url;
    private String _serverName = "";
    private int _serverPort = 0;
    private String _secureHostName;
    private boolean _isDefaultHost;
    private ArrayList<String> _aliasList = new ArrayList();
    private Throwable _configException;
    private boolean _isRootDirSet;
    private boolean _isDocDirSet;
    private final Lifecycle _lifecycle;
    private String _configETag = null;
    private static Class _resin_compat_class_0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Host(HostContainer parent, HostController hostEntry, String hostName) {
        super(new EnvironmentClassLoader());
        try {
            this._hostEntry = hostEntry;
            this.setParent(parent);
            this.setHostName(hostName);
        }
        catch (Throwable e) {
            this._configException = e;
        }
        finally {
            this._lifecycle = new Lifecycle(log, this.toString(), Level.INFO);
        }
    }

    private void setHostName(String name) throws ConfigException {
        this._hostName = name;
        if (name.equals("")) {
            this._isDefaultHost = true;
        }
        this.addHostAlias(name);
        this.getEnvironmentClassLoader().setId(new CharBuffer().append("host:").append(name).toString());
        int p = name.indexOf("://");
        if (p >= 0) {
            name = name.substring(p + 3);
        }
        this._serverName = name;
        p = name.lastIndexOf(58);
        if (p > 0) {
            this._serverName = name.substring(0, p);
            boolean isPort = true;
            int port = 0;
            ++p;
            while (p < name.length()) {
                char ch = name.charAt(p);
                if ('0' <= ch && ch <= '9') {
                    port = 10 * port + ch - 48;
                } else {
                    isPort = false;
                }
                ++p;
            }
            if (isPort) {
                this._serverPort = port;
            }
        }
    }

    public String getName() {
        return this._hostEntry.getName();
    }

    @Override
    public String getHostName() {
        return this._hostName;
    }

    public String getSecureHostName() {
        return this._secureHostName;
    }

    public void setSecureHostName(String secureHostName) {
        this._secureHostName = secureHostName;
    }

    @Override
    public String getSchema() {
        return "com/caucho/server/host/host.rnc";
    }

    @Override
    public String getURL() {
        if (this._url != null) {
            return this._url;
        }
        if (this._hostName == null || this._hostName.equals("")) {
            return "";
        }
        if (this._hostName.startsWith("http:") || this._hostName.startsWith("https:")) {
            return this._hostName;
        }
        return new CharBuffer().append("http://").append(this._hostName).toString();
    }

    public void addHostAlias(String name) {
        if (!this._aliasList.contains(name = name.toLowerCase())) {
            this._aliasList.add(name);
        }
        if (name.equals("") || name.equals("*")) {
            this._isDefaultHost = true;
        }
        this._hostEntry.addExtHostAlias(name);
    }

    public ArrayList<String> getAliasList() {
        return this._aliasList;
    }

    public boolean isDefaultHost() {
        return this._isDefaultHost;
    }

    private void setParent(HostContainer parent) {
        this._parent = parent;
        this.setDispatchServer(parent.getDispatchServer());
        if (!this._isRootDirSet) {
            this.setRootDirectory(parent.getRootDirectory());
            this._isRootDirSet = false;
        }
    }

    public EnvironmentClassLoader getEnvironmentClassLoader() {
        return (EnvironmentClassLoader)this.getClassLoader();
    }

    @Override
    public void setRootDirectory(Path rootDir) {
        super.setRootDirectory(rootDir);
        this._isRootDirSet = true;
        if (!this._isDocDirSet) {
            this.setDocumentDirectory(rootDir);
            this._isDocDirSet = false;
        }
    }

    @Override
    public void setDocumentDirectory(Path docDir) {
        super.setDocumentDirectory(docDir);
        this._isDocDirSet = true;
    }

    @Override
    public void setConfigException(Throwable e) {
        if (e != null) {
            this._configException = e;
            this.getEnvironmentClassLoader().addDependency(AlwaysModified.create());
        }
    }

    @Override
    public Throwable getConfigException() {
        return this._configException;
    }

    public Cluster getCluster() {
        return Cluster.getCluster(this.getClassLoader());
    }

    public String getConfigETag() {
        return this._configETag;
    }

    public void setConfigETag(String etag) {
        this._configETag = etag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        if (!this._lifecycle.toStarting()) {
            return;
        }
        if (this.getURL().equals("") && this._parent != null) {
            this._url = this._parent.getURL();
        }
        EnvironmentClassLoader loader = this.getEnvironmentClassLoader();
        loader.setId(new CharBuffer().append("host:").append(this.getURL()).toString());
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(loader);
            super.start();
            loader.start();
        }
        finally {
            this._lifecycle.toActive();
            thread.setContextClassLoader(oldLoader);
        }
    }

    @Override
    public void clearCache() {
        super.clearCache();
        this.setConfigETag(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void buildInvocation(Invocation invocation) throws Exception {
        invocation.setHostName(this._serverName);
        invocation.setPort(this._serverPort);
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.getClassLoader());
            if (this._configException == null) {
                super.buildInvocation(invocation);
            } else {
                invocation.setFilterChain(new ExceptionFilterChain(this._configException));
                invocation.setDependency(AlwaysModified.create());
            }
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    @Override
    public boolean isModified() {
        return this.isDestroyed() || this.getEnvironmentClassLoader().isModified();
    }

    @Override
    public boolean isModifiedNow() {
        return this.isDestroyed() || this.getEnvironmentClassLoader().isModifiedNow();
    }

    @Override
    public boolean isDeployError() {
        return this._configException != null;
    }

    @Override
    public boolean isDeployIdle() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean stop() {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            EnvironmentClassLoader envLoader = this.getEnvironmentClassLoader();
            thread.setContextClassLoader(envLoader);
            if (!this._lifecycle.toStopping()) {
                boolean bl = false;
                return bl;
            }
            super.stop();
            envLoader.stop();
            boolean bl = true;
            return bl;
        }
        finally {
            this._lifecycle.toStop();
            thread.setContextClassLoader(oldLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        this.stop();
        if (this.isDestroyed()) {
            return;
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        EnvironmentClassLoader classLoader = this.getEnvironmentClassLoader();
        thread.setContextClassLoader(classLoader);
        try {
            super.destroy();
        }
        finally {
            thread.setContextClassLoader(oldLoader);
            classLoader.destroy();
        }
    }

    public String toString() {
        return new CharBuffer().append("Host[").append(this.getHostName()).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.server.host.Host");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

