/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.e_app;

import com.caucho.log.Log;
import com.caucho.server.deploy.EnvironmentDeployController;
import com.caucho.server.e_app.EarConfig;
import com.caucho.server.e_app.EnterpriseApplication;
import com.caucho.server.webapp.ApplicationContainer;
import com.caucho.server.webapp.WebAppController;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.jsp.el.ELException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EarDeployController
extends EnvironmentDeployController<EnterpriseApplication, EarConfig> {
    private static final Logger log = Log.open(EarDeployController._resin_compat_class_0());
    private static final L10N L = new L10N(EarDeployController._resin_compat_class_0());
    private ApplicationContainer _container;
    private Path _earRootDir;
    private ArrayList<EarConfig> _eAppDefaults = new ArrayList();
    private static Class _resin_compat_class_0;

    EarDeployController(String name, ApplicationContainer container, EarConfig config) {
        super(config);
        this._container = container;
        if (container != null) {
            this._eAppDefaults.addAll(container.getEarDefaultList());
        }
    }

    EarDeployController(String name, Path rootDirectory, ApplicationContainer container) {
        super(name, rootDirectory);
        this._container = container;
        if (container != null) {
            this._eAppDefaults.addAll(container.getEarDefaultList());
        }
    }

    public void setId(String name) {
        this.getVariableMap().put("name", name);
    }

    public Path getEarRootDir() {
        return this._earRootDir;
    }

    public void setEarRootDir(Path rootDir) {
        this._earRootDir = rootDir;
    }

    public WebAppController findWebAppController(String name) {
        try {
            EnterpriseApplication eApp = (EnterpriseApplication)this.request();
            if (eApp != null) {
                return eApp.findWebAppEntry(name);
            }
            return null;
        }
        catch (Throwable e) {
            log.log(Level.FINER, e.toString(), e);
            return null;
        }
    }

    @Override
    protected EnterpriseApplication instantiateDeployInstance() {
        return new EnterpriseApplication(this._container, this, this.getId());
    }

    @Override
    protected String getMBeanTypeName() {
        return "EApp";
    }

    protected Path calculateRootDirectory() throws ELException {
        Path rootDir = this.getRootDirectory();
        EnterpriseApplication eApp = (EnterpriseApplication)this.getDeployInstance();
        if (rootDir == null && eApp != null) {
            rootDir = eApp.getRootDirectory();
        }
        return rootDir;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof EarDeployController)) {
            return false;
        }
        EarDeployController entry = (EarDeployController)o;
        return this.getId().equals(entry.getId());
    }

    @Override
    public String toString() {
        return new CharBuffer().append("EarDeployController[").append(this.getId()).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.server.e_app.EarDeployController");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

