/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.dispatch;

import com.caucho.config.BuilderProgram;
import com.caucho.config.BuilderProgramContainer;
import com.caucho.config.types.RawString;
import com.caucho.el.EL;
import com.caucho.el.MapVariableResolver;
import com.caucho.server.dispatch.ServletConfigImpl;
import com.caucho.server.dispatch.ServletManager;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.jsp.el.VariableResolver;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletRegexp {
    private static final L10N L = new L10N(ServletRegexp._resin_compat_class_0());
    private String _urlRegexp;
    private String _servletName;
    private String _servletClassName;
    private BuilderProgramContainer _program = new BuilderProgramContainer();
    private static Class _resin_compat_class_0;

    public void setURLRegexp(String pattern) {
        this._urlRegexp = pattern;
    }

    public String getURLRegexp() {
        return this._urlRegexp;
    }

    public void setServletName(RawString string) {
        this._servletName = string.getValue();
    }

    public String getServletName() {
        return this._servletName;
    }

    public void setServletClass(RawString string) {
        this._servletClassName = string.getValue();
    }

    public String getServletClass() {
        return this._servletClassName;
    }

    public void addBuilderProgram(BuilderProgram program) {
        this._program.addProgram(program);
    }

    public BuilderProgram getBuilderProgram() {
        return this._program;
    }

    String initRegexp(ServletContext application, ServletManager manager, ArrayList<String> vars) throws ServletException {
        VariableResolver env = EL.getEnvironment();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("regexp", vars);
        MapVariableResolver mapEnv = new MapVariableResolver(map, env);
        String rawName = this._servletName;
        String rawClassName = this._servletClassName;
        if (rawName == null) {
            rawName = rawClassName;
        }
        try {
            String servletName = EL.evalString(rawName, mapEnv);
            if (manager.getServletConfig(servletName) != null) {
                return servletName;
            }
            String className = EL.evalString(rawClassName, mapEnv);
            ServletConfigImpl config = new ServletConfigImpl();
            config.setServletName(servletName);
            config.setServletClass(className);
            config.setServletContext(application);
            this._program.configure(config);
            config.init();
            manager.addServlet(config);
            return servletName;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServletException(e);
        }
    }

    public String toString() {
        return new CharBuffer().append("ServletRegexp[").append(this._urlRegexp).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.server.dispatch.ServletRegexp");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

