/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.dispatch;

import com.caucho.config.types.InitProgram;
import com.caucho.el.EL;
import com.caucho.el.MapVariableResolver;
import com.caucho.server.dispatch.ServletConfigImpl;
import com.caucho.server.dispatch.ServletManager;
import com.caucho.server.webapp.Application;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.jsp.el.VariableResolver;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletMapping
extends ServletConfigImpl {
    private static final L10N L = new L10N(ServletMapping._resin_compat_class_0());
    private String _urlPattern;
    private String _urlRegexp;
    private boolean _isStrictMapping;
    private static Class _resin_compat_class_0;

    public void setURLPattern(String pattern) {
        this._urlPattern = pattern;
    }

    public String getURLPattern() {
        return this._urlPattern;
    }

    public void setURLRegexp(String pattern) {
        this._urlRegexp = pattern;
    }

    public String getURLRegexp() {
        return this._urlRegexp;
    }

    public boolean isStrictMapping() {
        return this._isStrictMapping;
    }

    public void setStrictMapping(boolean isStrictMapping) {
        this._isStrictMapping = isStrictMapping;
    }

    @Override
    public void init() throws ServletException {
        if (this._urlRegexp == null) {
            if (this.getServletName() == null && this.getServletClassName() != null) {
                this.setServletName(this.getURLPattern());
            }
            super.init();
        }
    }

    String initRegexp(ServletContext application, ServletManager manager, ArrayList<String> vars) throws ServletException {
        VariableResolver env = EL.getEnvironment();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("regexp", vars);
        MapVariableResolver mapEnv = new MapVariableResolver(map, env);
        String rawName = this.getServletName();
        String rawClassName = this.getServletClassName();
        if (rawName == null) {
            rawName = rawClassName;
        }
        if (rawClassName == null) {
            rawClassName = rawName;
        }
        try {
            String servletName = EL.evalString(rawName, mapEnv);
            if (manager.getServletConfig(servletName) != null) {
                return servletName;
            }
            String className = EL.evalString(rawClassName, mapEnv);
            try {
                Application app = (Application)this.getServletContext();
                Class<?> cl = Class.forName(className, false, app.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                log.log(Level.WARNING, e.toString(), e);
                return null;
            }
            ServletConfigImpl config = new ServletConfigImpl();
            config.setServletName(servletName);
            config.setServletClass(className);
            config.setServletContext(application);
            InitProgram program = this.getInit();
            if (program != null) {
                program.init(config);
            }
            config.init();
            manager.addServlet(config);
            return servletName;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServletException(e);
        }
    }

    @Override
    public String toString() {
        return new CharBuffer().append("ServletMapping[pattern=").append(this._urlPattern).append(",name=").append(this.getServletName()).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.server.dispatch.ServletMapping");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

