/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.dispatch;

import com.caucho.jsp.Page;
import com.caucho.jsp.QServlet;
import com.caucho.log.Log;
import com.caucho.server.dispatch.ServletConfigImpl;
import com.caucho.util.L10N;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Logger;
import javax.servlet.FilterChain;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.SingleThreadModel;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PageFilterChain
implements FilterChain {
    private static final Logger log = Log.open(PageFilterChain._resin_compat_class_0());
    private static final L10N L = new L10N(PageFilterChain._resin_compat_class_0());
    private ServletContext _application;
    private QServlet _servlet;
    private String _jspFile;
    private ServletConfigImpl _config;
    private ServletContext _servletContext;
    private Page _page;
    private boolean _isSingleThread;
    private static Class _resin_compat_class_0;

    PageFilterChain(ServletContext application, QServlet servlet) {
        this._application = application;
        this._servlet = servlet;
    }

    PageFilterChain(ServletContext application, QServlet servlet, String jspFile, ServletConfigImpl config) {
        this._application = application;
        this._servlet = servlet;
        this._jspFile = jspFile;
        this._config = config;
    }

    public void setServletContext(ServletContext servletContext) {
        this._servletContext = servletContext;
    }

    public ServletContext getServletContext() {
        return this._servletContext;
    }

    public QServlet getServlet() {
        return this._servlet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        FileNotFoundException notFound = null;
        Page page = this._page;
        if (page == null || page.cauchoIsModified()) {
            try {
                page = this.compilePage(page, req, res);
            }
            catch (FileNotFoundException e) {
                page = null;
                notFound = e;
            }
        }
        if (page == null) {
            if (notFound == null) {
                return;
            }
            String errorUri = (String)req.getAttribute("javax.servlet.error.request_uri");
            String uri = (String)req.getAttribute("javax.servlet.include.request_uri");
            String forward = (String)req.getAttribute("caucho.forward");
            if (errorUri != null) {
                throw new FileNotFoundException(errorUri);
            }
            if (uri != null) {
                throw new FileNotFoundException(uri);
            }
            if (forward != null) {
                throw new FileNotFoundException(req.getRequestURI());
            }
            res.sendError(404);
        } else if (req instanceof HttpServletRequest) {
            if (this._isSingleThread) {
                Page page2 = page;
                synchronized (page2) {
                    page.pageservice(req, res);
                }
            } else {
                page.pageservice(req, res);
            }
        }
    }

    private Page compilePage(Page oldPage, HttpServletRequest req, HttpServletResponse res) throws ServletException, FileNotFoundException {
        Page newPage = null;
        if (oldPage != null && !oldPage.startRecompiling()) {
            return this._page;
        }
        try {
            ServletConfig config;
            if (this._jspFile != null) {
                req.setAttribute("caucho.jsp.jsp-file", (Object)this._jspFile);
                req.setAttribute("caucho.jsp.servlet-config", (Object)this._config);
            }
            if (this._config != null) {
                newPage = (Page)this._config.createServlet();
            } else {
                newPage = this._servlet.getPage(req, res);
                if (newPage != null && !newPage.isInit()) {
                    config = new ServletConfigImpl();
                    config.setServletContext(this._application);
                    newPage.init(config);
                }
            }
            if (oldPage != null && !oldPage.isDead()) {
                oldPage.destroy();
            }
            if (newPage != null) {
                newPage._caucho_use();
            }
            config = newPage;
            return config;
        }
        catch (ServletException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            this._page = newPage;
            this._isSingleThread = newPage instanceof SingleThreadModel;
            if (this._jspFile != null) {
                req.removeAttribute("caucho.jsp.jsp-file");
                req.removeAttribute("caucho.jsp.servlet-config");
            }
        }
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.server.dispatch.PageFilterChain");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

